/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.base;

import it.unimi.dsi.fastutil.longs.Long2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import pregenerator.common.base.PregenTaskEvent;
import pregenerator.common.base.SimpleTaskStorage;
import pregenerator.common.generator.tasks.ITask;

public class GenTaskStorage
extends SimpleTaskStorage<ITask> {
    Object2ObjectMap<String, ExecutionMemory> memory = new Object2ObjectLinkedOpenHashMap();

    public GenTaskStorage(Runnable dirtyCall) {
        super(dirtyCall, ITask::loadTask, ITask::saveTask);
    }

    @Override
    public void read(CompoundTag nbt) {
        super.read(nbt);
        ListTag list = nbt.getList("memory", 10);
        int m = list.size();
        for (int i = 0; i < m; ++i) {
            CompoundTag data = list.getCompound(i);
            this.memory.put((Object)data.getString("id"), (Object)new ExecutionMemory(this.getDirtyCall()).read(data));
        }
    }

    @Override
    public CompoundTag write(CompoundTag compound) {
        super.write(compound);
        ListTag data = new ListTag();
        for (Object2ObjectMap.Entry entry : Object2ObjectMaps.fastIterable(this.memory)) {
            CompoundTag nbt = new CompoundTag();
            ((ExecutionMemory)entry.getValue()).write(nbt);
            nbt.putString("id", (String)entry.getKey());
            data.add((Object)nbt);
        }
        compound.put("memory", (Tag)data);
        return compound;
    }

    public boolean contains(UUID id) {
        for (ITask task : this.taskStorage.values()) {
            if (!task.getTaskId().equals(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        super.clear();
        NeoForge.EVENT_BUS.post((Event)new PregenTaskEvent.Cleared());
    }

    @Override
    public boolean removeTask(String name) {
        ITask task = (ITask)this.getTask(name);
        if (super.removeTask(name)) {
            this.memory.keySet().retainAll(this.getTasks());
            if (task != null) {
                NeoForge.EVENT_BUS.post((Event)new PregenTaskEvent.Removed(task));
            }
            return true;
        }
        return false;
    }

    public ExecutionMemory getMemory(String name) {
        return (ExecutionMemory)this.memory.computeIfAbsent((Object)name, T -> {
            this.markDirty();
            return new ExecutionMemory(this.getDirtyCall());
        });
    }

    public static class ExecutionMemory {
        Long2ByteMap chunkMemory = new Long2ByteLinkedOpenHashMap();
        Runnable dirty;

        public ExecutionMemory(Runnable dirty) {
            this.dirty = dirty;
        }

        public ExecutionMemory read(CompoundTag nbt) {
            ListTag list = nbt.getList("data", 10);
            int m = list.size();
            for (int i = 0; i < m; ++i) {
                CompoundTag data = list.getCompound(i);
                this.chunkMemory.put(data.getLong("k"), data.getByte("v"));
            }
            return this;
        }

        public CompoundTag write(CompoundTag nbt) {
            ListTag list = new ListTag();
            for (Long2ByteMap.Entry entry : Long2ByteMaps.fastIterable((Long2ByteMap)this.chunkMemory)) {
                CompoundTag data = new CompoundTag();
                data.putLong("k", entry.getLongKey());
                data.putByte("v", entry.getByteValue());
                list.add((Object)data);
            }
            nbt.put("data", (Tag)list);
            return nbt;
        }

        public void addEntry(ChunkPos pos, int value) {
            this.chunkMemory.put(pos.toLong(), (byte)value);
            this.dirty.run();
        }

        public void addEntry(ChunkPos pos, boolean value) {
            this.chunkMemory.put(pos.toLong(), (byte)(value ? 2 : 1));
            this.dirty.run();
        }

        public byte getState(long pos) {
            return this.chunkMemory.get(pos);
        }
    }
}

