/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.info;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.components.Button;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import pregenerator.PregenConfig;
import pregenerator.base.api.Align;
import pregenerator.base.api.IRenderHelper;
import pregenerator.base.api.TextUtil;
import pregenerator.base.impl.comp.PregenButton;
import pregenerator.client.info.IProcessorInfo;
import pregenerator.client.info.IRenderObj;
import pregenerator.common.networking.NetworkManager;
import pregenerator.common.networking.packets.ProgressPacket;

public class AgeProcessorInfo
implements IProcessorInfo {
    List<IRenderObj> objects = new ObjectArrayList();
    float height = 0.0f;
    UUID taskId;

    @Override
    public void setTaskId(UUID id) {
        this.taskId = id;
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)buffer.readResourceLocation());
        int filesScanned = buffer.readVarInt();
        int totalFiles = buffer.readVarInt();
        long chunksScanned = buffer.readLong();
        long totalChunks = buffer.readLong();
        this.objects.clear();
        this.objects.add(new HeaderMenu(this));
        this.objects.add(IRenderObj.text("ui.chunk_pregen.age_scan.header", Align.CENTER));
        this.objects.add(IRenderObj.text("ui.chunk_pregen.age_scan.dimension", TextUtil.dimension((ResourceKey<Level>)dimension)));
        this.objects.add(IRenderObj.bar("ui.chunk_pregen.age_scan.files", filesScanned, totalFiles, totalFiles == 0 ? 0.0f : (float)filesScanned / (float)totalFiles));
        this.objects.add(IRenderObj.bar("ui.chunk_pregen.age_scan.chunks", chunksScanned, totalChunks, totalChunks == 0L ? 0.0f : (float)chunksScanned / (float)totalChunks));
        this.objects.add(new FooterMenu(this.taskId));
        this.height = IRenderObj.height(this.objects);
    }

    @Override
    public void render(IRenderHelper helper, int x, int y, float scale) {
        helper.setupCanvasSize(100.0f);
        helper.drawArea(x, y, 100.0f, this.height - 2.0f);
        float yOffset = 3.0f;
        for (IRenderObj obj : this.objects) {
            obj.render(helper, x + 4, (float)y + yOffset, 100.0f, scale);
            yOffset += obj.height();
        }
    }

    @Override
    public boolean onClick(int mouseX, int mouseY) {
        for (IRenderObj obj : this.objects) {
            if (!obj.onClick(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getID() {
        return 3;
    }

    @Override
    public int getWidth() {
        return 109;
    }

    @Override
    public int getHeight() {
        return (int)this.height + 6;
    }

    @OnlyIn(value=Dist.CLIENT)
    public class HeaderMenu
    extends IRenderObj.Interactable {
        PregenButton close = this.addChild(new PregenButton(0, 0, 12, 12, (Component)TextUtil.literal("X"), this::onClose));

        public HeaderMenu(AgeProcessorInfo this$0) {
        }

        @Override
        public float height() {
            return 0.0f;
        }

        private void onClose(Button button) {
            PregenConfig.INSTANCE.pregenOverlay.setEnabled(false);
            PregenConfig.INSTANCE.save();
        }

        @Override
        public void setupInteractables(float x, float y, float width, float scale, float posScale) {
            this.close.setX((int)((x + width - 2.0f) * posScale) - (int)((float)this.close.getWidth() * 0.5f * scale));
            this.close.setY((int)((y - 1.0f) * posScale));
        }
    }

    public static class FooterMenu
    extends IRenderObj.Interactable {
        PregenButton remove = this.addChild(new PregenButton(0, 0, 50, 14, (Component)TextUtil.translate("ui.chunk_pregen.deleter.stop"), this::onRemove));
        UUID taskId;

        public FooterMenu(UUID taskId) {
            this.taskId = taskId;
        }

        @Override
        public float height() {
            return 7.0f;
        }

        private void onRemove(Button button) {
            NetworkManager.INSTANCE.sendToServer(new ProgressPacket.Cancel(this.taskId));
        }

        @Override
        public void setupInteractables(float x, float y, float width, float scale, float posScale) {
            this.remove.setX((int)(x * posScale));
            this.remove.setY((int)(y * posScale));
        }
    }
}

