/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.impl.comp;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import pregenerator.base.api.Align;
import pregenerator.base.api.TextUtil;
import pregenerator.base.impl.BasePregenScreen;
import pregenerator.base.impl.comp.PregenButton;

public class PregenSlider
extends PregenButton {
    private static final ResourceLocation SLIDER_SPRITE = ResourceLocation.parse((String)"widget/slider");
    private static final ResourceLocation SLIDER_HANDLE_SPRITE = ResourceLocation.parse((String)"widget/slider_handle");
    private static final ResourceLocation SLIDER_HANDLE_HIGHLIGHTED_SPRITE = ResourceLocation.parse((String)"widget/slider_handle_highlighted");
    SliderState state;

    public PregenSlider(int xPos, int yPos, int width, int height, SliderState state) {
        super(xPos, yPos, width, height, state.getCurrentDisplayText(), null);
        state.owner = this;
        this.state = state;
    }

    protected void onValueChanged() {
        if (this.state.listener != null) {
            this.state.listener.accept(this);
        }
    }

    public void updateMessage() {
        this.setMessage(this.state.getCurrentDisplayText());
    }

    public SliderState getState() {
        return this.state;
    }

    public int get() {
        return this.state.get();
    }

    public double getProgress() {
        return (double)(this.state.get() - this.state.getMin()) / (double)this.state.getRange();
    }

    protected void setFromMouse(double mouseX) {
        double progress = Math.max(0.0, Math.min(1.0, (mouseX - ((double)this.getX() + 4.0)) / ((double)this.width - 8.0)));
        this.state.set((int)((double)this.state.getMin() + (double)this.state.getRange() * progress));
    }

    public void onClick(double mouseX, double mouseY) {
        this.setFromMouse(mouseX);
    }

    protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
        this.setFromMouse(mouseX);
        super.onDrag(mouseX, mouseY, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double xScroll, double yScroll) {
        if (this.state.stepSize != 0 && this.active && this.visible) {
            this.state.set(this.get() + (int)((double)this.state.stepSize * yScroll * (double)(Screen.hasShiftDown() ? 10 : 1) * (double)(Screen.hasControlDown() ? 100 : 1)));
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.state.stepSize != 0 && this.active && this.visible && (keyCode == 263 || keyCode == 262)) {
            this.state.set(this.get() + this.state.stepSize * ((keyCode == 263 ? -1 : 0) + (keyCode == 262 ? 1 : 0)) * (Screen.hasShiftDown() ? 10 : 1) * (Screen.hasControlDown() ? 100 : 1));
            return true;
        }
        return false;
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        double range = this.getProgress();
        graphics.blitSprite(this.getMainSpirte(), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        BasePregenScreen.drawScrollingShadowString(graphics, Minecraft.getInstance().font, this.getMessage(), this.getX() + 2, this.getY(), this.width - 4, this.height - 2, Align.CENTER, this.getFGColor(), this.hash);
        graphics.blitSprite(this.getHandleSprite(), this.getX() + (int)(range * (double)(this.width - 8)), this.getY(), 8, this.getHeight());
    }

    protected ResourceLocation getMainSpirte() {
        return SLIDER_SPRITE;
    }

    protected ResourceLocation getHandleSprite() {
        return this.isActive() && !this.isHovered ? SLIDER_HANDLE_SPRITE : SLIDER_HANDLE_HIGHLIGHTED_SPRITE;
    }

    public static class SliderState {
        int minValue;
        int maxValue;
        int value;
        int stepSize = 1;
        IntFunction<Component> displayText = T -> TextUtil.literal(BasePregenScreen.NUMBERS.format(T));
        Component prefix = TextUtil.empty();
        Component suffix = TextUtil.empty();
        Consumer<PregenSlider> listener;
        PregenSlider owner;

        public SliderState(int value, int minValue, int maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.value = value;
        }

        public SliderState(int value, int minValue, int maxValue, IntFunction<Component> displayText) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.value = value;
            this.displayText = Objects.requireNonNull(displayText);
        }

        public SliderState(int value, int minValue, int maxValue, Component prefix, Component suffix) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.value = value;
            this.prefix = Objects.requireNonNull(prefix);
            this.suffix = Objects.requireNonNull(suffix);
        }

        public SliderState(int value, int minValue, int maxValue, IntFunction<Component> displayText, Component prefix, Component suffix) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.value = value;
            this.displayText = Objects.requireNonNull(displayText);
            this.prefix = Objects.requireNonNull(prefix);
            this.suffix = Objects.requireNonNull(suffix);
        }

        public SliderState setListener(Consumer<PregenSlider> listener) {
            this.listener = listener;
            return this;
        }

        public SliderState setStepSize(int value) {
            this.stepSize = value;
            return this;
        }

        public SliderState setMaxValue(int maxValue) {
            if (maxValue < this.minValue) {
                return this;
            }
            this.maxValue = maxValue;
            int oldValue = this.value;
            this.value = Math.min(maxValue, this.value);
            if (this.owner != null) {
                if (oldValue != this.value) {
                    this.owner.onValueChanged();
                }
                this.owner.updateMessage();
            }
            return this;
        }

        public SliderState setMinValue(int minValue) {
            if (this.maxValue < minValue) {
                return this;
            }
            this.minValue = minValue;
            int oldValue = this.value;
            this.value = Math.max(minValue, this.value);
            if (this.owner != null) {
                if (oldValue != this.value) {
                    this.owner.onValueChanged();
                }
                this.owner.updateMessage();
            }
            return this;
        }

        public SliderState set(int value) {
            int newValue = Math.max(this.minValue, Math.min(this.maxValue, value));
            if (this.value != newValue) {
                this.value = newValue;
                if (this.owner != null) {
                    this.owner.onValueChanged();
                }
            }
            if (this.owner != null) {
                this.owner.updateMessage();
            }
            return this;
        }

        public SliderState increaseOnce() {
            return this.set(this.value + 1);
        }

        public SliderState decreaseOnce() {
            return this.set(this.value - 1);
        }

        public SliderState setPrefix(Component prefix) {
            this.prefix = Objects.requireNonNull(prefix);
            if (this.owner != null) {
                this.owner.updateMessage();
            }
            return this;
        }

        public SliderState setSuffix(Component suffix) {
            this.suffix = Objects.requireNonNull(suffix);
            if (this.owner != null) {
                this.owner.updateMessage();
            }
            return this;
        }

        public Component getCurrentDisplayText() {
            return TextUtil.empty().append(this.prefix).append(this.displayText.apply(this.value)).append(this.suffix);
        }

        public int getMin() {
            return this.minValue;
        }

        public int getMax() {
            return this.maxValue;
        }

        public int getRange() {
            return this.maxValue - this.minValue;
        }

        public int get() {
            return this.value;
        }

        public PregenSlider getOwner() {
            return this.owner;
        }
    }
}

