/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.api;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.neoforged.neoforgespi.language.IModInfo;
import org.apache.commons.lang3.time.DurationFormatUtils;
import pregenerator.PregenConfig;

public class TextUtil {
    public static final DecimalFormat NUMBERS = new DecimalFormat("###,###", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    public static final DecimalFormat FLOATING_NUMBERS = new DecimalFormat("###,###.##", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    public static final DecimalFormat FLOATING_NUMBERS_EXTENDED = new DecimalFormat("###,###.###", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    private static final DecimalFormat FORMAT = new DecimalFormat("###,###.###");
    private static final String[] DATA_TYPES = new String[]{"B", "KB", "MB", "GB", "TB", "PB"};
    private static final Map<String, MutableComponent> CACHE = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
    private static final Object2LongMap<ResourceKey<Level>> DIMENSION_SIZES = TextUtil.createData();

    private static Object2LongMap<ResourceKey<Level>> createData() {
        Object2LongOpenHashMap result = new Object2LongOpenHashMap();
        result.put((Object)Level.OVERWORLD, 10280L);
        result.put((Object)Level.NETHER, 5476L);
        result.put((Object)Level.END, 925L);
        result.defaultReturnValue(12288L);
        return result;
    }

    public static synchronized void registerDimensionSize(ResourceKey<Level> result, long bytes) {
        DIMENSION_SIZES.put(result, bytes);
    }

    private static boolean forceServerTranslate() {
        return PregenConfig.INSTANCE.forceServerTranslation.get();
    }

    public static MutableComponent empty() {
        return Component.empty();
    }

    public static MutableComponent literal(String text) {
        return Component.literal((String)text);
    }

    public static MutableComponent literalPascal(String text) {
        return Component.literal((String)TextUtil.toPascalCase(text));
    }

    public static MutableComponent translate(String text) {
        MutableComponent component = CACHE.computeIfAbsent(text, Component::translatable);
        return TextUtil.forceServerTranslate() ? TextUtil.serverTranslate((Component)component) : component;
    }

    public static MutableComponent translate(String text, Object ... args) {
        return TextUtil.forceServerTranslate() ? TextUtil.serverTranslate((Component)Component.translatable((String)text, (Object[])args)) : Component.translatable((String)text, (Object[])args);
    }

    public static MutableComponent translateStyled(String text, ChatFormatting formatting) {
        return TextUtil.translate(text).plainCopy().withStyle(formatting);
    }

    public static MutableComponent translateStyled(String text, ChatFormatting ... formatting) {
        return TextUtil.translate(text).plainCopy().withStyle(formatting);
    }

    public static MutableComponent serverTranslate(Component input) {
        MutableComponent output = TextUtil.empty();
        input.visit((K, V) -> {
            if (!V.isEmpty()) {
                output.append((Component)TextUtil.literal(V).withStyle(TextUtil.validateStyle(K)));
            }
            return Optional.empty();
        }, Style.EMPTY);
        return output;
    }

    private static Style validateStyle(Style style) {
        Component value;
        HoverEvent event = style.getHoverEvent();
        if (event != null && (value = (Component)event.getValue(HoverEvent.Action.SHOW_TEXT)) != null) {
            return style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)TextUtil.serverTranslate(value)));
        }
        return style;
    }

    public static MutableComponent guiConstructor() {
        return TextUtil.translate("gui.chunk_pregen.unused_constructor");
    }

    public static MutableComponent dimension(ResourceKey<Level> dimension) {
        String key = Util.makeDescriptionId((String)"dimension", (ResourceLocation)dimension.location());
        return Language.getInstance().has(key) ? TextUtil.translate(key) : TextUtil.literal(TextUtil.toPascalCase(dimension.location().getPath()));
    }

    public static MutableComponent biome(ResourceLocation biome) {
        String key = Util.makeDescriptionId((String)"biome", (ResourceLocation)biome);
        return Language.getInstance().has(key) ? TextUtil.translate(key) : TextUtil.literal(TextUtil.toPascalCase(biome.getPath()));
    }

    public static MutableComponent dimensionMissing() {
        return TextUtil.translate("command.chunk_pregen.error.missing_dimension");
    }

    public static MutableComponent creationFailed() {
        return TextUtil.translate("command.chunk_pregen.error.creation_failed");
    }

    public static MutableComponent impossibleScenario() {
        return TextUtil.translateStyled("queue.chunk_pregen.errors.impossible", ChatFormatting.RED);
    }

    public static MutableComponent minBiggerThenMax() {
        return TextUtil.translate("command.chunk_pregen.error.min_bigger_max");
    }

    public static MutableComponent radiusToBig() {
        return TextUtil.translate("command.chunk_pregen.error.radius_to_big");
    }

    public static MutableComponent taskOverflow(long taskSize) {
        return TextUtil.translate("command.chunk_pregen.error.task_overflow", "~" + TextUtil.findBestMemory(taskSize));
    }

    public static MutableComponent taskWarning(long taskSize, String taskId) {
        Style start = Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/pregen continue " + taskId));
        Style delete = Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/pregen clear " + taskId));
        return TextUtil.translate("command.chunk_pregen.error.task_warning", "~" + TextUtil.findBestMemory(taskSize), TextUtil.translate("command.chunk_pregen.error.task_warning.start").plainCopy().withStyle(start), TextUtil.translate("command.chunk_pregen.error.task_warning.delete").plainCopy().withStyle(delete));
    }

    public static MutableComponent taskInfo(long taskSize) {
        return TextUtil.translate("command.chunk_pregen.error.task_info", "~" + TextUtil.findBestMemory(taskSize));
    }

    public static MutableComponent ram() {
        return TextUtil.translate("process.chunk_pregen.ram", TextUtil.toMB(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()), TextUtil.toMB(Runtime.getRuntime().maxMemory()));
    }

    public static MutableComponent ram(long used, long total) {
        return TextUtil.translate("process.chunk_pregen.ram", TextUtil.toMB(used), TextUtil.toMB(total));
    }

    public static MutableComponent getModName(String id) {
        return TextUtil.literal(ModList.get().getModContainerById(id).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse("Unknown"));
    }

    public static String toPascalCase(String input) {
        StringBuilder builder = new StringBuilder();
        for (String s : input.split("[\\s-_]")) {
            builder.append(TextUtil.firstLetterUppercase(s)).append(" ");
        }
        return builder.substring(0, builder.length() - 1);
    }

    public static String findBestMemory(long input) {
        return TextUtil.findBestMemory(input, 1000);
    }

    public static String findBestMemory(long input, int threshold) {
        long actual = Math.abs(input);
        int layersFound = 0;
        for (int i = 0; i < DATA_TYPES.length && actual >= (long)threshold; ++i) {
            actual >>= 10;
            ++layersFound;
        }
        FORMAT.setMaximumFractionDigits(Math.max(0, actual >= 100L ? 0 : (actual >= 10L ? 1 : 2)));
        return FORMAT.format((double)input * (1.0 / (double)(1L << 10 * layersFound))) + DATA_TYPES[Math.min(DATA_TYPES.length - 1, layersFound)];
    }

    public static String getTime(long time) {
        return DurationFormatUtils.formatDuration((long)Math.abs(time), (String)(TimeUnit.MILLISECONDS.toDays(time) > 0L ? "d:HH:mm:ss" : "HH:mm:ss"));
    }

    private static long toMB(long base) {
        return base >> 20;
    }

    public static String firstLetterUppercase(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        String first = Character.toString(string.charAt(0));
        return string.replaceFirst(first, first.toUpperCase());
    }

    public static long getWorldSize(long chunks, ResourceKey<Level> dimension) {
        long base = DIMENSION_SIZES.getLong(dimension) + 4095L >> 12 << 12;
        return chunks * base;
    }

    public static long getUsedMemory(ResourceKey<Level> dimension) {
        Path path = DimensionType.getStorageFolder(dimension, (Path)ServerLifecycleHooks.getCurrentServer().getWorldPath(LevelResource.ROOT)).resolve("region");
        if (Files.notExists(path, new LinkOption[0])) {
            return 0L;
        }
        try {
            return Files.walk(path, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(Predicate.not(Files::isSymbolicLink)).mapToLong(TextUtil::fileSize).sum();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static long getUsedMemory() {
        try {
            return Files.walk(ServerLifecycleHooks.getCurrentServer().getWorldPath(LevelResource.ROOT), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(Predicate.not(Files::isSymbolicLink)).mapToLong(TextUtil::fileSize).sum();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private static long fileSize(Path path) {
        try {
            return Files.size(path);
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public static long getFreeMemory() {
        try {
            return Files.getFileStore(FMLPaths.GAMEDIR.get()).getUsableSpace();
        }
        catch (IOException e) {
            return Long.MAX_VALUE;
        }
    }
}

