/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.networking.snyc;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.config.ConfigEntry;
import carbonconfiglib.config.ConfigHandler;
import carbonconfiglib.impl.ReloadMode;
import carbonconfiglib.networking.ICarbonPacket;
import carbonconfiglib.networking.buffer.ReadBuffer;
import carbonconfiglib.networking.buffer.WriteBuffer;
import carbonconfiglib.utils.SyncType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;

public class SyncPacket
implements ICarbonPacket {
    public static final StreamCodec<FriendlyByteBuf, SyncPacket> STREAM_CODEC = CustomPacketPayload.codec(SyncPacket::write, ICarbonPacket.readPacket(SyncPacket::new));
    public static final CustomPacketPayload.Type<SyncPacket> ID = ICarbonPacket.createType("carbonconfig:sync");
    String identifier;
    SyncType type;
    Map<String, byte[]> entries = new Object2ObjectLinkedOpenHashMap();

    public SyncPacket(String identifier, SyncType type, Map<String, byte[]> entries) {
        this.identifier = identifier;
        this.type = type;
        this.entries = entries;
    }

    public SyncPacket(FriendlyByteBuf buffer) {
        this.identifier = buffer.readUtf(Short.MAX_VALUE);
        this.type = (SyncType)buffer.readEnum(SyncType.class);
        int size = buffer.readVarInt();
        for (int i = 0; i < size; ++i) {
            this.entries.put(buffer.readUtf(Short.MAX_VALUE), buffer.readByteArray());
        }
    }

    public static SyncPacket create(ConfigHandler handler, SyncType type, boolean forceSync) {
        if (!handler.isLoaded()) {
            return null;
        }
        Object2ObjectLinkedOpenHashMap data = new Object2ObjectLinkedOpenHashMap();
        ByteBuf buf = Unpooled.buffer();
        WriteBuffer buffer = new WriteBuffer(new FriendlyByteBuf(buf));
        for (Map.Entry<String, ConfigEntry<?>> entry : handler.getConfig().getSyncedEntries(type).entrySet()) {
            ConfigEntry<?> value = entry.getValue();
            if (!forceSync && !value.hasChanged()) continue;
            buf.clear();
            value.serialize(buffer);
            byte[] configData = new byte[buf.writerIndex()];
            buf.readBytes(configData);
            data.put(entry.getKey(), configData);
            value.onSynced();
        }
        return data.isEmpty() ? null : new SyncPacket(handler.getConfigIdentifer(), type, (Map<String, byte[]>)data);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUtf(this.identifier);
        buffer.writeEnum((Enum)this.type);
        buffer.writeVarInt(this.entries.size());
        for (Map.Entry<String, byte[]> entry : this.entries.entrySet()) {
            buffer.writeUtf(entry.getKey());
            buffer.writeByteArray(entry.getValue());
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    @Override
    public void process(Player player) {
        ReloadMode mode = this.processEntry(player);
        if (mode != null) {
            player.sendSystemMessage(mode.getMessage());
        }
    }

    public ReloadMode processEntry(Player player) {
        if (this.entries.isEmpty()) {
            return null;
        }
        ConfigHandler cfg = CarbonConfig.CONFIGS.getConfig(this.identifier);
        if (cfg == null) {
            CarbonConfig.LOGGER.warn("Received packet for [" + this.identifier + "] which didn't exist!");
            return null;
        }
        Map<String, ConfigEntry<?>> mapped = cfg.getConfig().getSyncedEntries(this.type);
        boolean hasChanged = false;
        UUID owner = player.getUUID();
        ReloadMode mode = null;
        for (Map.Entry<String, byte[]> dataEntry : this.entries.entrySet()) {
            ConfigEntry<?> entry = mapped.get(dataEntry.getKey());
            if (entry == null) continue;
            entry.deserialize(new ReadBuffer(new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])dataEntry.getValue()))), owner);
            if (entry.hasChanged()) {
                hasChanged = true;
                mode = ReloadMode.or(mode, entry.getReloadState());
            }
            entry.onSynced();
        }
        if (hasChanged) {
            cfg.onSynced();
            cfg.saveQuietly();
            return mode;
        }
        return null;
    }
}

