/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.networking.forge;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.gui.impl.forge.ForgeHelpers;
import carbonconfiglib.networking.ICarbonPacket;
import carbonconfiglib.networking.carbon.ConfigAnswerPacket;
import io.netty.buffer.Unpooled;
import java.nio.file.Files;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.config.ModConfig;
import speiger.src.collections.objects.utils.ObjectLists;

public class RequestConfigPacket
implements ICarbonPacket {
    public static final StreamCodec<FriendlyByteBuf, RequestConfigPacket> STREAM_CODEC = CustomPacketPayload.codec(RequestConfigPacket::write, ICarbonPacket.readPacket(RequestConfigPacket::new));
    public static final CustomPacketPayload.Type<RequestConfigPacket> ID = ICarbonPacket.createType("carbonconfig:request_neo");
    ModConfig.Type type;
    UUID requestId;
    String modId;
    String fileName;

    public RequestConfigPacket(ModConfig.Type type, UUID requestId, String modId, String fileName) {
        this.type = type;
        this.requestId = requestId;
        this.modId = modId;
        this.fileName = fileName;
    }

    public RequestConfigPacket(FriendlyByteBuf buffer) {
        this.type = (ModConfig.Type)buffer.readEnum(ModConfig.Type.class);
        this.requestId = buffer.readUUID();
        this.modId = buffer.readUtf(Short.MAX_VALUE);
        this.fileName = buffer.readUtf(Short.MAX_VALUE);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)this.type);
        buffer.writeUUID(this.requestId);
        buffer.writeUtf(this.modId, Short.MAX_VALUE);
        buffer.writeUtf(this.fileName, Short.MAX_VALUE);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    @Override
    public void process(Player player) {
        if (!CarbonConfig.hasPermission(player, 4)) {
            return;
        }
        ModConfig config = this.findConfig();
        if (config == null) {
            return;
        }
        byte[] result = this.getData(config);
        if (result == null) {
            return;
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeByteArray(result);
        byte[] data = new byte[buf.writerIndex()];
        buf.readBytes(data);
        CarbonConfig.NETWORK.sendToPlayer(new ConfigAnswerPacket(this.requestId, data), player);
    }

    private byte[] getData(ModConfig config) {
        try {
            return Files.readAllBytes(config.getFullPath());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private ModConfig findConfig() {
        for (ModConfig config : ForgeHelpers.getConfigs().getOrDefault(this.modId, (List<ModConfig>)ObjectLists.empty())) {
            if (config.getType() != this.type || !this.fileName.equals(config.getFileName())) continue;
            return config;
        }
        return null;
    }
}

