/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.screen;

import carbonconfiglib.gui.api.BackgroundTexture;
import carbonconfiglib.gui.api.IModConfig;
import carbonconfiglib.gui.config.ConfigElement;
import carbonconfiglib.gui.config.Element;
import carbonconfiglib.gui.config.ListScreen;
import carbonconfiglib.gui.screen.ConfigScreen;
import carbonconfiglib.gui.widgets.CarbonButton;
import carbonconfiglib.gui.widgets.GuiUtils;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.storage.LevelSummary;

public class SelectFileScreen
extends ListScreen {
    private static final Component TEXT = Component.translatable((String)"gui.carbonconfig.select_world");
    IModConfig config;
    Screen parent;

    public SelectFileScreen(Component name, BackgroundTexture.BackgroundHolder customTexture, Screen parent, IModConfig config) {
        super(name, customTexture);
        this.config = config;
        this.parent = parent;
    }

    @Override
    protected void collectElements(Consumer<Element> elements) {
        for (IModConfig.IConfigTarget target : this.config.getPotentialFiles()) {
            if (Files.notExists(target.getConfigFile(), new LinkOption[0]) && !this.config.canCreateConfigs()) continue;
            elements.accept(new WorldElement(target, this.config, this.parent, this.title));
        }
    }

    @Override
    protected void init() {
        super.init();
        int x = this.width / 2;
        int y = this.height;
        this.addRenderableWidget((GuiEventListener)new CarbonButton(x - 80, y - 27, 160, 20, (Component)Component.translatable((String)"gui.carbonconfig.back"), T -> this.onClose()));
    }

    @Override
    protected int getElementHeight() {
        return 28;
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.drawCenteredString(this.font, TEXT, this.width / 2, 8, -1);
    }

    @Override
    public void removed() {
        this.allEntries.forEach(this::cleanup);
        super.removed();
    }

    private void cleanup(Element element) {
        if (element instanceof WorldElement) {
            ((WorldElement)element).cleanup();
        }
    }

    private static class WorldElement
    extends Element {
        IModConfig config;
        IModConfig.IConfigTarget target;
        Screen parent;
        Button button;
        Component title;
        Component path;
        DynamicTexture texture;
        ConfigScreen.Navigator nav;

        public WorldElement(IModConfig.IConfigTarget target, IModConfig config, Screen parent, Component prevName) {
            super((Component)Component.literal((String)target.getName()));
            this.nav = new ConfigScreen.Navigator(prevName);
            this.nav.setScreenForLayer(parent);
            this.target = target;
            this.config = config;
            this.parent = parent;
        }

        @Override
        public void init() {
            if (this.target instanceof IModConfig.WorldConfigTarget) {
                IModConfig.WorldConfigTarget world = (IModConfig.WorldConfigTarget)this.target;
                LevelSummary sum = world.getSummary();
                this.loadIcon(sum.getIcon());
                this.title = Component.literal((String)sum.getLevelName());
                this.path = Component.literal((String)sum.getLevelId()).withStyle(ChatFormatting.GRAY);
            } else {
                this.title = Component.literal((String)this.target.getName());
                Path folder = this.target.getFolder();
                int index = folder.getNameCount();
                this.path = Component.literal((String)folder.subpath(index - 3, index).toString()).withStyle(ChatFormatting.GRAY);
            }
            boolean load = Files.exists(this.target.getConfigFile(), new LinkOption[0]);
            this.button = new CarbonButton(0, 0, 62, 20, (Component)Component.translatable((String)(load ? "gui.carbonconfig.pick" : "gui.carbonconfig.create")), this::onPick);
        }

        @Override
        public void render(GuiGraphics graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            this.button.setX(left + width - 62);
            this.button.setY(top + 2);
            this.button.render(graphics, mouseX, mouseY, partialTicks);
            GuiUtils.drawScrollingString(graphics, this.font, this.title, left + 5, top + 2, 150.0f, 10.0f, ConfigElement.GuiAlign.LEFT, -1, 0);
            GuiUtils.drawScrollingString(graphics, this.font, this.path, left + 5, top + 12, 150.0f, 10.0f, ConfigElement.GuiAlign.LEFT, -1, 0);
            if (this.texture != null) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShaderTexture((int)0, (int)this.texture.getId());
                GuiUtils.drawTextureRegion(graphics, left - 24, top, 0.0f, 0.0f, 24.0f, 24.0f, 64.0f, 64.0f, 64.0f, 64.0f);
            }
        }

        private void loadIcon(Path iconFile) {
            try (InputStream stream = Files.newInputStream(iconFile, new OpenOption[0]);){
                NativeImage image = NativeImage.read((InputStream)stream);
                if (image == null || image.getWidth() != 64 || image.getHeight() != 64) {
                    return;
                }
                this.texture = new DynamicTexture(image);
                this.texture.upload();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return ObjectLists.singleton((Object)this.button);
        }

        private void onPick(Button button) {
            Path file = this.target.getConfigFile();
            if (Files.notExists(file, new LinkOption[0]) && !this.config.createConfig(file)) {
                return;
            }
            IModConfig config = this.config.loadFromFile(file);
            if (config == null) {
                this.mc.setScreen(this.parent);
                return;
            }
            this.mc.setScreen((Screen)new ConfigScreen(this.nav.add((Component)this.path.copy().withStyle(ChatFormatting.WHITE)), config, this.parent, this.owner.getCustomTexture()));
        }

        private void cleanup() {
            if (this.texture == null) {
                return;
            }
            this.texture.close();
            this.texture = null;
        }
    }
}

