/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.screen;

import carbonconfiglib.gui.api.BackgroundTexture;
import carbonconfiglib.gui.api.IValueNode;
import carbonconfiglib.gui.config.ElementList;
import carbonconfiglib.gui.widgets.CarbonButton;
import carbonconfiglib.utils.ParseResult;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class EditStringScreen
extends Screen {
    Screen parent;
    IValueNode value;
    EditBox textBox;
    boolean valid = true;
    BackgroundTexture.BackgroundHolder texture;
    ParseResult<Boolean> result;

    public EditStringScreen(Screen parent, Component name, IValueNode value, BackgroundTexture.BackgroundHolder texture) {
        super(name);
        this.parent = parent;
        this.value = value;
        this.value.createTemp();
        this.texture = texture == null ? BackgroundTexture.DEFAULT.asHolder() : texture;
    }

    protected void init() {
        super.init();
        int x = this.width / 2 - 100;
        Button apply = (Button)this.addRenderableWidget((GuiEventListener)new CarbonButton(x + 10, 160, 85, 20, (Component)Component.translatable((String)"gui.carbonconfig.apply"), this::save));
        this.addRenderableWidget((GuiEventListener)new CarbonButton(x + 105, 160, 85, 20, (Component)Component.translatable((String)"gui.carbonconfig.cancel"), this::cancel));
        this.textBox = new EditBox(this.font, x, 113, 200, 18, (Component)Component.empty());
        this.addRenderableWidget((GuiEventListener)this.textBox);
        this.textBox.setMaxLength(512);
        this.textBox.setValue(this.value.get());
        this.textBox.setResponder(T -> {
            this.textBox.setTextColor(0xE0E0E0);
            this.valid = true;
            this.result = this.value.isValid((String)T);
            if (!this.result.getValue().booleanValue()) {
                this.textBox.setTextColor(0xFF0000);
                this.valid = false;
            }
            apply.active = this.valid;
            if (this.valid) {
                this.value.set(this.textBox.getValue());
            }
        });
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        ElementList.renderBackground(0, this.width, 0, this.height, 0.0f, this.texture.getTexture());
        ElementList.renderListOverlay(0, this.width, 103, 142, this.width, this.height, this.texture.getTexture());
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 85, -1);
        if (this.textBox.isMouseOver((double)mouseX, (double)mouseY) && this.result != null && !this.result.getValue().booleanValue()) {
            graphics.renderTooltip(this.font, this.font.split((FormattedText)Component.literal((String)this.result.getError().getMessage()), Integer.MAX_VALUE), mouseX, mouseY);
        }
    }

    public void onClose() {
        this.value.setPrevious();
        this.minecraft.setScreen(this.parent);
    }

    private void save(Button button) {
        if (!this.valid) {
            return;
        }
        this.value.apply();
        this.minecraft.setScreen(this.parent);
    }

    private void cancel(Button button) {
        if (this.value.isChanged()) {
            this.minecraft.setScreen((Screen)new ConfirmScreen(T -> {
                if (T) {
                    this.value.setPrevious();
                }
                this.minecraft.setScreen((Screen)(T ? this.parent : this));
            }, (Component)Component.translatable((String)"gui.carbonconfig.warn.changed"), (Component)Component.translatable((String)"gui.carbonconfig.warn.changed.desc").withStyle(ChatFormatting.GRAY)));
            return;
        }
        this.value.setPrevious();
        this.minecraft.setScreen(this.parent);
    }
}

