/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.screen;

import carbonconfiglib.gui.api.BackgroundTexture;
import carbonconfiglib.gui.api.ICompoundNode;
import carbonconfiglib.gui.api.INode;
import carbonconfiglib.gui.api.IValueNode;
import carbonconfiglib.gui.config.ArrayElement;
import carbonconfiglib.gui.config.CompoundElement;
import carbonconfiglib.gui.config.ConfigElement;
import carbonconfiglib.gui.config.Element;
import carbonconfiglib.gui.config.ListScreen;
import carbonconfiglib.gui.config.SelectionElement;
import carbonconfiglib.gui.widgets.CarbonButton;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class CompoundScreen
extends ListScreen {
    Screen prev;
    ICompoundNode compound;
    Button applyValue;
    Runnable closeListener = null;

    public CompoundScreen(ICompoundNode node, Screen prev, BackgroundTexture.BackgroundHolder customTexture) {
        super(node.getName(), customTexture);
        this.prev = prev;
        this.compound = node;
        this.compound.createTemp();
    }

    @Override
    protected void init() {
        super.init();
        int x = this.width / 2;
        int y = this.height;
        this.applyValue = (Button)this.addRenderableWidget((GuiEventListener)new CarbonButton(x - 82, y - 27, 80, 20, (Component)Component.translatable((String)"gui.carbonconfig.apply"), this::apply));
        this.addRenderableWidget((GuiEventListener)new CarbonButton(x + 2, y - 27, 80, 20, (Component)Component.translatable((String)"gui.carbonconfig.back"), this::goBack));
    }

    @Override
    protected int getScrollPadding() {
        return 184;
    }

    @Override
    protected int getListWidth() {
        return 360;
    }

    @Override
    protected boolean shouldHaveTooltips() {
        return true;
    }

    public void setAbortListener(Runnable run) {
        this.closeListener = run;
    }

    @Override
    public void tick() {
        super.tick();
        this.applyValue.active = this.compound.isValid();
    }

    public void onClose() {
        this.notifyClose();
        this.minecraft.setScreen(this.prev);
    }

    private void apply(Button button) {
        this.compound.apply();
        this.minecraft.setScreen(this.prev);
    }

    private void notifyClose() {
        this.compound.setPrevious();
        if (this.closeListener == null) {
            return;
        }
        this.closeListener.run();
    }

    private void goBack(Button button) {
        if (this.compound.isChanged()) {
            this.minecraft.setScreen((Screen)new ConfirmScreen(T -> {
                if (T) {
                    this.notifyClose();
                }
                this.minecraft.setScreen((Screen)(T ? this.prev : this));
            }, (Component)Component.translatable((String)"gui.carbonconfig.warn.changed"), (Component)Component.translatable((String)"gui.carbonconfig.warn.changed.desc").withStyle(ChatFormatting.GRAY)));
            return;
        }
        this.notifyClose();
        this.minecraft.setScreen(this.prev);
    }

    @Override
    protected void collectElements(Consumer<Element> elements) {
        List<? extends INode> values = this.compound.getValues();
        int m = values.size();
        block5: for (int i = 0; i < m; ++i) {
            INode node = values.get(i);
            switch (node.getNodeType()) {
                case COMPOUND: {
                    elements.accept(new CompoundElement(this.compound, node.asCompound()));
                    continue block5;
                }
                case LIST: {
                    elements.accept(new ArrayElement(this.compound, node.asArray()));
                    continue block5;
                }
                case SIMPLE: {
                    IValueNode value = node.asValue();
                    if (value.isForcingSuggestions()) {
                        elements.accept(new SelectionElement(this.compound, value));
                        continue block5;
                    }
                    ConfigElement element = value.getDataType().create(this.compound, value);
                    if (element == null) continue block5;
                    elements.accept(element);
                }
            }
        }
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 8, -1);
    }
}

