/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.screen;

import carbonconfiglib.gui.api.BackgroundTexture;
import carbonconfiglib.gui.api.IArrayNode;
import carbonconfiglib.gui.api.INode;
import carbonconfiglib.gui.api.IValueNode;
import carbonconfiglib.gui.config.ArrayElement;
import carbonconfiglib.gui.config.CompoundElement;
import carbonconfiglib.gui.config.ConfigElement;
import carbonconfiglib.gui.config.Element;
import carbonconfiglib.gui.config.ListScreen;
import carbonconfiglib.gui.screen.CompoundScreen;
import carbonconfiglib.gui.screen.ListSelectionScreen;
import carbonconfiglib.gui.widgets.CarbonButton;
import carbonconfiglib.utils.structure.IStructuredData;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ArrayScreen
extends ListScreen {
    Screen prev;
    IArrayNode array;
    IStructuredData.StructureType innerType;
    Runnable closeListener;

    public ArrayScreen(IArrayNode entry, Screen prev, BackgroundTexture.BackgroundHolder customTexture) {
        super(entry.getName(), customTexture);
        this.prev = prev;
        this.array = entry;
        this.innerType = entry.getInnerType();
        this.array.createTemp();
    }

    @Override
    protected void init() {
        super.init();
        int x = this.width / 2;
        int y = this.height;
        this.addRenderableWidget((GuiEventListener)new CarbonButton(x - 92, y - 27, 80, 20, (Component)Component.translatable((String)"gui.carbonconfig.apply"), this::apply));
        this.addRenderableWidget((GuiEventListener)new CarbonButton(x - 10, y - 27, 20, 20, (Component)Component.literal((String)"+"), this::createEntry));
        this.addRenderableWidget((GuiEventListener)new CarbonButton(x + 12, y - 27, 80, 20, (Component)Component.translatable((String)"gui.carbonconfig.back"), this::goBack));
    }

    @Override
    protected boolean shouldHaveTooltips() {
        return true;
    }

    @Override
    protected boolean shouldHaveSearch() {
        return false;
    }

    public void setAbortListener(Runnable run) {
        this.closeListener = run;
    }

    private void notifyClose() {
        this.array.setPrevious();
        if (this.closeListener == null) {
            return;
        }
        this.closeListener.run();
    }

    public void onClose() {
        this.notifyClose();
        this.minecraft.setScreen(this.prev);
    }

    private void apply(Button button) {
        this.array.apply();
        this.minecraft.setScreen(this.prev);
    }

    private void goBack(Button button) {
        if (this.array.isChanged()) {
            this.minecraft.setScreen((Screen)new ConfirmScreen(T -> {
                if (T) {
                    this.notifyClose();
                }
                this.minecraft.setScreen((Screen)(T ? this.prev : this));
            }, (Component)Component.translatable((String)"gui.carbonconfig.warn.changed"), (Component)Component.translatable((String)"gui.carbonconfig.warn.changed.desc").withStyle(ChatFormatting.GRAY)));
            return;
        }
        this.notifyClose();
        this.minecraft.setScreen(this.prev);
    }

    @Override
    protected void collectElements(Consumer<Element> elements) {
        switch (this.innerType) {
            case COMPOUND: {
                int m = this.array.size();
                for (int i = 0; i < m; ++i) {
                    elements.accept(new CompoundElement(this.array, this.array.get(i).asCompound()));
                }
                break;
            }
            case LIST: {
                int m = this.array.size();
                for (int i = 0; i < m; ++i) {
                    elements.accept(new ArrayElement(this.array, this.array.get(i).asArray()));
                }
                break;
            }
            case SIMPLE: {
                int m = this.array.size();
                for (int i = 0; i < m; ++i) {
                    IValueNode node = this.array.get(i).asValue();
                    ConfigElement element = node.getDataType().create(this.array, node);
                    if (element == null) continue;
                    elements.accept(element);
                }
                break;
            }
        }
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 30, -1);
    }

    public void createEntry(Button button) {
        int size = this.array.size();
        this.array.createNode();
        if (this.array.getSuggestions().size() > 0) {
            ListSelectionScreen screen = new ListSelectionScreen(this.prev, this.array.get(size), this.innerType == IStructuredData.StructureType.COMPOUND ? ListSelectionScreen.NodeSupplier.ofCompound(this.array) : ListSelectionScreen.NodeSupplier.ofValue(), this.getCustomTexture());
            screen.withListener(() -> this.postCreate(size, true), () -> this.array.removeNode(size)).disableAbortWarning();
            this.minecraft.setScreen((Screen)screen);
            return;
        }
        this.postCreate(size, false);
    }

    private void postCreate(int size, boolean reopen) {
        INode node = this.array.get(size);
        switch (node.getNodeType()) {
            case COMPOUND: {
                CompoundScreen compoundScreen = new CompoundScreen(node.asCompound(), this, this.getCustomTexture());
                compoundScreen.setAbortListener(() -> this.array.removeNode(size));
                this.minecraft.setScreen((Screen)compoundScreen);
                this.lastScroll = Double.MAX_VALUE;
                break;
            }
            case LIST: {
                ArrayScreen arrayScreen = new ArrayScreen(node.asArray(), this, this.getCustomTexture());
                arrayScreen.setAbortListener(() -> this.array.removeNode(size));
                this.minecraft.setScreen((Screen)arrayScreen);
                this.lastScroll = Double.MAX_VALUE;
                break;
            }
            case SIMPLE: {
                ConfigElement element = node.asValue().getDataType().create(this.array, node.asValue());
                if (element == null) break;
                this.addEntry(element);
                this.visibleList.addElement(element);
                this.visibleList.setScrollAmount(this.visibleList.getMaxScroll(), true);
            }
        }
        if (reopen) {
            this.minecraft.setScreen((Screen)this);
        }
    }

    @Override
    public void removeEntry(Element element) {
        int index = this.allEntries.indexOf((Object)element);
        if (index == -1) {
            return;
        }
        this.visibleList.removeElement(element);
        this.allEntries.remove(index);
        this.array.removeNode(index);
        this.visibleList.setScrollAmount(this.visibleList.getScrollAmount());
    }
}

