/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.impl.minecraft;

import carbonconfiglib.gui.api.IConfigNode;
import carbonconfiglib.gui.api.INode;
import carbonconfiglib.gui.impl.minecraft.IGameRuleValue;
import carbonconfiglib.gui.impl.minecraft.MinecraftValue;
import carbonconfiglib.utils.structure.IStructuredData;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class MinecraftLeaf
implements IConfigNode {
    IGameRuleValue entry;
    MinecraftValue value;

    public MinecraftLeaf(IGameRuleValue entry) {
        this.entry = entry;
    }

    @Override
    public List<IConfigNode> getChildren() {
        return null;
    }

    @Override
    public IStructuredData.StructureType getDataStructure() {
        return IStructuredData.StructureType.SIMPLE;
    }

    @Override
    public INode asNode() {
        if (this.value == null) {
            this.value = new MinecraftValue(this.entry);
        }
        return this.value;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public boolean isChanged() {
        return this.value != null && this.value.isChanged();
    }

    @Override
    public void setPrevious() {
        if (this.value != null) {
            this.value.setPrevious();
        }
    }

    @Override
    public void setDefault() {
        if (this.value != null) {
            this.value.setDefault();
        }
    }

    @Override
    public void save() {
        if (this.value != null) {
            this.value.save();
        }
    }

    @Override
    public boolean requiresRestart() {
        return false;
    }

    @Override
    public boolean requiresReload() {
        return false;
    }

    @Override
    public String getNodeName() {
        return null;
    }

    @Override
    public Component getName() {
        return IConfigNode.createLabel(I18n.get((String)this.entry.getDescriptionId(), (Object[])new Object[0]));
    }

    @Override
    public Component getTooltip() {
        Object id = this.entry.getDescriptionId();
        MutableComponent result = Component.empty();
        result.append((Component)Component.translatable((String)id).withStyle(ChatFormatting.YELLOW));
        id = (String)id + ".description";
        if (I18n.exists((String)id)) {
            result.append("\n").append((Component)Component.translatable((String)id).withStyle(ChatFormatting.GRAY));
        }
        return result;
    }
}

