/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.impl.forge;

import carbonconfiglib.api.ConfigType;
import carbonconfiglib.gui.api.BackgroundTexture;
import carbonconfiglib.gui.api.IModConfig;
import carbonconfiglib.gui.api.IModConfigs;
import carbonconfiglib.gui.impl.forge.ForgeConfig;
import carbonconfiglib.gui.impl.forge.ForgeHelpers;
import carbonconfiglib.impl.internal.ModConfigs;
import java.util.List;
import java.util.Optional;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.moddiscovery.ModInfo;
import net.neoforged.neoforgespi.language.IModInfo;
import speiger.src.collections.objects.lists.ObjectArrayList;
import speiger.src.collections.objects.utils.ObjectLists;

public class ForgeConfigs
implements IModConfigs {
    ModContainer container;
    List<ModConfig> configs;

    public ForgeConfigs(ModContainer container) {
        this.container = container;
        this.configs = ForgeHelpers.getConfigs().getOrDefault(container.getModId(), (List<ModConfig>)ObjectLists.empty());
    }

    public boolean hasConfigs() {
        return !this.configs.isEmpty();
    }

    @Override
    public String getModName() {
        return this.container.getModInfo().getDisplayName();
    }

    @Override
    public List<IModConfig> getConfigInstances(ConfigType type) {
        ModConfig.Type value = this.fromType(type);
        ObjectArrayList configs = new ObjectArrayList();
        for (ModConfig config : this.configs) {
            if (config.getType() != value) continue;
            configs.add(new ForgeConfig(config));
        }
        return configs;
    }

    @Override
    public BackgroundTexture.BackgroundHolder getBackground() {
        Optional texture = this.container.getCustomExtension(IModConfigs.Background.class);
        if (texture.isPresent()) {
            return ((IModConfigs.Background)texture.get()).texture().asHolder();
        }
        Optional<BackgroundTexture> carbon_Texture = ModConfigs.computeTexture(this.container);
        if (carbon_Texture.isPresent()) {
            return carbon_Texture.get().asHolder();
        }
        return ForgeConfigs.getBackgroundTexture(this.container.getModInfo()).asHolder();
    }

    public static BackgroundTexture getBackgroundTexture(ModConfig config) {
        ModContainer container = ModList.get().getModContainerById(config.getModId()).orElse(null);
        return container == null ? BackgroundTexture.DEFAULT : ForgeConfigs.getBackgroundTexture(container.getModInfo());
    }

    private static BackgroundTexture getBackgroundTexture(IModInfo info) {
        Optional optional;
        String configBackground = (String)info.getModProperties().get("configuredBackground");
        if (configBackground != null) {
            return BackgroundTexture.of(configBackground).build();
        }
        if (info instanceof ModInfo && (optional = ((ModInfo)info).getConfigElement(new String[]{"configBackground"})).isPresent()) {
            return BackgroundTexture.of((String)optional.get()).build();
        }
        return BackgroundTexture.DEFAULT;
    }

    private ModConfig.Type fromType(ConfigType type) {
        switch (type) {
            case CLIENT: {
                return ModConfig.Type.CLIENT;
            }
            case SERVER: {
                return ModConfig.Type.SERVER;
            }
            case SHARED: {
                return ModConfig.Type.COMMON;
            }
        }
        throw new UnsupportedOperationException();
    }
}

