/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.texture.render;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.chisel.ctm.api.texture.ICTMTexture;
import team.chisel.ctm.api.texture.ITextureContext;
import team.chisel.ctm.api.texture.ITextureType;
import team.chisel.ctm.api.util.TextureInfo;
import team.chisel.ctm.client.util.BlockRenderLayer;
import team.chisel.ctm.client.util.Quad;

@ParametersAreNonnullByDefault
public abstract class AbstractTexture<T extends ITextureType>
implements ICTMTexture<T> {
    protected T type;
    protected BlockRenderLayer layer;
    @NotNull
    protected @NotNull TextureAtlasSprite @NotNull [] sprites;
    protected boolean isProxy;
    @Deprecated
    protected boolean fullbright;
    protected boolean hasLight;
    protected int skylight;
    protected int blocklight;

    @Deprecated
    public AbstractTexture(T type, BlockRenderLayer layer, TextureAtlasSprite ... sprites) {
        this.type = type;
        this.layer = layer;
        this.sprites = sprites;
        this.blocklight = 0;
        this.skylight = 0;
    }

    public AbstractTexture(T type, TextureInfo info) {
        JsonElement light;
        this.type = type;
        this.layer = info.getRenderLayer();
        this.sprites = info.getSprites();
        this.isProxy = info.isProxy();
        this.fullbright = info.getFullbright();
        if (info.getInfo().isPresent() && (light = info.getInfo().get().get("light")) != null) {
            if (light.isJsonPrimitive()) {
                this.hasLight = true;
                this.skylight = this.blocklight = this.parseLightValue(light);
            } else if (light.isJsonObject()) {
                this.hasLight = true;
                JsonObject lightObj = light.getAsJsonObject();
                this.blocklight = this.parseLightValue(lightObj.get("block"));
                this.skylight = this.parseLightValue(lightObj.get("sky"));
            }
        }
    }

    private int parseLightValue(@Nullable JsonElement data) {
        if (data != null && data.isJsonPrimitive() && data.getAsJsonPrimitive().isNumber()) {
            return Mth.clamp((int)data.getAsInt(), (int)0, (int)15);
        }
        return 0;
    }

    @Override
    public TextureAtlasSprite getParticle() {
        return this.sprites[0];
    }

    @Override
    public Collection<ResourceLocation> getTextures() {
        return Arrays.stream(this.sprites).map(TextureAtlasSprite::contents).map(SpriteContents::name).toList();
    }

    protected Quad makeQuad(BakedQuad bq, @Nullable ITextureContext context) {
        Quad q = Quad.from(bq);
        q = this.hasLight ? q.setLight(this.blocklight, this.skylight) : q.setFullbright(this.fullbright);
        return q;
    }

    @Override
    public T getType() {
        return this.type;
    }

    @Override
    public BlockRenderLayer getLayer() {
        return this.layer;
    }
}

