/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.model;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.chisel.ctm.api.model.IModelCTM;
import team.chisel.ctm.api.texture.ICTMTexture;
import team.chisel.ctm.api.util.TextureInfo;
import team.chisel.ctm.client.model.ModelBakedCTM;
import team.chisel.ctm.client.texture.IMetadataSectionCTM;
import team.chisel.ctm.client.texture.render.TextureNormal;
import team.chisel.ctm.client.texture.type.TextureTypeNormal;
import team.chisel.ctm.client.util.BlockRenderLayer;
import team.chisel.ctm.client.util.ResourceUtil;

public class ModelCTM
implements IModelCTM {
    private final UnbakedModel vanillamodel;
    @Nullable
    private final BlockModel modelinfo;
    private final Int2ObjectMap<JsonElement> overrides;
    protected final Int2ObjectMap<IMetadataSectionCTM> metaOverrides = new Int2ObjectArrayMap();
    protected Int2ObjectMap<TextureAtlasSprite> spriteOverrides;
    protected Map<Pair<Integer, ResourceLocation>, ICTMTexture<?>> textureOverrides;
    private final Collection<ResourceLocation> textureDependencies;
    private final Set<RenderType> extraLayers = new HashSet<RenderType>();
    private final Set<RenderType> extraLayersView = Collections.unmodifiableSet(this.extraLayers);
    private final Map<ResourceLocation, ICTMTexture<?>> textures = new HashMap();
    private static final ItemModelGenerator ITEM_MODEL_GENERATOR = new ItemModelGenerator();

    public ModelCTM(UnbakedModel modelinfo) {
        this.vanillamodel = modelinfo;
        this.modelinfo = null;
        this.overrides = new Int2ObjectOpenHashMap();
        this.textureDependencies = new HashSet<ResourceLocation>();
    }

    public ModelCTM(BlockModel modelinfo, Int2ObjectMap<JsonElement> overrides) throws IOException {
        this.vanillamodel = modelinfo;
        this.modelinfo = modelinfo;
        this.overrides = overrides;
        this.textureDependencies = new HashSet<ResourceLocation>();
        for (Int2ObjectMap.Entry e : this.overrides.int2ObjectEntrySet()) {
            IMetadataSectionCTM meta = null;
            if (((JsonElement)e.getValue()).isJsonPrimitive() && ((JsonElement)e.getValue()).getAsJsonPrimitive().isString()) {
                ResourceLocation rl2 = ResourceLocation.parse((String)((JsonElement)e.getValue()).getAsString());
                meta = ResourceUtil.getMetadata(ResourceUtil.spriteToAbsolute(rl2)).orElse(null);
                this.textureDependencies.add(rl2);
            } else if (((JsonElement)e.getValue()).isJsonObject()) {
                JsonObject obj = ((JsonElement)e.getValue()).getAsJsonObject();
                if (!obj.has("ctm_version")) {
                    obj.addProperty("ctm_version", (Number)1);
                }
                meta = new IMetadataSectionCTM.Serializer().fromJson(obj);
            }
            if (meta == null) continue;
            this.metaOverrides.put(e.getIntKey(), meta);
            this.textureDependencies.addAll(Arrays.asList(meta.getAdditionalTextures()));
        }
        this.textureDependencies.removeIf(rl -> rl.getPath().startsWith("#"));
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
        return this.bake(bakery, spriteGetter, modelState);
    }

    public BakedModel bake(ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform) {
        if (this.modelinfo != null && this.modelinfo.getRootModel() == ModelBakery.GENERATION_MARKER) {
            return ITEM_MODEL_GENERATOR.generateBlockModel(spriteGetter, this.modelinfo).bake(bakery, this.modelinfo, spriteGetter, modelTransform, false);
        }
        this.initializeOverrides(spriteGetter);
        this.textureDependencies.forEach(t -> this.initializeTexture(new Material(TextureAtlas.LOCATION_BLOCKS, t), spriteGetter));
        BakedModel parent = this.vanillamodel.bake(bakery, mat -> this.initializeTexture((Material)mat, spriteGetter), modelTransform);
        if (!this.isInitialized()) {
            this.spriteOverrides = new Int2ObjectOpenHashMap();
            this.textureOverrides = new HashMap();
        }
        return new ModelBakedCTM(this, parent, null);
    }

    public TextureAtlasSprite initializeTexture(Material m, Function<Material, TextureAtlasSprite> spriteGetter) {
        TextureAtlasSprite sprite = spriteGetter.apply(m);
        Optional<Object> chiselmeta = Optional.empty();
        try {
            chiselmeta = ResourceUtil.getMetadata(sprite);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Optional<Object> meta = chiselmeta;
        this.textures.computeIfAbsent(sprite.contents().name(), s -> {
            TextureNormal tex = meta.isEmpty() ? new TextureNormal(TextureTypeNormal.INSTANCE, new TextureInfo(new TextureAtlasSprite[]{sprite}, Optional.empty(), null, false)) : ((IMetadataSectionCTM)meta.get()).makeTexture(sprite, spriteGetter);
            BlockRenderLayer renderLayer = tex.getLayer();
            if (renderLayer != null) {
                this.extraLayers.add(renderLayer.getRenderType());
            }
            return tex;
        });
        return sprite;
    }

    private void initializeOverrides(Function<Material, TextureAtlasSprite> spriteGetter) {
        if (this.spriteOverrides == null) {
            this.spriteOverrides = new Int2ObjectOpenHashMap();
            for (Int2ObjectMap.Entry e : this.overrides.int2ObjectEntrySet()) {
                if (!((JsonElement)e.getValue()).isJsonPrimitive() || !((JsonElement)e.getValue()).getAsJsonPrimitive().isString()) continue;
                TextureAtlasSprite override = spriteGetter.apply(new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.parse((String)((JsonElement)e.getValue()).getAsString())));
                this.spriteOverrides.put(e.getIntKey(), (Object)override);
            }
        }
        if (this.textureOverrides == null) {
            this.textureOverrides = new HashMap();
            for (Int2ObjectMap.Entry e : this.metaOverrides.int2ObjectEntrySet()) {
                List<BlockElementFace> matches = this.modelinfo.getElements().stream().flatMap(b -> b.faces.values().stream()).filter(b -> b.tintIndex() == e.getIntKey()).toList();
                HashMultimap bySprite = HashMultimap.create();
                matches.forEach(arg_0 -> this.lambda$initializeOverrides$6((Multimap)bySprite, arg_0));
                for (Map.Entry e2 : bySprite.asMap().entrySet()) {
                    ICTMTexture<?> tex;
                    BlockRenderLayer renderLayer;
                    ResourceLocation texLoc = ((Material)e2.getKey()).sprite().contents().name();
                    TextureAtlasSprite override = this.getOverrideSprite(e.getIntKey());
                    if (override == null) {
                        override = spriteGetter.apply(new Material(TextureAtlas.LOCATION_BLOCKS, texLoc));
                    }
                    if ((renderLayer = (tex = ((IMetadataSectionCTM)e.getValue()).makeTexture(override, spriteGetter)).getLayer()) != null) {
                        this.extraLayers.add(renderLayer.getRenderType());
                    }
                    this.textureOverrides.put((Pair<Integer, ResourceLocation>)Pair.of((Object)e.getIntKey(), (Object)texLoc), tex);
                }
            }
        }
    }

    public boolean isInitialized() {
        return this.spriteOverrides != null && this.textureOverrides != null && !this.textures.isEmpty();
    }

    @Override
    public void load() {
    }

    @Override
    public Collection<ICTMTexture<?>> getCTMTextures() {
        return ImmutableList.builder().addAll(this.textures.values()).addAll(this.textureOverrides.values()).build();
    }

    @Override
    public ICTMTexture<?> getTexture(ResourceLocation iconName) {
        return this.textures.get(iconName);
    }

    @Override
    public Set<RenderType> getExtraLayers(BlockState state) {
        return this.extraLayersView;
    }

    @Override
    @Nullable
    public TextureAtlasSprite getOverrideSprite(int tintIndex) {
        return (TextureAtlasSprite)this.spriteOverrides.get(tintIndex);
    }

    @Override
    @Nullable
    public ICTMTexture<?> getOverrideTexture(int tintIndex, ResourceLocation sprite) {
        return this.textureOverrides.get(Pair.of((Object)tintIndex, (Object)sprite));
    }

    public void resolveParents(@NotNull Function<ResourceLocation, UnbakedModel> modelGetter, @NotNull IGeometryBakingContext context) {
        this.vanillamodel.resolveParents(modelGetter);
    }

    private /* synthetic */ void lambda$initializeOverrides$6(Multimap bySprite, BlockElementFace part) {
        bySprite.put((Object)((Material)this.modelinfo.textureMap.getOrDefault(part.texture().substring(1), Either.right((Object)part.texture())).left().get()), (Object)part);
    }
}

