/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.neoforge.init;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.neoforge.core.BiomesOPlentyNeoForge;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidInteractionRegistry;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ModFluidTypes {
    public static Holder<FluidType> BLOOD_TYPE;
    public static Holder<FluidType> LIQUID_NULL_TYPE;

    public static void setup() {
        ModFluidTypes.registerFluids();
    }

    public static void registerFluids() {
        BLOOD_TYPE = ModFluidTypes.registerFluidType(() -> new FluidType(FluidType.Properties.create().descriptionId("block.biomesoplenty.blood").fallDistanceModifier(0.0f).canExtinguish(true).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.FIRE_EXTINGUISH).density(3000).viscosity(6000)){

            public PathType getBlockPathType(FluidState state, BlockGetter level, BlockPos pos, @Nullable Mob mob, boolean canFluidLog) {
                return canFluidLog ? super.getBlockPathType(state, level, pos, mob, true) : null;
            }

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new IClientFluidTypeExtensions(this){
                    private static final ResourceLocation BLOOD_UNDERWATER = ResourceLocation.parse((String)"biomesoplenty:textures/block/blood_underwater.png");
                    private static final ResourceLocation BLOOD_STILL = ResourceLocation.parse((String)"biomesoplenty:block/blood_still");
                    private static final ResourceLocation BLOOD_FLOW = ResourceLocation.parse((String)"biomesoplenty:block/blood_flow");

                    public ResourceLocation getStillTexture() {
                        return BLOOD_STILL;
                    }

                    public ResourceLocation getFlowingTexture() {
                        return BLOOD_FLOW;
                    }

                    public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                        return BLOOD_UNDERWATER;
                    }

                    public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                        return new Vector3f(0.407f, 0.121f, 0.137f);
                    }

                    public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                        RenderSystem.setShaderFogStart((float)0.125f);
                        RenderSystem.setShaderFogEnd((float)5.0f);
                    }
                });
            }
        }, "blood");
        LIQUID_NULL_TYPE = ModFluidTypes.registerFluidType(() -> new FluidType(FluidType.Properties.create().descriptionId("block.biomesoplenty.liquid_null").fallDistanceModifier(0.0f).canExtinguish(false).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.FIRE_EXTINGUISH).density(3000).viscosity(6000)){

            public PathType getBlockPathType(FluidState state, BlockGetter level, BlockPos pos, @Nullable Mob mob, boolean canFluidLog) {
                return canFluidLog ? super.getBlockPathType(state, level, pos, mob, true) : null;
            }

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new IClientFluidTypeExtensions(this){
                    private static final ResourceLocation LIQUID_NULL_UNDERWATER = ResourceLocation.parse((String)"biomesoplenty:textures/block/liquid_null_underwater.png");
                    private static final ResourceLocation LIQUID_NULL_STILL = ResourceLocation.parse((String)"biomesoplenty:block/liquid_null_still");
                    private static final ResourceLocation LIQUID_NULL_FLOW = ResourceLocation.parse((String)"biomesoplenty:block/liquid_null_flow");

                    public ResourceLocation getStillTexture() {
                        return LIQUID_NULL_STILL;
                    }

                    public ResourceLocation getFlowingTexture() {
                        return LIQUID_NULL_FLOW;
                    }

                    public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                        return LIQUID_NULL_UNDERWATER;
                    }

                    public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                        return new Vector3f(0.0f, 0.0f, 0.0f);
                    }

                    public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                        RenderSystem.setShaderFogStart((float)0.1f);
                        RenderSystem.setShaderFogEnd((float)2.5f);
                    }
                });
            }
        }, "liquid_null");
    }

    public static DeferredHolder<FluidType, FluidType> registerFluidType(Supplier<FluidType> fluidSupplier, String name) {
        return BiomesOPlentyNeoForge.FORGE_FLUID_REGISTER.register(name, fluidSupplier);
    }

    public static void registerFluidInteractions() {
        for (Map.Entry fluidType : NeoForgeRegistries.FLUID_TYPES.entrySet()) {
            if (fluidType.getValue() != NeoForgeMod.EMPTY_TYPE.value() && fluidType.getValue() != BLOOD_TYPE.value()) {
                FluidInteractionRegistry.addInteraction((FluidType)((FluidType)fluidType.getValue()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)BLOOD_TYPE.value(), fluidState -> fluidState.isSource() ? BOPBlocks.FLESH.defaultBlockState() : BOPBlocks.POROUS_FLESH.defaultBlockState()));
            }
            if (fluidType.getValue() == NeoForgeMod.EMPTY_TYPE.value() || fluidType.getValue() == LIQUID_NULL_TYPE.value()) continue;
            FluidInteractionRegistry.addInteraction((FluidType)((FluidType)fluidType.getValue()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)LIQUID_NULL_TYPE.value(), BOPBlocks.NULL_BLOCK.defaultBlockState()));
        }
    }
}

