/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bettertridents.world.entity.item;

import fuzs.bettertridents.handler.LoyalDropsHandler;
import fuzs.bettertridents.init.ModRegistry;
import fuzs.bettertridents.mixin.accessor.ExperienceOrbAccessor;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class LoyalExperienceOrb
extends ExperienceOrb {
    private static final EntityDataAccessor<Optional<UUID>> DATA_OWNER = SynchedEntityData.defineId(LoyalExperienceOrb.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Byte> DATA_LOYALTY = SynchedEntityData.defineId(LoyalExperienceOrb.class, (EntityDataSerializer)EntityDataSerializers.BYTE);

    public LoyalExperienceOrb(Level level, double x, double y, double z, int value, @Nullable UUID owner, int loyaltyLevel) {
        super((EntityType)ModRegistry.LOYAL_EXPERIENCE_ORB_ENTITY_TYPE.value(), level);
        this.setPos(x, y, z);
        this.setYRot((float)(this.random.nextDouble() * 360.0));
        this.setDeltaMovement((this.random.nextDouble() * (double)0.2f - (double)0.1f) * 2.0, this.random.nextDouble() * 0.2 * 2.0, (this.random.nextDouble() * (double)0.2f - (double)0.1f) * 2.0);
        ((ExperienceOrbAccessor)((Object)this)).setValue(value);
        this.getEntityData().set(DATA_OWNER, Optional.ofNullable(owner));
        this.getEntityData().set(DATA_LOYALTY, (Object)((byte)loyaltyLevel));
    }

    public LoyalExperienceOrb(EntityType<? extends ExperienceOrb> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_OWNER, Optional.empty());
        builder.define(DATA_LOYALTY, (Object)0);
    }

    public void tick() {
        Player player = this.getOwner() != null ? LoyalDropsHandler.isAcceptableReturnOwner(this.level(), (Entity)this.level().getPlayerByUUID(this.getOwner())) : null;
        if (player != null) {
            LoyalDropsHandler.tickLoyalEntity((Entity)this, player, ((Byte)this.getEntityData().get(DATA_LOYALTY)).byteValue());
            ((ExperienceOrbAccessor)((Object)this)).setAge(((ExperienceOrbAccessor)((Object)this)).getAge() + 1);
            if (((ExperienceOrbAccessor)((Object)this)).getAge() >= 6000) {
                this.discard();
            }
        } else if (!this.level().isClientSide) {
            super.tick();
        }
    }

    @Nullable
    public UUID getOwner() {
        return ((Optional)this.getEntityData().get(DATA_OWNER)).orElse(null);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.getOwner() != null) {
            compound.putUUID("Owner", this.getOwner());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.hasUUID("Owner")) {
            this.getEntityData().set(DATA_OWNER, Optional.of(compound.getUUID("Owner")));
        }
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        return new ClientboundAddEntityPacket((Entity)this, entity);
    }
}

