/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.model;

import com.google.common.collect.ImmutableList;
import fuzs.betteranimationscollection.client.model.HumanoidKneesModel;
import fuzs.betteranimationscollection.client.model.KneesModel;
import it.unimi.dsi.fastutil.Pair;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PiglinModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Mob;

public class PiglinKneesModel<T extends Mob>
extends PiglinModel<T>
implements KneesModel {
    private final ModelPart rightShin;
    private final ModelPart leftShin;
    private final ModelPart rightPants;
    private final ModelPart leftPants;
    private final ModelPart rightLowerPants;
    private final ModelPart leftLowerPants;

    public PiglinKneesModel(ModelPart modelPart) {
        super(modelPart);
        ModelPart rightLeg = modelPart.getChild("right_leg");
        this.rightShin = rightLeg.getChild("right_shin");
        ModelPart leftLeg = modelPart.getChild("left_leg");
        this.leftShin = leftLeg.getChild("left_shin");
        this.rightPants = modelPart.getChild("right_pants");
        this.rightLowerPants = this.rightPants.getChild("right_lower_pants");
        this.leftPants = modelPart.getChild("left_pants");
        this.leftLowerPants = this.leftPants.getChild("left_lower_pants");
    }

    public static LayerDefinition createAnimatedBodyLayer() {
        MeshDefinition meshDefinition = PiglinModel.createMesh((CubeDeformation)CubeDeformation.NONE);
        PartDefinition partDefinition = meshDefinition.getRoot();
        Pair<CubeListBuilder, PartPose> rightLeg = HumanoidKneesModel.createShin(0, 16, -1.9f, 0.0f, 0.0f, false, CubeDeformation.NONE);
        Pair<CubeListBuilder, PartPose> leftLeg = HumanoidKneesModel.createShin(16, 48, 1.9f, 0.0f, 0.0f, true, CubeDeformation.NONE);
        Pair<CubeListBuilder, PartPose> rightShin = HumanoidKneesModel.createShin(0, 22, 0.0f, -6.0f, -2.0f, false, CubeDeformation.NONE);
        Pair<CubeListBuilder, PartPose> leftShin = HumanoidKneesModel.createShin(16, 54, 0.0f, -6.0f, -2.0f, true, CubeDeformation.NONE);
        PartDefinition partDefinition1 = partDefinition.addOrReplaceChild("right_leg", (CubeListBuilder)rightLeg.left(), (PartPose)rightLeg.right());
        PartDefinition partDefinition2 = partDefinition.addOrReplaceChild("left_leg", (CubeListBuilder)leftLeg.left(), (PartPose)leftLeg.right());
        partDefinition1.addOrReplaceChild("right_shin", (CubeListBuilder)rightShin.left(), (PartPose)rightShin.right());
        partDefinition2.addOrReplaceChild("left_shin", (CubeListBuilder)leftShin.left(), (PartPose)leftShin.right());
        CubeDeformation cubeDeformation = new CubeDeformation(0.25f);
        Pair<CubeListBuilder, PartPose> rightPants = HumanoidKneesModel.createShin(0, 32, -1.9f, 0.0f, 0.0f, false, cubeDeformation);
        Pair<CubeListBuilder, PartPose> leftPants = HumanoidKneesModel.createShin(0, 48, 1.9f, 0.0f, 0.0f, true, cubeDeformation);
        Pair<CubeListBuilder, PartPose> rightLowerPants = HumanoidKneesModel.createShin(0, 38, 0.0f, -6.0f, -2.0f, false, cubeDeformation);
        Pair<CubeListBuilder, PartPose> leftLowerPants = HumanoidKneesModel.createShin(0, 54, 0.0f, -6.0f, -2.0f, true, cubeDeformation);
        PartDefinition partDefinition11 = partDefinition.addOrReplaceChild("right_pants", (CubeListBuilder)rightPants.left(), (PartPose)rightPants.right());
        PartDefinition partDefinition22 = partDefinition.addOrReplaceChild("left_pants", (CubeListBuilder)leftPants.left(), (PartPose)leftPants.right());
        partDefinition11.addOrReplaceChild("right_lower_pants", (CubeListBuilder)rightLowerPants.left(), (PartPose)rightLowerPants.right());
        partDefinition22.addOrReplaceChild("left_lower_pants", (CubeListBuilder)leftLowerPants.left(), (PartPose)leftLowerPants.right());
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightArm, (Object)this.leftArm, (Object)this.rightLeg, (Object)this.leftLeg, (Object)this.hat, (Object)this.leftPants, (Object)this.rightPants, (Object)this.leftSleeve, (Object)this.rightSleeve, (Object)this.jacket);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        KneesModel.setupAnim(this, entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.rightPants.copyFrom(this.rightLeg);
        this.leftPants.copyFrom(this.leftLeg);
        this.rightLowerPants.copyFrom(this.rightShin);
        this.leftLowerPants.copyFrom(this.leftShin);
    }

    public void copyPropertiesTo(HumanoidModel<T> model) {
        super.copyPropertiesTo(model);
        KneesModel.copyPropertiesTo(this, model);
    }

    @Override
    public ModelPart rightShin() {
        return this.rightShin;
    }

    @Override
    public ModelPart leftShin() {
        return this.leftShin;
    }
}

