/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.model;

import fuzs.betteranimationscollection.client.element.OcelotTailElement;
import net.minecraft.client.model.OcelotModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class OcelotTailModel<T extends Entity>
extends OcelotModel<T> {
    public static final int OCELOT_TAIL_LENGTH = 15;
    private final ModelPart tail;
    private final ModelPart[] tailParts;

    public OcelotTailModel(ModelPart modelPart) {
        super(modelPart);
        this.tail = modelPart.getChild("tail1");
        this.tailParts = OcelotTailModel.getTailParts(this.tail);
    }

    public static LayerDefinition createAnimatedBodyMesh(CubeDeformation cubeDeformation) {
        MeshDefinition meshDefinition = OcelotModel.createBodyMesh((CubeDeformation)cubeDeformation);
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition partDefinition1 = partDefinition.addOrReplaceChild("tail1", CubeListBuilder.create().texOffs(0, 15).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)15.0f, (float)8.0f, (float)0.9f, (float)0.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("tail2", CubeListBuilder.create(), PartPose.ZERO);
        for (int i = 0; i < 15; ++i) {
            partDefinition1 = i < 7 ? partDefinition1.addOrReplaceChild("tail" + (i + 2), CubeListBuilder.create().texOffs(0, 16 + i).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f)) : partDefinition1.addOrReplaceChild("tail" + (i + 2), CubeListBuilder.create().texOffs(4, 8 + i).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        }
        CubeListBuilder cubeListBuilder2 = CubeListBuilder.create().texOffs(40, 0).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 10.0f, 2.0f, cubeDeformation);
        partDefinition.addOrReplaceChild("left_front_leg", cubeListBuilder2, PartPose.offset((float)1.2f, (float)13.7f, (float)-5.0f));
        partDefinition.addOrReplaceChild("right_front_leg", cubeListBuilder2, PartPose.offset((float)-1.2f, (float)13.7f, (float)-5.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public static ModelPart[] getTailParts(ModelPart tail) {
        ModelPart[] tailParts = new ModelPart[15];
        for (int i = 0; i < tailParts.length; ++i) {
            tailParts[i] = i == 0 ? tail.getChild("tail" + (i + 2)) : tailParts[i - 1].getChild("tail" + (i + 2));
        }
        return tailParts;
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.tail.y = this.tail1.y;
        this.tail.z = this.tail1.z;
        this.tail.xRot = this.tail1.xRot;
        OcelotTailModel.setupTailAnim(this.tail, this.tailParts, limbSwing, limbSwingAmount, ageInTicks, OcelotTailElement.animationSpeed, OcelotTailElement.tailLength);
        super.setupAnim(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    public static void setupTailAnim(ModelPart tail, ModelPart[] tailParts, float limbSwing, float limbSwingAmount, float ageInTicks, int animationSpeed, int tailLength) {
        float magnitude = (0.5f + limbSwingAmount) * 0.125f;
        float amplitude = limbSwing * 0.6662f + ageInTicks / 4.66f * 0.6662f;
        tail.xRot += Mth.sin((float)amplitude) * magnitude;
        for (int i = 0; i < tailParts.length; ++i) {
            tailParts[i].zRot = 0.0f;
            tailParts[i].xRot = 0.05f;
            tailParts[i].xRot += Mth.sin((float)(amplitude - (float)(i + 1) * (float)animationSpeed * 0.05f)) * magnitude;
            tailParts[i].visible = i < tailLength;
        }
    }
}

