/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.model;

import fuzs.betteranimationscollection.mixin.client.accessor.LayerDefinitionAccessor;
import net.minecraft.client.model.IronGolemModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.IronGolem;

public class IronGolemNoseModel<T extends IronGolem>
extends IronGolemModel<T> {
    private final ModelPart nose;

    public IronGolemNoseModel(ModelPart modelPart) {
        super(modelPart);
        ModelPart head = modelPart.getChild("head");
        this.nose = head.getChild("nose");
    }

    public static LayerDefinition createAnimatedBodyLayer() {
        LayerDefinition layerDefinition = IronGolemModel.createBodyLayer();
        MeshDefinition meshDefinition = ((LayerDefinitionAccessor)layerDefinition).getMesh();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition partDefinition1 = partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -12.0f, -5.5f, 8.0f, 10.0f, 8.0f), PartPose.offset((float)0.0f, (float)-7.0f, (float)-2.0f));
        partDefinition1.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(24, 0).addBox(-1.0f, -1.0f, -7.5f, 2.0f, 4.0f, 2.0f), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        return layerDefinition;
    }

    public void prepareMobModel(T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        super.prepareMobModel(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTickTime);
        int soundTime = ((IronGolem)entitylivingbaseIn).ambientSoundTime + entitylivingbaseIn.getAmbientSoundInterval();
        int maxSoundTime = 20;
        if (0 < soundTime && soundTime < 20) {
            float rotation = Mth.sin((float)((float)soundTime * 0.4712389f));
            this.nose.zRot = rotation * 0.75f * ((float)(20 - soundTime) / 20.0f);
        } else {
            this.nose.zRot = 0.0f;
        }
    }
}

