/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.neoforge.handler;

import betteradvancements.common.gui.BetterAdvancementsScreen;
import betteradvancements.common.gui.BetterAdvancementsScreenButton;
import betteradvancements.common.util.AdvancementComparer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.advancements.AdvancementsScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;

public class GuiOpenHandler {
    public static final GuiOpenHandler instance = new GuiOpenHandler();

    private GuiOpenHandler() {
    }

    @SubscribeEvent
    public void onGuiOpen(ScreenEvent.Opening event) {
        if (event.getScreen() instanceof AdvancementsScreen) {
            event.setCanceled(true);
            Minecraft mc = Minecraft.getInstance();
            mc.setScreen((Screen)new BetterAdvancementsScreen(mc.player.connection.getAdvancements()));
        }
    }

    @SubscribeEvent
    public void onGuiOpened(ScreenEvent.Init.Post event) {
        if (event.getScreen() instanceof InventoryScreen && BetterAdvancementsScreenButton.addToInventory) {
            InventoryScreen guiInventory = (InventoryScreen)event.getScreen();
            event.addListener((GuiEventListener)new BetterAdvancementsScreenButton(guiInventory.getGuiLeft() + guiInventory.getXSize(), guiInventory.getGuiTop(), (Component)Component.literal((String)"BA")));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onGuiAboutToOpen(ScreenEvent.Init.Pre event) {
        if (event.getScreen() instanceof BetterAdvancementsScreen && BetterAdvancementsScreen.orderTabsAlphabetically) {
            Minecraft mc = Minecraft.getInstance();
            ClientAdvancements clientAdvancements = mc.player.connection.getAdvancements();
            AdvancementTree advancementTree = clientAdvancements.getTree();
            Set roots = (Set)advancementTree.roots();
            List<String> advancementLocations = roots.stream().sorted(AdvancementComparer.sortByTitle()).map(n -> n.holder().id().toString()).toList();
            ArrayList advancements = new ArrayList(roots);
            roots.clear();
            for (String location : advancementLocations) {
                for (AdvancementNode advancement : advancements) {
                    if (!advancement.holder().id().toString().equals(location)) continue;
                    roots.add(advancement);
                }
            }
        }
    }
}

