/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.common.util;

import betteradvancements.common.util.CriteriaDetail;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class CriterionGrid {
    public static CriteriaDetail detailLevel = CriteriaDetail.DEFAULT;
    public static boolean requiresShift = false;
    private static final CriterionGrid empty = new CriterionGrid();
    private final List<Component> cellContents;
    private final int[] cellWidths;
    private final int fontHeight;
    private final int numColumns;
    public final int numRows;
    public List<Column> columns;
    public int width;
    public int height;

    private CriterionGrid() {
        this.cellContents = Collections.emptyList();
        this.cellWidths = new int[0];
        this.fontHeight = 0;
        this.numColumns = 0;
        this.numRows = 0;
        this.columns = Collections.emptyList();
        this.width = 0;
        this.height = 0;
    }

    public CriterionGrid(List<Component> cellContents, int[] cellWidths, int fontHeight, int numColumns) {
        this.cellContents = cellContents;
        this.cellWidths = cellWidths;
        this.fontHeight = fontHeight;
        this.numColumns = numColumns;
        this.numRows = (int)Math.ceil((double)cellContents.size() / (double)numColumns);
    }

    public void init() {
        this.columns = new ArrayList<Column>();
        this.width = 0;
        for (int c = 0; c < this.numColumns; ++c) {
            int cellIndex;
            ArrayList<Component> column = new ArrayList<Component>();
            int columnWidth = 0;
            for (int r = 0; r < this.numRows && (cellIndex = c * this.numRows + r) < this.cellContents.size(); ++r) {
                column.add(this.cellContents.get(cellIndex));
                columnWidth = Math.max(columnWidth, this.cellWidths[cellIndex]);
            }
            this.columns.add(new Column(column, columnWidth));
            this.width += columnWidth;
        }
        this.height = this.numRows * this.fontHeight;
    }

    public static CriterionGrid findOptimalCriterionGrid(AdvancementHolder holder, Advancement advancement, AdvancementProgress progress, int maxWidth, Font font) {
        if (progress == null || progress.isDone() || detailLevel.equals((Object)CriteriaDetail.OFF)) {
            return empty;
        }
        AdvancementRequirements requirements = advancement.requirements();
        if (requirements.size() <= 1) {
            return empty;
        }
        int numUnobtained = 0;
        ArrayList<Component> cellContents = new ArrayList<Component>();
        for (String criterion : requirements.names()) {
            MutableComponent text2;
            MutableComponent text;
            CriterionProgress criterionProgress = progress.getCriterion(criterion);
            String criterionKey = "betteradvancements.criterion." + String.valueOf(holder.id()) + "." + criterion;
            if (criterionProgress != null && criterionProgress.isDone()) {
                if (!detailLevel.showObtained()) continue;
                text = Component.literal((String)" + ").withStyle(ChatFormatting.GREEN);
                text2 = Component.translatableWithFallback((String)criterionKey, (String)criterion).withStyle(ChatFormatting.WHITE);
                text.append((Component)text2);
                cellContents.add((Component)text);
                continue;
            }
            if (detailLevel.showUnobtained()) {
                text = Component.literal((String)" x ").withStyle(ChatFormatting.DARK_RED);
                text2 = Component.translatableWithFallback((String)criterionKey, (String)criterion).withStyle(ChatFormatting.WHITE);
                text.append((Component)text2);
                cellContents.add((Component)text);
            }
            ++numUnobtained;
        }
        if (!detailLevel.showUnobtained()) {
            MutableComponent text = Component.literal((String)" x ").withStyle(ChatFormatting.DARK_RED);
            MutableComponent text2 = Component.translatable((String)"betteradvancements.remaining", (Object[])new Object[]{numUnobtained}).withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.ITALIC});
            text.append((Component)text2);
            cellContents.add((Component)text);
        }
        int[] cellWidths = new int[cellContents.size()];
        for (int i = 0; i < cellWidths.length; ++i) {
            cellWidths[i] = font.width((FormattedText)cellContents.get(i));
        }
        int numCols = 0;
        CriterionGrid prevGrid = null;
        CriterionGrid currGrid = null;
        do {
            Objects.requireNonNull(font);
            CriterionGrid newGrid = new CriterionGrid(cellContents, cellWidths, 9, ++numCols);
            if (prevGrid != null && newGrid.numRows == prevGrid.numRows) continue;
            newGrid.init();
            prevGrid = currGrid;
            currGrid = newGrid;
        } while (numCols <= cellContents.size() && currGrid.width <= maxWidth);
        return prevGrid != null ? prevGrid : currGrid;
    }

    public record Column(List<Component> cells, int width) {
    }
}

