/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bagofholding.mixin;

import fuzs.bagofholding.init.ModRegistry;
import net.minecraft.recipebook.ServerPlaceRecipe;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={ServerPlaceRecipe.class})
abstract class ServerPlaceRecipeMixin<I extends RecipeInput, R extends Recipe<I>> {
    @Shadow
    protected Inventory inventory;

    ServerPlaceRecipeMixin() {
    }

    @ModifyVariable(method={"moveItemToGrid"}, at=@At(value="STORE"), ordinal=1)
    public int moveItemToGrid(int index, Slot slot, ItemStack itemStack, int maxAmount) {
        if (itemStack.is(ModRegistry.RECIPES_IGNORE_COMPONENTS_ITEM_TAG)) {
            return this.bagofholding$findSlotMatchingUnusedItem(this.inventory, itemStack);
        }
        return index;
    }

    @Unique
    private int bagofholding$findSlotMatchingUnusedItem(Inventory inventory, ItemStack itemStack) {
        for (int i = 0; i < inventory.items.size(); ++i) {
            if (((ItemStack)inventory.items.get(i)).isEmpty() || !itemStack.is(((ItemStack)inventory.items.get(i)).getItem())) continue;
            return i;
        }
        return -1;
    }
}

