/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bagofholding.client.gui.screens.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.bagofholding.BagOfHolding;
import fuzs.bagofholding.config.ClientConfig;
import fuzs.bagofholding.world.inventory.BagItemMenu;
import fuzs.bagofholding.world.inventory.LockableInventorySlot;
import fuzs.puzzleslib.api.client.core.v1.ClientAbstractions;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class BagItemScreen
extends AbstractContainerScreen<BagItemMenu> {
    private static final ResourceLocation CONTAINER_BACKGROUND = ResourceLocationHelper.withDefaultNamespace((String)"textures/gui/container/generic_54.png");
    private static final float[] DEFAULT_BACKGROUND_COLOR = new float[]{1.0f, 1.0f, 1.0f};

    public BagItemScreen(BagItemMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.imageHeight = 114 + menu.getInventoryHeight() * 18;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        float[] backgroundColor = ((ClientConfig)BagOfHolding.CONFIG.get(ClientConfig.class)).colorfulMenuBackgrounds ? ((BagItemMenu)this.menu).getBackgroundColor() : DEFAULT_BACKGROUND_COLOR;
        RenderSystem.setShaderColor((float)backgroundColor[0], (float)backgroundColor[1], (float)backgroundColor[2], (float)1.0f);
        int leftPos = (this.width - this.imageWidth) / 2;
        int topPos = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(CONTAINER_BACKGROUND, leftPos, topPos, 0, 0, this.imageWidth, 17);
        int inventoryHeight = ((BagItemMenu)this.menu).getInventoryHeight();
        for (int k = 0; k < (int)Math.ceil((double)inventoryHeight / 6.0); ++k) {
            guiGraphics.blit(CONTAINER_BACKGROUND, leftPos, topPos + 17 + 108 * k, 0, 17, this.imageWidth, Math.min(inventoryHeight - 6 * k, 6) * 18);
        }
        guiGraphics.blit(CONTAINER_BACKGROUND, leftPos, topPos + inventoryHeight * 18 + 17, 0, 126, this.imageWidth, 96);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0xFFFFFF, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0xFFFFFF, false);
    }

    protected boolean checkHotbarKeyPressed(int keyCode, int scanCode) {
        if (((BagItemMenu)this.menu).getCarried().isEmpty() && this.hoveredSlot != null) {
            for (int i = 0; i < 9; ++i) {
                LockableInventorySlot slot;
                Slot slot2;
                if (!ClientAbstractions.INSTANCE.isKeyActiveAndMatches(this.minecraft.options.keyHotbarSlots[i], keyCode, scanCode) || !((slot2 = ((BagItemMenu)this.menu).getSlot(((BagItemMenu)this.menu).getHotbarStartIndex() + i)) instanceof LockableInventorySlot) || !(slot = (LockableInventorySlot)slot2).locked()) continue;
                return true;
            }
        }
        return super.checkHotbarKeyPressed(keyCode, scanCode);
    }

    public boolean isHoveredSlot(Slot slot) {
        return this.hoveredSlot == slot;
    }
}

