/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bagofholding.capability;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import fuzs.bagofholding.BagOfHolding;
import fuzs.bagofholding.config.ServerConfig;
import fuzs.bagofholding.init.ModRegistry;
import fuzs.puzzleslib.api.capability.v3.data.CapabilityComponent;
import fuzs.puzzleslib.api.container.v1.ContainerSerializationHelper;
import fuzs.puzzleslib.api.init.v3.registry.LookupHelper;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;

public class BagPerseveranceCapability
extends CapabilityComponent<Player> {
    private static final String TAG_AMOUNT = BagOfHolding.id("amount").toString();
    private static final String TAG_ITEMS = BagOfHolding.id("items").toString();
    public static final Codec<BagPerseveranceCapability> CODEC = ItemStack.CODEC.listOf().xmap(BagPerseveranceCapability::new, capability -> capability.items);
    private List<ItemStack> items;

    private BagPerseveranceCapability(List<ItemStack> items) {
        this.items = items;
    }

    public BagPerseveranceCapability() {
        this((List<ItemStack>)ImmutableList.of());
    }

    public void saveOnDeath() {
        if (!((Player)this.getHolder()).level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY)) {
            Inventory inventory = ((Player)this.getHolder()).getInventory();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                ItemStack itemStack = inventory.getItem(i);
                Holder enchantment = LookupHelper.lookup((Entity)((Entity)this.getHolder()), (ResourceKey)Registries.ENCHANTMENT, ModRegistry.PRESERVATION_ENCHANTMENT);
                if (itemStack.isEmpty() || EnchantmentHelper.getItemEnchantmentLevel((Holder)enchantment, (ItemStack)itemStack) <= 0) continue;
                inventory.removeItemNoUpdate(i);
                if (!((Player)this.getHolder()).getAbilities().instabuild && ((Player)this.getHolder()).getRandom().nextDouble() < ((ServerConfig)BagOfHolding.CONFIG.get(ServerConfig.class)).preservationLevelLossChance) {
                    EnchantmentHelper.updateEnchantments((ItemStack)itemStack, enchantments -> enchantments.set(enchantment, enchantments.getLevel(enchantment) - 1));
                }
                builder.add((Object)itemStack);
            }
            this.items = builder.build();
            if (!this.items.isEmpty()) {
                this.setChanged();
            }
        }
    }

    public void restoreAfterRespawn(Player newPlayer) {
        if (!this.items.isEmpty()) {
            this.giveItemsToPlayer(this.items, newPlayer);
            this.items = ImmutableList.of();
            this.setChanged();
        }
    }

    private void giveItemsToPlayer(List<ItemStack> items, Player player) {
        for (ItemStack itemstack : items) {
            ItemEntity itemEntity;
            boolean flag = player.getInventory().add(itemstack);
            if (flag && itemstack.isEmpty()) {
                itemstack.setCount(1);
                itemEntity = player.drop(itemstack, false);
                if (itemEntity != null) {
                    itemEntity.makeFakeItem();
                }
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((player.getRandom().nextFloat() - player.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                player.containerMenu.broadcastChanges();
                continue;
            }
            itemEntity = player.drop(itemstack, false);
            if (itemEntity == null) continue;
            itemEntity.setNoPickUpDelay();
            itemEntity.setTarget(player.getUUID());
        }
    }

    public void write(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putByte(TAG_AMOUNT, (byte)this.items.size());
        ContainerSerializationHelper.saveAllItems((String)TAG_ITEMS, (CompoundTag)tag, (int)this.items.size(), this.items::get, (boolean)false, (HolderLookup.Provider)registries);
    }

    public void read(CompoundTag tag, HolderLookup.Provider registries) {
        byte amount = tag.getByte(TAG_AMOUNT);
        if (amount != 0) {
            ImmutableList.Builder builder = ImmutableList.builder();
            ContainerSerializationHelper.loadAllItems((String)TAG_ITEMS, (CompoundTag)tag, (int)amount, (element, index) -> builder.add(element), (HolderLookup.Provider)registries);
            this.items = builder.build();
        }
    }
}

