/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bagofholding;

import fuzs.bagofholding.capability.BagPerseveranceCapability;
import fuzs.bagofholding.config.ClientConfig;
import fuzs.bagofholding.config.ServerConfig;
import fuzs.bagofholding.init.ModRegistry;
import fuzs.bagofholding.network.S2CLockSlotMessage;
import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.context.CreativeModeTabContext;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerCopyEvents;
import fuzs.puzzleslib.api.item.v2.CreativeModeTabConfigurator;
import fuzs.puzzleslib.api.network.v3.NetworkHandler;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BagOfHolding
implements ModConstructor {
    public static final String MOD_ID = "bagofholding";
    public static final String MOD_NAME = "Bag Of Holding";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Bag Of Holding");
    public static final NetworkHandler NETWORK = NetworkHandler.builder((String)"bagofholding").registerLegacyClientbound(S2CLockSlotMessage.class, S2CLockSlotMessage::new);
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"bagofholding").client(ClientConfig.class).server(ServerConfig.class);

    public void onConstructMod() {
        ModRegistry.touch();
        BagOfHolding.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        PlayerCopyEvents.COPY.register((originalPlayer, newPlayer, alive) -> {
            if (!alive) {
                ((BagPerseveranceCapability)ModRegistry.BAG_PERSEVERANCE_CAPABILITY.get((Object)originalPlayer)).restoreAfterRespawn((Player)newPlayer);
            }
        });
    }

    public void onRegisterCreativeModeTabs(CreativeModeTabContext context) {
        context.registerCreativeModeTab(CreativeModeTabConfigurator.from((String)MOD_ID).icon(() -> new ItemStack((ItemLike)ModRegistry.GOLDEN_BAG_OF_HOLDING_ITEM.value())).displayItems((itemDisplayParameters, output) -> {
            output.accept((ItemLike)ModRegistry.LEATHER_BAG_OF_HOLDING_ITEM.value());
            output.accept((ItemLike)ModRegistry.IRON_BAG_OF_HOLDING_ITEM.value());
            output.accept((ItemLike)ModRegistry.GOLDEN_BAG_OF_HOLDING_ITEM.value());
        }).appendEnchantmentsAndPotions());
    }

    public ContentRegistrationFlags[] getContentRegistrationFlags() {
        return new ContentRegistrationFlags[]{ContentRegistrationFlags.COPY_RECIPES};
    }

    public static ResourceLocation id(String path) {
        return ResourceLocationHelper.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

