/*
 * Decompiled with CFR 0.152.
 */
package forge.me.thosea.badoptimizations.other;

import forge.me.thosea.badoptimizations.utils.PlatformMethods;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.commons.lang3.function.FailableRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Config {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"BadOptimizations");
    public static final Path FILE = PlatformMethods.getConfigFolder().resolve("badoptimizations.txt");
    public static final int CURRENT_CONFIG_VER = 4;
    public static boolean enable_lightmap_caching = true;
    public static int lightmap_time_change_needed_for_update = 80;
    public static boolean enable_sky_color_caching = true;
    public static int skycolor_time_change_needed_for_update = 3;
    public static boolean enable_debug_renderer_disable_if_not_needed = true;
    public static boolean enable_particle_manager_optimization = true;
    public static boolean enable_toast_optimizations = true;
    public static boolean enable_sky_angle_caching_in_worldrenderer = true;
    public static boolean enable_entity_renderer_caching = true;
    public static boolean enable_block_entity_renderer_caching = true;
    public static boolean enable_entity_flag_caching = true;
    public static boolean enable_remove_redundant_fov_calculations = true;
    public static boolean enable_remove_tutorial_if_not_demo = true;
    public static boolean show_f3_text = true;
    public static boolean ignore_mod_compatibilities = false;
    public static boolean log_config = true;

    private Config() {
    }

    public static void load() {
        if (Files.exists(FILE, new LinkOption[0])) {
            LOGGER.info("Loading config file");
            Config.doOrCrash((FailableRunnable<Exception>)((FailableRunnable)Config::loadConfig), e -> LOGGER.error("Failed to load config from " + String.valueOf(FILE) + ". If you need to, you can delete the file to generate a new one.", (Throwable)e));
        } else {
            Config.doOrCrash((FailableRunnable<Exception>)((FailableRunnable)Config::writeConfig), e -> LOGGER.error("Failed to write default config to " + String.valueOf(FILE), (Throwable)e));
            Config.applyIncompatibilities();
        }
    }

    private static void doOrCrash(FailableRunnable<Exception> action, Consumer<Exception> onFail) {
        try {
            action.run();
        }
        catch (Exception e) {
            onFail.accept(e);
            System.exit(1);
        }
    }

    private static void loadConfig() throws Exception {
        Properties prop = new Properties();
        try (InputStream stream = Files.newInputStream(FILE, new OpenOption[0]);){
            prop.load(stream);
        }
        int ver = Config.num(prop, "config_version");
        if (ver > 4) {
            LOGGER.warn("Config version is newer than supported, this may cause issues (supported: {}, found: {})", (Object)4, (Object)ver);
        } else if (ver < 4) {
            LOGGER.info("Upgrading config from version {} to supported version {}", (Object)ver, (Object)4);
        } else {
            LOGGER.info("Config version: {}", (Object)4);
        }
        if (ver >= 2) {
            ignore_mod_compatibilities = Config.bool(prop, "ignore_mod_incompatibilities");
            log_config = Config.bool(prop, "log_config");
            if (log_config) {
                LOGGER.info("BadOptimizations config dump:");
                prop.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> LOGGER.info("{}: {}", key, value)));
            }
        }
        lightmap_time_change_needed_for_update = Config.num(prop, "lightmap_time_change_needed_for_update");
        enable_lightmap_caching = Config.bool(prop, "enable_lightmap_caching") && lightmap_time_change_needed_for_update > 1;
        enable_sky_color_caching = Config.bool(prop, "enable_sky_color_caching");
        skycolor_time_change_needed_for_update = Config.num(prop, "skycolor_time_change_needed_for_update");
        enable_debug_renderer_disable_if_not_needed = Config.bool(prop, "enable_debug_renderer_disable_if_not_needed");
        enable_particle_manager_optimization = Config.bool(prop, "enable_particle_manager_optimization");
        enable_toast_optimizations = Config.bool(prop, "enable_toast_optimizations");
        enable_sky_angle_caching_in_worldrenderer = Config.bool(prop, "enable_sky_angle_caching_in_worldrenderer");
        enable_entity_renderer_caching = Config.bool(prop, "enable_entity_renderer_caching");
        enable_block_entity_renderer_caching = Config.bool(prop, "enable_block_entity_renderer_caching");
        enable_entity_flag_caching = Config.bool(prop, "enable_entity_flag_caching");
        enable_remove_redundant_fov_calculations = Config.bool(prop, "enable_remove_redundant_fov_calculations");
        enable_remove_tutorial_if_not_demo = Config.bool(prop, "enable_remove_tutorial_if_not_demo");
        show_f3_text = Config.bool(prop, "show_f3_text");
        if (ver < 4) {
            Config.writeConfig();
        }
        Config.applyIncompatibilities();
    }

    private static boolean bool(Properties prop, String option) {
        String str = prop.getProperty(option);
        if (str == null) {
            throw new IllegalStateException("Config option " + option + " not found.");
        }
        if (str.equalsIgnoreCase("true")) {
            return true;
        }
        if (str.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalStateException("Config option " + option + " is not \"true\" or \"false\" (\"" + str + "\").");
    }

    private static boolean hasIncompatibilities(String option) {
        List<String> incompatibilities;
        switch (option) {
            case "enable_entity_renderer_caching": {
                List<String> list = List.of("twilightforest", "bedrockskinutility", "lazyyyyy");
                break;
            }
            case "enable_block_entity_renderer_caching": {
                List<String> list = List.of("lazyyyyy");
                break;
            }
            case "enable_sky_color_caching": {
                List<String> list = List.of("polytone");
                break;
            }
            case "enable_lightmap_caching": {
                List<String> list = List.of("polytone");
                break;
            }
            case "enable_entity_flag_caching": {
                List<String> list = List.of("biomeswevegone", "performant");
                break;
            }
            case "enable_remove_redundant_fov_calculations": {
                List<String> list = List.of("camera_lock_on");
                break;
            }
            default: {
                List<String> list = incompatibilities = null;
            }
        }
        if (incompatibilities == null) {
            return false;
        }
        for (String mod : incompatibilities) {
            if (!PlatformMethods.isModLoaded(mod)) continue;
            LOGGER.info("Disabling {} because mod \"{}\" is present", (Object)option, (Object)mod);
            return true;
        }
        return false;
    }

    private static int num(Properties prop, String option) {
        int result;
        String str = prop.getProperty(option);
        if (str == null) {
            throw new IllegalStateException("Config option " + option + " not found.");
        }
        try {
            result = Integer.parseInt(str);
        }
        catch (Exception e) {
            throw new IllegalStateException("Config option " + option + " is not a valid number (\"" + str + "\").");
        }
        if (result < 0) {
            throw new IllegalStateException("Config option " + option + " is negative (" + str + ")");
        }
        return result;
    }

    private static void applyIncompatibilities() {
        if (ignore_mod_compatibilities) {
            return;
        }
        enable_lightmap_caching = enable_lightmap_caching && !Config.hasIncompatibilities("enable_lightmap_caching");
        enable_sky_color_caching = enable_sky_color_caching && !Config.hasIncompatibilities("enable_sky_color_caching");
        enable_debug_renderer_disable_if_not_needed = enable_debug_renderer_disable_if_not_needed && !Config.hasIncompatibilities("enable_debug_renderer_disable_if_not_needed");
        enable_particle_manager_optimization = enable_particle_manager_optimization && !Config.hasIncompatibilities("enable_particle_manager_optimization");
        enable_toast_optimizations = enable_toast_optimizations && !Config.hasIncompatibilities("enable_toast_optimizations");
        enable_sky_angle_caching_in_worldrenderer = enable_sky_angle_caching_in_worldrenderer && !Config.hasIncompatibilities("enable_sky_angle_caching_in_worldrenderer");
        enable_entity_renderer_caching = enable_entity_renderer_caching && !Config.hasIncompatibilities("enable_entity_renderer_caching");
        enable_block_entity_renderer_caching = enable_block_entity_renderer_caching && !Config.hasIncompatibilities("enable_block_entity_renderer_caching");
        enable_entity_flag_caching = enable_entity_flag_caching && !Config.hasIncompatibilities("enable_entity_flag_caching");
        enable_remove_redundant_fov_calculations = enable_remove_redundant_fov_calculations && !Config.hasIncompatibilities("enable_remove_redundant_fov_calculations");
        enable_remove_tutorial_if_not_demo = enable_remove_tutorial_if_not_demo && !Config.hasIncompatibilities("enable_remove_tutorial_if_not_demo");
    }

    public static void writeConfig() throws Exception {
        String template;
        LOGGER.info("Generating config file version {}", (Object)4);
        Path parent = FILE.getParent();
        if (!Files.isDirectory(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        try (InputStream stream = PlatformMethods.streamConfigTemplate();){
            template = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
        }
        String data = template.formatted(enable_lightmap_caching, lightmap_time_change_needed_for_update, enable_sky_color_caching, skycolor_time_change_needed_for_update, enable_debug_renderer_disable_if_not_needed, enable_particle_manager_optimization, enable_toast_optimizations, enable_sky_angle_caching_in_worldrenderer, enable_entity_renderer_caching, enable_block_entity_renderer_caching, enable_entity_flag_caching, enable_remove_redundant_fov_calculations, enable_remove_tutorial_if_not_demo, show_f3_text, ignore_mod_compatibilities, log_config, 4);
        Files.writeString(FILE, (CharSequence)data, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
    }
}

