/*
 * Decompiled with CFR 0.152.
 */
package auroras.util;

import auroras.config.Config;
import auroras.util.AHelpers;
import auroras.util.AuroraData;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import org.joml.Matrix4f;

public class AuroraRenderer {
    public ResourceLocation oldDimension;
    public double nlTick;
    public double nlTickHeight;
    public double nlTickWidth;
    public static final double ROTATION_DURATION = 1000.0;
    public double currentAngle = 0.0;
    public double oldAngle = 0.0;
    public double rotationTicks = 0.0;
    public boolean isRotating = false;
    public static final double BRIGHTNESS_MIN_VALUE = 0.0;
    public static final double BRIGHTNESS_MAX_VALUE = 1.0;
    public static final double BRIGHTNESS_DELTA_INCREMENT = 1.0E-4;
    public double currentBrightnessValue = 0.0;
    public double deltaBrightness = 0.0;
    public final RandomSource rand = RandomSource.create((long)54382502529626502L);
    public final RandomSource dateRand = RandomSource.create((long)664292528855626902L);
    public float[] colorRedLayerCurrent;
    public float[] colorGreenLayerCurrent;
    public float[] colorBlueLayerCurrent;
    public float[] colorRedLayerNext;
    public float[] colorGreenLayerNext;
    public float[] colorBlueLayerNext;
    public float colorChangeTimeTop;
    public float colorChangeTimeMid;
    public float colorChangeTimeLower;
    public float colorChangeTickTop;
    public float colorChangeTickMid;
    public float colorChangeTickLower;
    public float timeUntilColorChangeTop;
    public float timeUntilColorChangeMid;
    public float timeUntilColorChangeLower;
    public final AuroraCycle wave0 = new AuroraCycle(this, 0.5f, 0.01f, 0.5f);
    public List<AuroraCycle> waveOscillations = new ArrayList<AuroraCycle>();
    public List<AuroraCycle> glowOscillations = new ArrayList<AuroraCycle>();
    public final AuroraCycle glow0 = new AuroraCycle(this, 20.0f, 0.02f, 0.6f);

    public void render(AuroraData data, Minecraft minecraft, Level level, PoseStack poseStack, Matrix4f matrix, float partialTicks) {
        int visibilityOctaves;
        Biome biome;
        if (minecraft.player == null || level == null || this.colorRedLayerCurrent == null) {
            return;
        }
        if (!data.allowedBiomes.isEmpty() && (biome = (Biome)level.getBiome(minecraft.player.blockPosition()).value()) != null && !data.allowedBiomes.contains(level.registryAccess().registryOrThrow(Registries.BIOME).getKey((Object)biome).toString())) {
            return;
        }
        this.checkBiome(data, minecraft, level);
        float nlBrightness = (data.ignoreStarBrightness ? 1.0f : ((ClientLevel)level).getStarBrightness(partialTicks) * 2.0f) * (float)this.deltaBrightness;
        if (nlBrightness < 0.01f) {
            return;
        }
        double day = AHelpers.getDayOfYear(data, level);
        long year = Mth.floor((double)AHelpers.getYear(data, level));
        double sunActivity = AHelpers.sunStormIntensity(day, year + 1000L, data.auroraAmountOctaves, 0, 5, 1.0);
        RandomSource dayRand = RandomSource.create((long)(Math.round(Math.floor(day)) + year));
        double offset = data.auroraMaxPoleOffset * (sunActivity * dayRand.nextGaussian() / 5.0);
        double sunStormNoise = 1.0;
        int n = visibilityOctaves = (Boolean)Config.STARTUP.globalVisibilityOctavesOverride.get() != false ? (Integer)Config.STARTUP.auroraVisibilityOctaves.get() : data.auroraVisibilityOctaves;
        if (visibilityOctaves > -1) {
            sunStormNoise = AHelpers.sunStormIntensity(day, year, visibilityOctaves, 0, 1, 1.0);
        }
        nlBrightness = (float)((double)nlBrightness * Mth.clamp((double)(Math.abs(this.getNorthernness(data, minecraft, level, 5, offset)) * sunStormNoise), (double)0.0, (double)1.0));
        nlBrightness = (float)((double)nlBrightness * Mth.clamp((double)(this.getNorthernness(data, minecraft, level, 8, offset) * 3.0), (double)0.0, (double)1.0));
        float raininess = level.getRainLevel(partialTicks);
        if (raininess >= 1.0f) {
            return;
        }
        if ((nlBrightness *= 1.0f - raininess) < 0.01f) {
            return;
        }
        int count = (int)Math.round(sunActivity * data.auroraAmountAmplitude);
        if (count >= 1) {
            ProfilerFiller profiler = minecraft.level.getProfiler();
            profiler.push("aurora");
            double northernness = this.getNorthernness(data, minecraft, level, 1, offset);
            float nlAltitudeOffset = 1.0f - (float)Math.abs(northernness * 0.5);
            float nlScale = (float)AHelpers.getDistanceToPole(data, level, offset);
            double nlHeight = ((double)(nlScale * 0.25f) + data.auroraHeightOffset) * (double)nlAltitudeOffset;
            double nlDistance = this.getNorthernnessDistance(data, minecraft, level, 1, nlScale, offset);
            float nlScaleWidth = nlScale * (float)data.auroraWidth;
            float nlScaleHeight = nlScale * (float)data.auroraHeight;
            double posY = (minecraft.player.getY() - 64.0) * data.playerAltitudeFactor;
            poseStack.pushPose();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableCull();
            profiler.push("sheet");
            Matrix4f matrixTranslated = poseStack.last().pose();
            poseStack.translate(0.0, nlHeight * 1.66 - posY, nlDistance * data.auroraDistanceFactor);
            poseStack.mulPose(Axis.YP.rotationDegrees((float)this.getAuroraRotation(data, minecraft, northernness)));
            for (int a = 1; a <= count; ++a) {
                RandomSource bandRand = RandomSource.create((long)((long)a + Math.round(Math.floor(day)) + year));
                this.renderSheet(data, minecraft, minecraft.player, level, poseStack, matrixTranslated, profiler, (float)(0.0 - (double)nlScale), nlBrightness * Mth.clamp((float)Mth.randomBetween((RandomSource)bandRand, (float)0.4f, (float)((float)sunActivity)), (float)0.0f, (float)1.0f), nlScaleWidth * Mth.randomBetween((RandomSource)bandRand, (float)1.0f, (float)((float)sunActivity + 1.0f)) + 1.5f, nlScaleHeight * Mth.randomBetween((RandomSource)bandRand, (float)0.1f, (float)0.5f), Mth.randomBetween((RandomSource)bandRand, (float)0.0f, (float)(1.0f + (float)sunActivity)), partialTicks, day, year, a, sunActivity, offset, bandRand);
            }
            profiler.pop();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            poseStack.popPose();
            profiler.pop();
        }
    }

    public void renderSheet(AuroraData data, Minecraft minecraft, LocalPlayer player, Level level, PoseStack poseStack, Matrix4f matrix, ProfilerFiller profiler, float nlDistance, float nlBrightness, float halfWidth, float halfHeight, float tickExtra, float tick, double gameDay, long year, long band, double sunActivity, double offset, RandomSource random) {
        poseStack.pushPose();
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder builder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        float r1 = this.colorRedLayerCurrent[0];
        float g1 = this.colorRedLayerCurrent[1];
        float b1 = this.colorRedLayerCurrent[2];
        float r2 = this.colorGreenLayerCurrent[0];
        float g2 = this.colorGreenLayerCurrent[1];
        float b2 = this.colorGreenLayerCurrent[2];
        float r3 = this.colorBlueLayerCurrent[0];
        float g3 = this.colorBlueLayerCurrent[1];
        float b3 = this.colorBlueLayerCurrent[2];
        if (this.colorChangeTimeTop > 0.0f) {
            float t1 = this.colorChangeTickTop / this.colorChangeTimeTop;
            t1 = 1.0f - t1;
            r1 = this.colorRedLayerCurrent[0] + (this.colorRedLayerNext[0] - this.colorRedLayerCurrent[0]) * t1;
            g1 = this.colorRedLayerCurrent[1] + (this.colorRedLayerNext[1] - this.colorRedLayerCurrent[1]) * t1;
            b1 = this.colorRedLayerCurrent[2] + (this.colorRedLayerNext[2] - this.colorRedLayerCurrent[2]) * t1;
        }
        if (this.colorChangeTimeMid > 0.0f) {
            float t2 = this.colorChangeTickMid / this.colorChangeTimeMid;
            t2 = 1.0f - t2;
            r2 = this.colorGreenLayerCurrent[0] + (this.colorGreenLayerNext[0] - this.colorGreenLayerCurrent[0]) * t2;
            g2 = this.colorGreenLayerCurrent[1] + (this.colorGreenLayerNext[1] - this.colorGreenLayerCurrent[1]) * t2;
            b2 = this.colorGreenLayerCurrent[2] + (this.colorGreenLayerNext[2] - this.colorGreenLayerCurrent[2]) * t2;
        }
        if (this.colorChangeTimeLower > 0.0f) {
            float t3 = this.colorChangeTickLower / this.colorChangeTimeLower;
            t3 = 1.0f - t3;
            r3 = this.colorBlueLayerCurrent[0] + (this.colorBlueLayerNext[0] - this.colorBlueLayerCurrent[0]) * t3;
            g3 = this.colorBlueLayerCurrent[1] + (this.colorBlueLayerNext[1] - this.colorBlueLayerCurrent[1]) * t3;
            b3 = this.colorBlueLayerCurrent[2] + (this.colorBlueLayerNext[2] - this.colorBlueLayerCurrent[2]) * t3;
        }
        float a1 = 0.6f;
        float a2 = 0.9f;
        float a3 = 0.1f;
        a1 *= nlBrightness;
        a2 *= nlBrightness;
        a3 *= nlBrightness;
        float fullTick = (float)this.nlTick + tick + tickExtra;
        profiler.push("vertexLoop");
        int detail = (Boolean)Config.STARTUP.globalDetailOverride.get() != false ? (Integer)Config.STARTUP.auroraDetail.get() : data.auroraDetail;
        int strips = (int)(minecraft.getInstance().options.graphicsMode().get() == GraphicsStatus.FAST ? (double)detail * 0.25 : (double)detail);
        if (strips == 0) {
            return;
        }
        float height = halfHeight;
        float greenIntensity = 1.0f;
        float redIntensity = 1.0f;
        float blueIntensity = 1.0f;
        float extraBottom = height * (float)data.blueLayerFactorExtra;
        float yBlue = height * (float)data.blueLayerFactor;
        float yGreen = height * (float)data.greenLayerFactor + yBlue;
        float yRed = height * (float)data.redLayerFactor + yGreen;
        float extraTop = height * (float)data.redLayerFactorExtra + yRed;
        float a1_here = a1;
        float a2_here = a2;
        float a3_here = a3;
        double latitudinalFactor = 1.0 - Math.abs(this.getLatitudinalTilt(data, minecraft.getInstance(), level, 1, 1.0f, offset) / 90.0);
        double freqFactor = Math.abs(this.getNorthernnessDistance(data, minecraft, level, 2, 1.0f, offset));
        double zWrapFactor = 1.0 - Math.abs(this.getNorthernnessDistance(data, minecraft, level, 8, 1.0f, offset));
        double xWrapFactor = Math.pow(zWrapFactor, 1.5);
        double xWrapInverse = 1.0 - xWrapFactor;
        double extraDistance = data.auroraBandDistanceFactor * (double)(band - 1L);
        double posX = -(player.getX() * data.playerMovementFactor);
        double radiusX = -data.auroraWidthRadius;
        double radiusZ = -data.auroraLengthRadius;
        float fadeEdge = 0.5f - 0.4f * (float)zWrapFactor;
        for (int l = 0; l <= strips; ++l) {
            float randomFade;
            float fadePos;
            float t0 = (float)l / (float)strips;
            float t1 = (float)(l + 1) / (float)strips;
            float extraRedAltitude0 = (float)AHelpers.sunStormIntensity(this.nlTickHeight + ((double)t0 - posX) * data.auroraHeightFrequency, year + band + 2L, data.auroraHeightOctaves, 0, 1, data.auroraHeightAmplitudeTop);
            float extraGreenAltitude0 = (float)AHelpers.sunStormIntensity(this.nlTickHeight + ((double)t0 - posX) * data.auroraHeightFrequency, year + band + 1L, data.auroraHeightOctaves, 0, 1, data.auroraHeightAmplitudeMid);
            float extraBlueAltitude0 = (float)AHelpers.sunStormIntensity(this.nlTickHeight + ((double)t0 - posX) * data.auroraHeightFrequency, year + band, data.auroraHeightOctaves, 0, 1, data.auroraHeightAmplitudeLower);
            float extraRedAltitude1 = extraRedAltitude0;
            float extraGreenAltitude1 = extraGreenAltitude0;
            float extraBlueAltitude1 = extraBlueAltitude0;
            if (!data.pixelStyle) {
                extraRedAltitude1 = (float)AHelpers.sunStormIntensity(this.nlTickHeight + ((double)t1 - posX) * data.auroraHeightFrequency, year + band + 2L, data.auroraHeightOctaves, 0, 1, data.auroraHeightAmplitudeTop);
                extraGreenAltitude1 = (float)AHelpers.sunStormIntensity(this.nlTickHeight + ((double)t1 - posX) * data.auroraHeightFrequency, year + band + 1L, data.auroraHeightOctaves, 0, 1, data.auroraHeightAmplitudeMid);
                extraBlueAltitude1 = (float)AHelpers.sunStormIntensity(this.nlTickHeight + ((double)t1 - posX) * data.auroraHeightFrequency, year + band, data.auroraHeightOctaves, 0, 1, data.auroraHeightAmplitudeLower);
            }
            if ((fadePos = Math.min(t0, 1.0f - t0)) < fadeEdge) {
                randomFade = fadePos / fadeEdge;
                a1_here = a1 * randomFade;
                a2_here = a2 * randomFade;
                a3_here = a3 * randomFade;
            } else {
                a1_here = a1;
                a2_here = a2;
                a3_here = a3;
            }
            randomFade = 0.5f + this.glowEquation(t0, fullTick, tick) * 0.5f;
            a1_here *= randomFade * greenIntensity;
            a2_here *= randomFade * redIntensity;
            a3_here *= randomFade * blueIntensity;
            double auroraWaveFrequency = data.auroraWaveFrequency * (1.0 + 5.0 * freqFactor);
            double auroraWaveAmplitude = data.auroraWaveAmplitude * latitudinalFactor;
            double extraWaveDisplacement0 = AHelpers.sunStormIntensity(this.nlTickWidth + ((double)t0 - posX) * auroraWaveFrequency, year + 10L + band, data.auroraWaveOctaves, 0, 1, auroraWaveAmplitude);
            double extraWaveDisplacement1 = AHelpers.sunStormIntensity(this.nlTickWidth + ((double)t1 - posX) * auroraWaveFrequency, year + 10L + band, data.auroraWaveOctaves, 0, 1, auroraWaveAmplitude);
            double angle0 = Math.PI * 2 * (double)t0 * data.auroraFrequency;
            double angle1 = Math.PI * 2 * (double)t1 * data.auroraFrequency;
            double angleX0 = Math.sin(angle0);
            double angleX1 = Math.sin(angle1);
            double angleZ0 = Math.cos(angle0);
            double angleZ1 = Math.cos(angle1);
            double ampX0 = angleX0 * extraWaveDisplacement0 - angleX0 * extraDistance;
            double ampX1 = angleX1 * extraWaveDisplacement1 - angleX1 * extraDistance;
            double ampZ0 = angleZ0 * extraWaveDisplacement0 - angleZ0 * extraDistance;
            double ampZ1 = angleZ1 * extraWaveDisplacement1 - angleZ1 * extraDistance;
            double x0Flat = (double)(-halfWidth) + (double)halfWidth * 2.0 * (double)t0;
            double x1Flat = x0Flat + (double)halfWidth * 2.0 / (double)strips;
            x0Flat += extraDistance;
            x1Flat += extraDistance;
            double x0Round = (double)(-nlDistance) * 0.5 * angleX0 * radiusX * xWrapFactor + ampX0;
            double x1Round = (double)(-nlDistance) * 0.5 * angleX1 * radiusX * xWrapFactor + ampX1;
            double z0Round = (double)(-nlDistance) * 0.5 * angleZ0 * radiusZ * zWrapFactor + ampZ0;
            double z1Round = (double)(-nlDistance) * 0.5 * angleZ1 * radiusZ * zWrapFactor + ampZ1;
            float x0 = (float)(x0Round + x0Flat * xWrapInverse);
            float x1 = (float)(x1Round + x1Flat * xWrapInverse);
            float z0 = (float)z0Round;
            float z1 = (float)z1Round;
            builder.addVertex(matrix, x0, yBlue - extraBottom - extraBlueAltitude0, z0).setColor(r3, g3, b3, 0.0f);
            builder.addVertex(matrix, x1, yBlue - extraBottom - extraBlueAltitude1, z1).setColor(r3, g3, b3, 0.0f);
            builder.addVertex(matrix, x1, yBlue + extraBlueAltitude1, z1).setColor(r3, g3, b3, a3_here);
            builder.addVertex(matrix, x0, yBlue + extraBlueAltitude0, z0).setColor(r3, g3, b3, a3_here);
            builder.addVertex(matrix, x0, yBlue + extraBlueAltitude0, z0).setColor(r3, g3, b3, a3_here);
            builder.addVertex(matrix, x1, yBlue + extraBlueAltitude1, z1).setColor(r3, g3, b3, a3_here);
            builder.addVertex(matrix, x1, yGreen + extraBlueAltitude1 + extraGreenAltitude1, z1).setColor(r2, g2, b2, a2_here);
            builder.addVertex(matrix, x0, yGreen + extraBlueAltitude0 + extraGreenAltitude0, z0).setColor(r2, g2, b2, a2_here);
            builder.addVertex(matrix, x0, yGreen + extraBlueAltitude0 + extraGreenAltitude0, z0).setColor(r2, g2, b2, a2_here);
            builder.addVertex(matrix, x1, yGreen + extraBlueAltitude1 + extraGreenAltitude1, z1).setColor(r2, g2, b2, a2_here);
            builder.addVertex(matrix, x1, yRed + extraBlueAltitude1 + extraGreenAltitude1, z1).setColor(r1, g1, b1, a1_here);
            builder.addVertex(matrix, x0, yRed + extraBlueAltitude0 + extraGreenAltitude0, z0).setColor(r1, g1, b1, a1_here);
            builder.addVertex(matrix, x0, yRed + extraBlueAltitude0 + extraGreenAltitude0, z0).setColor(r1, g1, b1, a1_here);
            builder.addVertex(matrix, x1, yRed + extraBlueAltitude1 + extraGreenAltitude1, z1).setColor(r1, g1, b1, a1_here);
            builder.addVertex(matrix, x1, yRed + extraTop + extraBlueAltitude1 + extraGreenAltitude1 + extraRedAltitude1, z1).setColor(r1, g1, b1, 0.0f);
            builder.addVertex(matrix, x0, yRed + extraTop + extraBlueAltitude0 + extraGreenAltitude0 + extraRedAltitude0, z0).setColor(r1, g1, b1, 0.0f);
            if (minecraft.isPaused()) continue;
            this.nlTickHeight += data.auroraHeightSpeed;
            this.nlTickWidth += data.auroraWaveSpeed;
        }
        profiler.pop();
        profiler.push("draw");
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        profiler.pop();
        poseStack.popPose();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkBiome(AuroraData data, Minecraft minecraft, Level level) {
        if (!data.allowedBiomes.isEmpty()) {
            Biome biome = (Biome)level.getBiome(minecraft.player.blockPosition()).value();
            if (biome == null) return;
            boolean validBiome = data.allowedBiomes.contains(level.registryAccess().registryOrThrow(Registries.BIOME).getKey((Object)biome).toString());
            if (validBiome && this.deltaBrightness < 1.0) {
                this.deltaBrightness = Math.min(1.0, this.deltaBrightness + 1.0E-4);
                return;
            } else {
                if (validBiome) return;
                if (!(this.deltaBrightness > 0.0)) return;
                this.deltaBrightness = Math.max(0.0, this.deltaBrightness - 1.0E-4);
            }
            return;
        } else {
            if (!data.allowedBiomes.isEmpty() || !(this.deltaBrightness < 1.0)) return;
            this.deltaBrightness = Math.min(1.0, this.deltaBrightness + 1.0E-4);
        }
    }

    public double getAuroraRotation(AuroraData data, Minecraft minecraft, double northernness) {
        boolean hasCrossedPole;
        this.oldAngle = this.currentAngle;
        boolean bl = hasCrossedPole = !(northernness < 0.0 && this.currentAngle >= 180.0 || northernness >= 0.0 && this.currentAngle <= 0.0);
        if (!this.isRotating && hasCrossedPole) {
            this.isRotating = true;
            this.rotationTicks = 0.0;
        }
        if (this.isRotating && !minecraft.isPaused()) {
            this.rotationTicks += data.auroraRotationSpeed;
            double t = this.rotationTicks / 1000.0;
            double d = this.currentAngle = northernness < 0.0 ? Mth.lerp((double)t, (double)this.oldAngle, (double)180.0) : Mth.lerp((double)t, (double)this.oldAngle, (double)0.0);
            if (this.rotationTicks >= 1000.0) {
                this.isRotating = false;
                this.rotationTicks = 0.0;
            }
        }
        if (hasCrossedPole) {
            this.rotationTicks = 0.0;
        }
        return this.currentAngle;
    }

    public double getLatitudinalTilt(AuroraData data, Minecraft minecraft, Level level, int power, float nlScale, double offset) {
        return this.getNorthernnessDistance(data, minecraft, level, power, nlScale, offset) * 90.0;
    }

    public double getNorthernnessDistance(AuroraData data, Minecraft minecraft, Level level, int power, float nlScale, double offset) {
        double northernness = this.getNorthernness(data, minecraft, level, power, offset);
        if (northernness < 0.0) {
            return (1.0 + northernness) * (double)nlScale;
        }
        return 0.0 - (1.0 - northernness) * (double)nlScale;
    }

    public double getNorthernness(AuroraData data, Minecraft minecraft, Level level, int power, double offset) {
        if (data.aboveHeadPosition) {
            return 1.0;
        }
        if (AHelpers.getEndlessPoles(data, level)) {
            double z = minecraft.player.getZ();
            double equator = AHelpers.getEquator(data, level);
            double blocks90 = AHelpers.getDistanceToPole(data, level, offset);
            double northPole = equator - blocks90;
            double southPole = equator + blocks90;
            if (z <= northPole) {
                return 1.0;
            }
            if (z >= southPole) {
                return -1.0;
            }
        }
        return Math.pow(0.0 - (AHelpers.angleFromPole(data, level, minecraft, offset) - 90.0) / 90.0, power);
    }

    public void update(Entity viewer, AuroraData data) {
        AuroraCycle cycle;
        float amp;
        float speed;
        Level level = viewer.level();
        if (this.oldDimension != level.dimension().location()) {
            this.timeUntilColorChangeTop = 0.0f;
            this.timeUntilColorChangeMid = 0.0f;
            this.timeUntilColorChangeLower = 0.0f;
            this.oldDimension = level.dimension().location();
        }
        this.nlTick += data.auroraColorUpdateSpeed;
        this.nlTickHeight += data.auroraHeightSpeed;
        this.nlTickWidth += data.auroraWaveSpeed;
        if (this.colorRedLayerCurrent == null) {
            Color[] cs = this.generateColorSet(data, level);
            this.colorRedLayerCurrent = cs[0].getColorComponents(null);
            this.colorGreenLayerCurrent = cs[1].getColorComponents(null);
            this.colorBlueLayerCurrent = cs[2].getColorComponents(null);
        }
        this.cycleColors(data, level);
        if (this.rand.nextInt(50) == 0) {
            float freq = Mth.nextFloat((RandomSource)this.rand, (float)8.0f, (float)100.0f);
            speed = freq * 1.0E-5f - 4.0f;
            amp = Mth.nextFloat((RandomSource)this.rand, (float)0.05f, (float)0.3f);
            cycle = new AuroraCycle(this, freq, speed, amp);
            cycle.age = cycle.maxAge = Mth.nextInt((RandomSource)this.rand, (int)100, (int)400);
            this.waveOscillations.add(cycle);
        }
        if (!this.waveOscillations.isEmpty()) {
            HashSet<AuroraCycle> removes = new HashSet<AuroraCycle>();
            for (AuroraCycle c : this.waveOscillations) {
                c.update();
                if (c.age > 0) continue;
                removes.add(c);
            }
            this.waveOscillations.removeAll(removes);
        }
        if (this.rand.nextInt(120) == 0) {
            float freq = Mth.nextFloat((RandomSource)this.rand, (float)30.0f, (float)150.0f);
            speed = freq * 0.002f;
            amp = Mth.nextFloat((RandomSource)this.rand, (float)0.05f, (float)0.5f);
            cycle = new AuroraCycle(this, freq, speed, amp);
            cycle.age = cycle.maxAge = Mth.nextInt((RandomSource)this.rand, (int)100, (int)400);
            this.glowOscillations.add(cycle);
        }
        if (this.rand.nextInt(300) == 0) {
            float freq = Mth.nextFloat((RandomSource)this.rand, (float)400.0f, (float)500.0f);
            speed = freq * 0.004f;
            amp = Mth.nextFloat((RandomSource)this.rand, (float)0.1f, (float)0.2f);
            cycle = new AuroraCycle(this, freq, speed, amp);
            cycle.age = cycle.maxAge = Mth.nextInt((RandomSource)this.rand, (int)100, (int)200);
            this.glowOscillations.add(cycle);
        }
        if (!this.glowOscillations.isEmpty()) {
            HashSet<AuroraCycle> removes = new HashSet<AuroraCycle>();
            for (AuroraCycle c : this.glowOscillations) {
                c.update();
                if (c.age > 0) continue;
                removes.add(c);
            }
            this.glowOscillations.removeAll(removes);
        }
    }

    public Color[] generateColorSet(AuroraData data, Level level) {
        int visibilityOctaves;
        double day = AHelpers.getDayOfYear(data, level);
        long year = Mth.floor((double)AHelpers.getYear(data, level));
        double sunActivity = AHelpers.sunStormIntensity(day, year + 1000L, data.auroraAmountOctaves, 0, 5, 1.0);
        RandomSource dayRand = RandomSource.create((long)(Math.round(Math.floor(day)) + year));
        double offset = data.auroraMaxPoleOffset * (sunActivity * dayRand.nextGaussian() / 5.0);
        float greenIntensity = 1.0f;
        float redIntensity = 0.9f;
        float blueIntensity = 0.8f;
        int n = visibilityOctaves = (Boolean)Config.STARTUP.globalVisibilityOctavesOverride.get() != false ? (Integer)Config.STARTUP.auroraVisibilityOctaves.get() : data.auroraVisibilityOctaves;
        if (visibilityOctaves > -1) {
            float latitudinalFactor = (float)Math.abs(this.getNorthernnessDistance(data, Minecraft.getInstance(), level, 1, 1.0f, offset)) * 2.0f;
            greenIntensity = (float)Mth.clamp((double)(AHelpers.sunStormIntensity(day, year - 4L, data.topColorOctaves, 1, 10, 0.1) * (double)latitudinalFactor), (double)0.2f, (double)1.0);
            redIntensity = (float)Mth.clamp((double)(AHelpers.sunStormIntensity(day, year - 2L, data.midColorOctaves, 1, 10, 0.1) * (double)latitudinalFactor * (double)greenIntensity), (double)0.15f, (double)1.0);
            blueIntensity = (float)Mth.clamp((double)(AHelpers.sunStormIntensity(day, year - 8L, data.lowerColorOctaves, 1, 10, 0.1) * (double)latitudinalFactor * (double)redIntensity), (double)0.1f, (double)1.0);
        }
        float h1 = Mth.nextFloat((RandomSource)this.rand, (float)((float)data.topColorHSBMin), (float)((float)data.topColorHSBMax));
        float h2 = Mth.nextFloat((RandomSource)this.rand, (float)((float)data.midColorHSBMin), (float)((float)data.midColorHSBMax));
        float h3 = Mth.nextFloat((RandomSource)this.rand, (float)((float)data.lowerColorHSBMin), (float)((float)data.lowerColorHSBMax));
        Color redLayer = new Color(Color.HSBtoRGB(h1, 1.0f * redIntensity, 1.0f * Mth.clamp((float)redIntensity, (float)0.1f, (float)1.0f)));
        Color greenLayer = new Color(Color.HSBtoRGB(h2, 1.0f * greenIntensity, 1.0f * Mth.clamp((float)greenIntensity, (float)0.1f, (float)1.0f)));
        Color purpleLayer = new Color(Color.HSBtoRGB(h3, 1.0f * blueIntensity, 1.0f * Mth.clamp((float)blueIntensity, (float)0.1f, (float)1.0f)));
        return new Color[]{redLayer, greenLayer, purpleLayer};
    }

    public void cycleColors(AuroraData data, Level level) {
        Color[] cs;
        if (this.timeUntilColorChangeTop > 0.0f) {
            this.timeUntilColorChangeTop -= 0.1f;
        } else if (this.rand.nextInt(1200) == 0) {
            cs = this.generateColorSet(data, level);
            this.colorRedLayerNext = cs[0].getColorComponents(null);
            this.colorChangeTickTop = this.colorChangeTimeTop = Mth.nextFloat((RandomSource)this.rand, (float)100.0f, (float)200.0f);
        }
        if (this.colorChangeTickTop > 0.0f) {
            this.colorChangeTickTop -= 0.1f;
            float delta = 1.0f - this.colorChangeTickTop / this.colorChangeTimeTop;
            this.colorRedLayerCurrent = AHelpers.lerpSine(delta, this.colorRedLayerCurrent, this.colorRedLayerNext);
            if (this.colorChangeTickTop <= 0.0f) {
                this.colorChangeTimeTop = 0.0f;
                this.colorRedLayerCurrent = this.colorRedLayerNext;
                this.colorRedLayerNext = null;
                this.timeUntilColorChangeTop = Mth.nextInt((RandomSource)this.rand, (int)data.topColorCycle, (int)(data.topColorCycle * 2));
            }
        }
        if (this.timeUntilColorChangeMid > 0.0f) {
            this.timeUntilColorChangeMid -= 0.1f;
        } else if (this.rand.nextInt(1200) == 0) {
            cs = this.generateColorSet(data, level);
            this.colorGreenLayerNext = cs[1].getColorComponents(null);
            this.colorChangeTickMid = this.colorChangeTimeMid = Mth.nextFloat((RandomSource)this.rand, (float)100.0f, (float)200.0f);
        }
        if (this.colorChangeTickMid > 0.0f) {
            this.colorChangeTickMid -= 0.1f;
            float delta = 1.0f - this.colorChangeTickMid / this.colorChangeTimeMid;
            this.colorGreenLayerCurrent = AHelpers.lerpSine(delta, this.colorGreenLayerCurrent, this.colorGreenLayerNext);
            if (this.colorChangeTickMid <= 0.0f) {
                this.colorChangeTimeMid = 0.0f;
                this.colorGreenLayerCurrent = this.colorGreenLayerNext;
                this.colorGreenLayerNext = null;
                this.timeUntilColorChangeMid = Mth.nextInt((RandomSource)this.rand, (int)data.topColorCycle, (int)(data.topColorCycle * 2));
            }
        }
        if (this.timeUntilColorChangeLower > 0.0f) {
            this.timeUntilColorChangeLower -= 0.1f;
        } else if (this.rand.nextInt(1200) == 0) {
            Color[] cs2 = this.generateColorSet(data, level);
            this.colorBlueLayerNext = cs2[2].getColorComponents(null);
            this.colorChangeTickLower = this.colorChangeTimeLower = Mth.nextFloat((RandomSource)this.rand, (float)100.0f, (float)200.0f);
        }
        if (this.colorChangeTickLower > 0.0f) {
            this.colorChangeTickLower -= 0.1f;
            float delta = 1.0f - this.colorChangeTickLower / this.colorChangeTimeLower;
            this.colorBlueLayerCurrent = AHelpers.lerpSine(delta, this.colorBlueLayerCurrent, this.colorBlueLayerNext);
            if (this.colorChangeTickLower <= 0.0f) {
                this.colorChangeTimeLower = 0.0f;
                this.colorBlueLayerCurrent = this.colorBlueLayerNext;
                this.colorBlueLayerNext = null;
                this.timeUntilColorChangeLower = Mth.nextInt((RandomSource)this.rand, (int)data.topColorCycle, (int)(data.topColorCycle * 2));
            }
        }
    }

    public float waveEquation(Level level, float t, float tick, float renderTick) {
        float f = 0.0f;
        f = (float)((double)f + this.wave0.calc(t, tick));
        for (AuroraCycle c : this.waveOscillations) {
            f = (float)((double)f + c.calc(t, tick));
        }
        return f;
    }

    public float glowEquation(float t, float tick, float renderTick) {
        float f = 0.0f;
        f = (float)((double)f + this.glow0.calc(t, tick));
        for (AuroraCycle c : this.glowOscillations) {
            f = (float)((double)f + c.calc(t, tick));
        }
        return f;
    }

    public class AuroraCycle {
        public final float freq;
        public final float tickMultiplier;
        public final float amp;
        public int age;
        public int maxAge = -1;
        public float ampModifier = 1.0f;

        public AuroraCycle(AuroraRenderer this$0, float f, float t, float a) {
            this.freq = f;
            this.tickMultiplier = t;
            this.amp = a;
        }

        public double calc(float t, float tick) {
            return Math.cos(t * this.freq + tick * this.tickMultiplier) * (double)this.amp * (double)this.ampModifier;
        }

        public void update() {
            if (this.age >= 0) {
                --this.age;
                float a = (this.maxAge - this.age) / this.maxAge;
                this.ampModifier = Math.min(a, 1.0f - a);
            }
        }
    }
}

