/*
 * Decompiled with CFR 0.152.
 */
package fuzs.arcanelanterns.integration.jei;

import fuzs.arcanelanterns.ArcaneLanterns;
import fuzs.arcanelanterns.init.ModRegistry;
import fuzs.arcanelanterns.integration.jei.ArcaneLanternsPlugin;
import fuzs.arcanelanterns.world.item.crafting.LanternMakingRecipe;
import fuzs.puzzleslib.api.core.v1.Proxy;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;

public class LanternMakingRecipeCategory
implements IRecipeCategory<LanternMakingRecipe> {
    public static final ResourceLocation BACKGROUND_LOCATION = ArcaneLanterns.id("textures/gui/lantern_making_background.png");
    public static final Component LANTERN_MAKING_COMPONENT = Component.translatable((String)Util.makeDescriptionId((String)"recipe_type", (ResourceLocation)ModRegistry.LANTERN_MAKING_RECIPE_TYPE.key().location()));
    private final Component title = LANTERN_MAKING_COMPONENT;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slotDrawable;
    private final ItemStack lanternMakerStack;
    private final List<ItemStack> lanternStacks;

    public LanternMakingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(BACKGROUND_LOCATION, 0, 0, 161, 86);
        this.lanternMakerStack = new ItemStack((ItemLike)ModRegistry.LANTERN_MAKER_BLOCK.value());
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)this.lanternMakerStack);
        this.slotDrawable = guiHelper.getSlotDrawable();
        this.lanternStacks = List.of(new ItemStack((ItemLike)Items.LANTERN), new ItemStack((ItemLike)Items.SOUL_LANTERN));
    }

    @NotNull
    public RecipeType<LanternMakingRecipe> getRecipeType() {
        return ArcaneLanternsPlugin.LANTERN_MAKING_RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return this.title;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull LanternMakingRecipe recipe, @NotNull IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 42, 35).addItemStack(this.lanternMakerStack);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 131, 14).addItemStacks(this.lanternStacks)).setBackground(this.slotDrawable, -1, -1);
        double angleBetweenEach = 360.0 / (double)recipe.getIngredients().size();
        Vec2 point = new Vec2(42.0f, 3.0f);
        Vec2 center = new Vec2(42.0f, 35.0f);
        for (Ingredient ingredient : recipe.getIngredients()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, (int)point.x, (int)point.y).addIngredients(ingredient)).setBackground(this.slotDrawable, -1, -1);
            point = LanternMakingRecipeCategory.rotatePointAbout(point, center, angleBetweenEach);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 131, 56).addItemStack(recipe.getResultItem((HolderLookup.Provider)Proxy.INSTANCE.getClientLevel().registryAccess()));
    }

    public static Vec2 rotatePointAbout(Vec2 in, Vec2 about, double degrees) {
        double rad = degrees * Math.PI / 180.0;
        double newX = Math.cos(rad) * (double)(in.x - about.x) - Math.sin(rad) * (double)(in.y - about.y) + (double)about.x;
        double newY = Math.sin(rad) * (double)(in.x - about.x) + Math.cos(rad) * (double)(in.y - about.y) + (double)about.y;
        return new Vec2((float)newX, (float)newY);
    }
}

