/*
 * Decompiled with CFR 0.152.
 */
package net.arphex.procedures;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.arphex.entity.AscendSphereAnimEntity;
import net.arphex.entity.SphereAnimEntity;
import net.arphex.entity.TormentorMothSummonEntity;
import net.arphex.entity.TormentorScorpioidSummonEntity;
import net.arphex.entity.TormentorVoidlasherSummonEntity;
import net.arphex.init.ArphexModItems;
import net.arphex.init.ArphexModMobEffects;
import net.arphex.network.ArphexModVariables;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

@EventBusSubscriber(value={Dist.CLIENT})
public class RenderTest6Procedure {
    private static BufferBuilder bufferBuilder = null;
    private static VertexBuffer vertexBuffer = null;
    private static VertexFormat.Mode mode = null;
    private static VertexFormat format = null;
    private static PoseStack poseStack = null;
    private static Matrix4f modelViewMatrix = null;
    private static Matrix4f projectionMatrix = null;
    private static boolean worldCoordinate = true;
    private static Vec3 offset = Vec3.ZERO;
    private static int currentStage = 0;
    private static int targetStage = 0;

    private static void add(float x, float y, float z, int color) {
        RenderTest6Procedure.add(x, y, z, 0.0f, 0.0f, color);
    }

    private static void add(float x, float y, float z, float u, float v, int color) {
        if (bufferBuilder == null) {
            return;
        }
        if (format == DefaultVertexFormat.POSITION_COLOR) {
            bufferBuilder.addVertex(x, y, z).setColor(color);
        } else if (format == DefaultVertexFormat.POSITION_TEX_COLOR) {
            bufferBuilder.addVertex(x, y, z).setUv(u, v).setColor(color);
        }
    }

    private static boolean begin(VertexFormat.Mode mode, VertexFormat format, boolean update) {
        if (bufferBuilder == null) {
            if (update) {
                RenderTest6Procedure.clear();
            }
            if (vertexBuffer == null) {
                if (format == DefaultVertexFormat.POSITION_COLOR) {
                    RenderTest6Procedure.mode = mode;
                    RenderTest6Procedure.format = format;
                    bufferBuilder = Tesselator.getInstance().begin(mode, DefaultVertexFormat.POSITION_COLOR);
                    return true;
                }
                if (format == DefaultVertexFormat.POSITION_TEX_COLOR) {
                    RenderTest6Procedure.mode = mode;
                    RenderTest6Procedure.format = format;
                    bufferBuilder = Tesselator.getInstance().begin(mode, DefaultVertexFormat.POSITION_TEX_COLOR);
                    return true;
                }
            }
        }
        return false;
    }

    private static void clear() {
        if (vertexBuffer != null) {
            vertexBuffer.close();
            vertexBuffer = null;
        }
    }

    private static void end() {
        MeshData meshData;
        if (bufferBuilder == null) {
            return;
        }
        if (vertexBuffer != null) {
            vertexBuffer.close();
        }
        if ((meshData = bufferBuilder.build()) == null) {
            vertexBuffer = null;
            bufferBuilder = null;
        } else {
            vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
            vertexBuffer.bind();
            vertexBuffer.upload(meshData);
            VertexBuffer.unbind();
            bufferBuilder = null;
        }
    }

    private static void offset(double x, double y, double z) {
        offset = new Vec3(x, y, z);
    }

    private static void release() {
        targetStage = 0;
    }

    private static VertexBuffer shape() {
        return vertexBuffer;
    }

    private static void system(boolean worldCoordinate) {
        RenderTest6Procedure.worldCoordinate = worldCoordinate;
    }

    private static boolean target(int targetStage) {
        if (targetStage == currentStage) {
            RenderTest6Procedure.targetStage = targetStage;
            return true;
        }
        return false;
    }

    private static void renderShape(VertexBuffer vertexBuffer, double x, double y, double z, float yaw, float pitch, float roll, float xScale, float yScale, float zScale, int color) {
        float k;
        float j;
        float i;
        if (currentStage == 0 || currentStage != targetStage) {
            return;
        }
        if (poseStack == null || projectionMatrix == null) {
            return;
        }
        if (vertexBuffer == null) {
            return;
        }
        if (worldCoordinate) {
            Vec3 pos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
            i = (float)(x - pos.x());
            j = (float)(y - pos.y());
            k = (float)(z - pos.z());
        } else {
            i = (float)x;
            j = (float)y;
            k = (float)z;
        }
        poseStack.pushPose();
        poseStack.mulPose(modelViewMatrix);
        poseStack.translate(i, j, k);
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        poseStack.scale(xScale, yScale, zScale);
        poseStack.translate(offset.x(), offset.y(), offset.z());
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
        vertexBuffer.bind();
        vertexBuffer.drawWithShader(poseStack.last().pose(), projectionMatrix, vertexBuffer.getFormat().hasUV(0) ? GameRenderer.getPositionTexColorShader() : GameRenderer.getPositionColorShader());
        VertexBuffer.unbind();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void renderLevel(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            currentStage = 1;
            poseStack = new PoseStack();
            RenderSystem.depthMask((boolean)false);
            RenderTest6Procedure.renderShapes(event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            currentStage = 0;
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            currentStage = 2;
            poseStack = event.getPoseStack();
            RenderSystem.depthMask((boolean)true);
            RenderTest6Procedure.renderShapes(event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            currentStage = 0;
        }
    }

    private static void renderShapes(RenderLevelStageEvent event) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        Entity entity = minecraft.gameRenderer.getMainCamera().getEntity();
        if (level != null && entity != null) {
            modelViewMatrix = event.getModelViewMatrix();
            projectionMatrix = event.getProjectionMatrix();
            Vec3 pos = entity.getPosition(event.getPartialTick().getGameTimeDeltaPartialTick(false));
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderTest6Procedure.execute((Event)event, (LevelAccessor)level, pos.x(), pos.y(), pos.z(), entity);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
        }
    }

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        RenderTest6Procedure.execute(null, world, x, y, z, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, Entity entity) {
        LivingEntity _livEnt;
        if (entity == null) {
            return;
        }
        double i = 0.0;
        double j = 0.0;
        double k = 0.0;
        double l = 0.0;
        double spheresize = 0.0;
        double col_r = 0.0;
        double col_g = 0.0;
        double col_b = 0.0;
        double tormentor_distance = 0.0;
        double pitch_variance = 0.0;
        double distance_scaling_factor = 0.0;
        double yaw_variance = 0.0;
        double rotation_from_tormentor = 0.0;
        double opacity = 0.0;
        double distance = 0.0;
        double amplify = 0.0;
        if (ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_health > 0.0 || ((ArphexModVariables.PlayerVariables)entity.getData(ArphexModVariables.PLAYER_VARIABLES)).sphere_near > 0.0 || (entity instanceof LivingEntity && (_livEnt = (LivingEntity)entity).hasEffect(ArphexModMobEffects.ETERNAL_EVASION) ? _livEnt.getEffect(ArphexModMobEffects.ETERNAL_EVASION).getAmplifier() : 0) == 9) {
            LivingEntity _livEnt2;
            RenderTest6Procedure.system(true);
            if (RenderTest6Procedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR, true)) {
                for (int index0 = 0; index0 < 90; ++index0) {
                    for (int index1 = 0; index1 < 45; ++index1) {
                        k = 255.0 - j / 180.0 * 95.0;
                        l = 255.0 - (j + 4.0) / 180.0 * 95.0;
                        RenderTest6Procedure.add((float)(Math.sin(Math.toRadians(i)) * Math.sin(Math.toRadians(j)) * 0.5), (float)(Math.cos(Math.toRadians(j)) * 0.5), (float)(Math.cos(Math.toRadians(i)) * Math.sin(Math.toRadians(j)) * 0.5), 0xFF000000 | (int)k << 16 | (int)k << 8 | (int)k);
                        RenderTest6Procedure.add((float)(Math.sin(Math.toRadians(i)) * Math.sin(Math.toRadians(j + 4.0)) * 0.5), (float)(Math.cos(Math.toRadians(j + 4.0)) * 0.5), (float)(Math.cos(Math.toRadians(i)) * Math.sin(Math.toRadians(j + 4.0)) * 0.5), 0xFF000000 | (int)l << 16 | (int)l << 8 | (int)l);
                        RenderTest6Procedure.add((float)(Math.sin(Math.toRadians(i + 4.0)) * Math.sin(Math.toRadians(j + 4.0)) * 0.5), (float)(Math.cos(Math.toRadians(j + 4.0)) * 0.5), (float)(Math.cos(Math.toRadians(i + 4.0)) * Math.sin(Math.toRadians(j + 4.0)) * 0.5), 0xFF000000 | (int)l << 16 | (int)l << 8 | (int)l);
                        RenderTest6Procedure.add((float)(Math.sin(Math.toRadians(i + 4.0)) * Math.sin(Math.toRadians(j)) * 0.5), (float)(Math.cos(Math.toRadians(j)) * 0.5), (float)(Math.cos(Math.toRadians(i + 4.0)) * Math.sin(Math.toRadians(j)) * 0.5), 0xFF000000 | (int)k << 16 | (int)k << 8 | (int)k);
                        j += 4.0;
                    }
                    j = 0.0;
                    i += 4.0;
                }
                i = 0.0;
                RenderTest6Procedure.end();
            }
            if (ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_health > 0.0 && !(((ArphexModVariables.PlayerVariables)entity.getData(ArphexModVariables.PLAYER_VARIABLES)).tormentor_render > 0.0)) {
                tormentor_distance = Math.sqrt((entity.getX() - ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_x) * (entity.getX() - ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_x) + (entity.getY() + 1.0 - (ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_y + 4.0)) * (entity.getY() + 1.0 - (ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_y + 4.0)) + (entity.getZ() - ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_z) * (entity.getZ() - ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_z));
                RenderSystem.disableDepthTest();
                RenderSystem.depthMask((boolean)false);
                if (tormentor_distance < 1000.0 && RenderTest6Procedure.target(2)) {
                    Vec3 _center = new Vec3(x, y, z);
                    List<Entity> _entfound = world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(125.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList();
                    for (Entity entityiterator : _entfound) {
                        if (entityiterator instanceof TormentorMothSummonEntity) {
                            RenderTest6Procedure.renderShape(RenderTest6Procedure.shape(), entityiterator.getX(), entityiterator.getY() + 4.0, entityiterator.getZ(), 0.0f, 0.0f, 0.0f, 10.0f, 10.0f, 10.0f, 1681666650);
                        }
                        if (entityiterator instanceof TormentorScorpioidSummonEntity) {
                            RenderTest6Procedure.renderShape(RenderTest6Procedure.shape(), entityiterator.getX(), entityiterator.getY() + 2.0, entityiterator.getZ(), 0.0f, 0.0f, 0.0f, 5.0f, 5.0f, 5.0f, 1684288050);
                        }
                        if (!(entityiterator instanceof TormentorVoidlasherSummonEntity)) continue;
                        RenderTest6Procedure.renderShape(RenderTest6Procedure.shape(), entityiterator.getX(), entityiterator.getY() + 2.0, entityiterator.getZ(), 0.0f, 0.0f, 0.0f, 5.0f, 5.0f, 5.0f, 1685586040);
                    }
                    RenderTest6Procedure.release();
                }
                if (tormentor_distance < 400.0 && (rotation_from_tormentor = Math.min(Math.abs((Math.toDegrees(Math.atan2(ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_z - entity.getZ(), ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_x - entity.getX())) - ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_rotation + 360.0) % 360.0 - 270.0), 360.0 - Math.abs((Math.toDegrees(Math.atan2(ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_z - entity.getZ(), ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_x - entity.getX())) - ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_rotation + 360.0) % 360.0 - 270.0))) < 115.0) {
                    spheresize = 10.0;
                    if (RenderTest6Procedure.target(2)) {
                        RenderTest6Procedure.renderShape(RenderTest6Procedure.shape(), ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_x, ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_y + 4.0, ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_z, 0.0f, 0.0f, 0.0f, (float)spheresize, (float)spheresize, (float)spheresize, (int)(100.0 - rotation_from_tormentor * 0.86) << 24 | 0xFF0000 | 0x3200 | 0x32);
                        if (spheresize / 2.0 > tormentor_distance) {
                            ArphexModVariables.PlayerVariables _vars = (ArphexModVariables.PlayerVariables)entity.getData(ArphexModVariables.PLAYER_VARIABLES);
                            _vars.overlay_red = 5.0;
                            _vars.syncPlayerVariables(entity);
                        }
                        RenderTest6Procedure.release();
                    }
                }
            }
            if (((ArphexModVariables.PlayerVariables)entity.getData(ArphexModVariables.PLAYER_VARIABLES)).sphere_near > 0.0 || (entity instanceof LivingEntity && (_livEnt2 = (LivingEntity)entity).hasEffect(ArphexModMobEffects.ETERNAL_EVASION) ? _livEnt2.getEffect(ArphexModMobEffects.ETERNAL_EVASION).getAmplifier() : 0) == 9) {
                LivingEntity _livEnt3;
                RenderSystem.enableDepthTest();
                RenderSystem.depthMask((boolean)true);
                amplify = 400.0;
                if ((entity instanceof LivingEntity && (_livEnt3 = (LivingEntity)entity).hasEffect(ArphexModMobEffects.ETERNAL_EVASION) ? _livEnt3.getEffect(ArphexModMobEffects.ETERNAL_EVASION).getAmplifier() : 0) == 9) {
                    amplify = 1500.0;
                }
                Vec3 _center = new Vec3(x, y, z);
                List<Entity> _entfound = world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(amplify / 2.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList();
                for (Entity entityiterator : _entfound) {
                    SphereAnimEntity _datEntS;
                    Monster _datEntS2;
                    Player _plrCldCheck55;
                    if (entityiterator instanceof Player && entityiterator instanceof Player && (_plrCldCheck55 = (Player)entityiterator).getCooldowns().isOnCooldown((Item)ArphexModItems.SPACETIME_CHESTPLATE.get())) {
                        float f;
                        if (entityiterator instanceof Player) {
                            Player _plrCldRem56 = (Player)entityiterator;
                            f = _plrCldRem56.getCooldowns().getCooldownPercent((Item)ArphexModItems.SPACETIME_CHESTPLATE.get(), 0.0f) * 100.0f;
                        } else {
                            f = 0.0f;
                        }
                        if (f >= 75.0f) {
                            float f2;
                            if (entityiterator instanceof Player) {
                                Player _plrCldRem57 = (Player)entityiterator;
                                f2 = _plrCldRem57.getCooldowns().getCooldownPercent((Item)ArphexModItems.SPACETIME_CHESTPLATE.get(), 0.0f) * 100.0f;
                            } else {
                                f2 = 0.0f;
                            }
                            spheresize = Math.min(50.0f - Math.abs(50.0f - Math.abs((75.0f - f2) * 4.0f)), 10.0f);
                            opacity = 140.0;
                            col_r = 50.0;
                            col_g = 50.0;
                            col_b = 170.0;
                            RenderSystem.disableCull();
                            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                            if (RenderTest6Procedure.target(2)) {
                                RenderTest6Procedure.renderShape(RenderTest6Procedure.shape(), entityiterator.getX(), entityiterator.getY() + 1.0, entityiterator.getZ(), 0.0f, 0.0f, 0.0f, (float)spheresize, (float)spheresize, (float)spheresize, (int)opacity << 24 | (int)col_r << 16 | (int)col_g << 8 | (int)col_b);
                                if (entityiterator instanceof SphereAnimEntity && spheresize / 2.0 > distance) {
                                    String string;
                                    if (entityiterator instanceof SphereAnimEntity) {
                                        _datEntS2 = (SphereAnimEntity)entityiterator;
                                        string = (String)_datEntS2.getEntityData().get(SphereAnimEntity.DATA_color);
                                    } else {
                                        string = "";
                                    }
                                    if (string.equals("white")) {
                                        _vars = (ArphexModVariables.PlayerVariables)entity.getData(ArphexModVariables.PLAYER_VARIABLES);
                                        _vars.overlay_white = 5.0;
                                        _vars.syncPlayerVariables(entity);
                                    } else {
                                        _vars = (ArphexModVariables.PlayerVariables)entity.getData(ArphexModVariables.PLAYER_VARIABLES);
                                        _vars.overlay_black = 5.0;
                                        _vars.syncPlayerVariables(entity);
                                    }
                                }
                                RenderTest6Procedure.release();
                            }
                        }
                    }
                    if (!(entityiterator instanceof SphereAnimEntity) && !(entityiterator instanceof AscendSphereAnimEntity)) continue;
                    distance = Math.sqrt((entity.getX() - entityiterator.getX()) * (entity.getX() - entityiterator.getX()) + (entity.getY() + 1.0 - entityiterator.getY()) * (entity.getY() + 1.0 - entityiterator.getY()) + (entity.getZ() - entityiterator.getZ()) * (entity.getZ() - entityiterator.getZ()));
                    if (entityiterator instanceof SphereAnimEntity) {
                        String string;
                        int n;
                        if (entityiterator instanceof SphereAnimEntity) {
                            _datEntI = (SphereAnimEntity)entityiterator;
                            n = (Integer)_datEntI.getEntityData().get(SphereAnimEntity.DATA_sphere_size);
                        } else {
                            n = 0;
                        }
                        spheresize = n / 10;
                        opacity = 140.0;
                        if (entityiterator instanceof SphereAnimEntity) {
                            _datEntS = (SphereAnimEntity)entityiterator;
                            string = (String)_datEntS.getEntityData().get(SphereAnimEntity.DATA_color);
                        } else {
                            string = "";
                        }
                        if (string.equals("white")) {
                            col_r = 255.0;
                            col_g = 255.0;
                            col_b = 255.0;
                        } else {
                            String string2;
                            if (entityiterator instanceof SphereAnimEntity) {
                                _datEntS = (SphereAnimEntity)entityiterator;
                                string2 = (String)_datEntS.getEntityData().get(SphereAnimEntity.DATA_color);
                            } else {
                                string2 = "";
                            }
                            if (string2.equals("purple")) {
                                col_r = 141.0;
                                col_g = 21.0;
                                col_b = 161.0;
                            } else {
                                col_r = 0.0;
                                col_g = 0.0;
                                col_b = 0.0;
                            }
                        }
                    } else {
                        int n;
                        RenderSystem.disableCull();
                        RenderSystem.defaultBlendFunc();
                        spheresize = 200.0;
                        if (entityiterator instanceof AscendSphereAnimEntity) {
                            _datEntI = (AscendSphereAnimEntity)entityiterator;
                            n = (Integer)_datEntI.getEntityData().get(AscendSphereAnimEntity.DATA_barriermode);
                        } else {
                            n = 0;
                        }
                        if (n > 0) {
                            col_r = 255.0;
                            col_g = 255.0;
                            col_b = 255.0;
                        } else {
                            String string;
                            if (entityiterator instanceof AscendSphereAnimEntity) {
                                _datEntS = (AscendSphereAnimEntity)entityiterator;
                                string = (String)_datEntS.getEntityData().get(AscendSphereAnimEntity.DATA_color);
                            } else {
                                string = "";
                            }
                            if (string.equals("green")) {
                                col_r = 120.0;
                                col_g = 255.0;
                                col_b = 120.0;
                            } else {
                                String string3;
                                if (entityiterator instanceof AscendSphereAnimEntity) {
                                    _datEntS2 = (AscendSphereAnimEntity)entityiterator;
                                    string3 = (String)_datEntS2.getEntityData().get(AscendSphereAnimEntity.DATA_color);
                                } else {
                                    string3 = "";
                                }
                                if (string3.equals("blue")) {
                                    col_r = 120.0;
                                    col_g = 120.0;
                                    col_b = 255.0;
                                } else {
                                    String string4;
                                    if (entityiterator instanceof AscendSphereAnimEntity) {
                                        AscendSphereAnimEntity _datEntS3 = (AscendSphereAnimEntity)entityiterator;
                                        string4 = (String)_datEntS3.getEntityData().get(AscendSphereAnimEntity.DATA_color);
                                    } else {
                                        string4 = "";
                                    }
                                    if (string4.equals("yellow")) {
                                        col_r = 240.0;
                                        col_g = 240.0;
                                        col_b = 100.0;
                                    } else {
                                        String string5;
                                        if (entityiterator instanceof AscendSphereAnimEntity) {
                                            AscendSphereAnimEntity _datEntS4 = (AscendSphereAnimEntity)entityiterator;
                                            string5 = (String)_datEntS4.getEntityData().get(AscendSphereAnimEntity.DATA_color);
                                        } else {
                                            string5 = "";
                                        }
                                        if (string5.equals("orange")) {
                                            col_r = 255.0;
                                            col_g = 160.0;
                                            col_b = 100.0;
                                        } else {
                                            String string6;
                                            if (entityiterator instanceof AscendSphereAnimEntity) {
                                                AscendSphereAnimEntity _datEntS5 = (AscendSphereAnimEntity)entityiterator;
                                                string6 = (String)_datEntS5.getEntityData().get(AscendSphereAnimEntity.DATA_color);
                                            } else {
                                                string6 = "";
                                            }
                                            if (string6.equals("purple")) {
                                                col_r = 180.0;
                                                col_g = 120.0;
                                                col_b = 255.0;
                                            } else {
                                                String string7;
                                                if (entityiterator instanceof AscendSphereAnimEntity) {
                                                    AscendSphereAnimEntity _datEntS6 = (AscendSphereAnimEntity)entityiterator;
                                                    string7 = (String)_datEntS6.getEntityData().get(AscendSphereAnimEntity.DATA_color);
                                                } else {
                                                    string7 = "";
                                                }
                                                if (string7.equals("pink")) {
                                                    col_r = 255.0;
                                                    col_g = 120.0;
                                                    col_b = 180.0;
                                                } else {
                                                    String string8;
                                                    if (entityiterator instanceof AscendSphereAnimEntity) {
                                                        AscendSphereAnimEntity _datEntS7 = (AscendSphereAnimEntity)entityiterator;
                                                        string8 = (String)_datEntS7.getEntityData().get(AscendSphereAnimEntity.DATA_color);
                                                    } else {
                                                        string8 = "";
                                                    }
                                                    if (string8.equals("invisible")) {
                                                        opacity = 999.0;
                                                    } else {
                                                        col_r = 255.0;
                                                        col_g = 120.0;
                                                        col_b = 120.0;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        if (opacity != 999.0) {
                            opacity = distance < 200.0 ? (distance < 100.0 ? 100.0 : (double)Math.round(100.0 * (1.0 - (distance - 100.0) / 100.0))) : 0.0;
                        }
                    }
                    if (opacity == 999.0 || !RenderTest6Procedure.target(2)) continue;
                    RenderTest6Procedure.renderShape(RenderTest6Procedure.shape(), entityiterator.getX(), entityiterator.getY() + 1.0, entityiterator.getZ(), 0.0f, 0.0f, 0.0f, (float)spheresize, (float)spheresize, (float)spheresize, (int)opacity << 24 | (int)col_r << 16 | (int)col_g << 8 | (int)col_b);
                    if (entityiterator instanceof SphereAnimEntity && spheresize / 2.0 > distance) {
                        String string;
                        if (entityiterator instanceof SphereAnimEntity) {
                            _datEntS = (SphereAnimEntity)entityiterator;
                            string = (String)_datEntS.getEntityData().get(SphereAnimEntity.DATA_color);
                        } else {
                            string = "";
                        }
                        if (string.equals("white")) {
                            _vars = (ArphexModVariables.PlayerVariables)entity.getData(ArphexModVariables.PLAYER_VARIABLES);
                            _vars.overlay_white = 5.0;
                            _vars.syncPlayerVariables(entity);
                        } else {
                            _vars = (ArphexModVariables.PlayerVariables)entity.getData(ArphexModVariables.PLAYER_VARIABLES);
                            _vars.overlay_black = 5.0;
                            _vars.syncPlayerVariables(entity);
                        }
                    }
                    RenderTest6Procedure.release();
                }
            }
        }
    }
}

