/*
 * Decompiled with CFR 0.152.
 */
package net.arphex.network;

import java.util.function.Supplier;
import net.arphex.ArphexMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class ArphexModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"arphex");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        ArphexMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
        ArphexMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"arphex", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.writeNbt((Tag)message.data.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"arphex", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public String ShowOverlay = "\"\"";
        public double mothsurvivals = 0.0;
        public boolean mothtamer = false;
        public String ShowOverlay2 = "\"\"";
        public double saturationclock = 0.0;
        public boolean killedscorpioid = false;
        public boolean holdingspace = false;
        public boolean holdleftclick = false;
        public boolean killedvoidlasher = false;
        public String ShowOverlay3 = "\"\"";
        public boolean abyssfly = false;
        public double doublejumpcool = 0.0;
        public double arphexcompass = 0.0;
        public double arphexanglevsyaw = 0.0;
        public double arphextriangx = 0.0;
        public double arphextriangz = 0.0;
        public double ownedantsnear = 0.0;
        public double tamedants = 0.0;
        public double pocketdimensionx = 0.0;
        public double shadertime = 0.0;
        public boolean show_tormentor_overlay = false;
        public boolean totemfatigue = false;
        public double time_in_portal = 0.0;
        public double tormentor_respite = 0.0;
        public double recently_attacked_tormentor = 0.0;
        public double torment_cycle = 0.0;
        public String torment_mode = "\"\"";
        public double killedtormentor = 0.0;
        public double moth_summon_active = 0.0;
        public double tormentor_summon_active = 0.0;
        public double smshealth = 0.0;
        public double tmshealth = 0.0;
        public String player_dimension = "\"\"";
        public boolean tormentor_long_range_anim = false;
        public boolean player_overlay = false;
        public double fov_smoothen = 0.0;
        public double overlay_white = 0.0;
        public double wrath_charge_time = 0.0;
        public double overlay_black = 0.0;
        public double sphere_near = 0.0;
        public double laser_emitter_near = 0.0;
        public double overlay_red = 0.0;
        public double tormentor_render = 0.0;
        public double shader2 = 0.0;
        public double tormentor_overlay_anim = 0.0;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putString("ShowOverlay", this.ShowOverlay);
            nbt.putDouble("mothsurvivals", this.mothsurvivals);
            nbt.putBoolean("mothtamer", this.mothtamer);
            nbt.putString("ShowOverlay2", this.ShowOverlay2);
            nbt.putDouble("saturationclock", this.saturationclock);
            nbt.putBoolean("killedscorpioid", this.killedscorpioid);
            nbt.putBoolean("holdingspace", this.holdingspace);
            nbt.putBoolean("holdleftclick", this.holdleftclick);
            nbt.putBoolean("killedvoidlasher", this.killedvoidlasher);
            nbt.putString("ShowOverlay3", this.ShowOverlay3);
            nbt.putBoolean("abyssfly", this.abyssfly);
            nbt.putDouble("doublejumpcool", this.doublejumpcool);
            nbt.putDouble("arphexcompass", this.arphexcompass);
            nbt.putDouble("arphexanglevsyaw", this.arphexanglevsyaw);
            nbt.putDouble("arphextriangx", this.arphextriangx);
            nbt.putDouble("arphextriangz", this.arphextriangz);
            nbt.putDouble("ownedantsnear", this.ownedantsnear);
            nbt.putDouble("tamedants", this.tamedants);
            nbt.putDouble("pocketdimensionx", this.pocketdimensionx);
            nbt.putDouble("shadertime", this.shadertime);
            nbt.putBoolean("show_tormentor_overlay", this.show_tormentor_overlay);
            nbt.putBoolean("totemfatigue", this.totemfatigue);
            nbt.putDouble("time_in_portal", this.time_in_portal);
            nbt.putDouble("tormentor_respite", this.tormentor_respite);
            nbt.putDouble("recently_attacked_tormentor", this.recently_attacked_tormentor);
            nbt.putDouble("torment_cycle", this.torment_cycle);
            nbt.putString("torment_mode", this.torment_mode);
            nbt.putDouble("killedtormentor", this.killedtormentor);
            nbt.putDouble("moth_summon_active", this.moth_summon_active);
            nbt.putDouble("tormentor_summon_active", this.tormentor_summon_active);
            nbt.putDouble("smshealth", this.smshealth);
            nbt.putDouble("tmshealth", this.tmshealth);
            nbt.putString("player_dimension", this.player_dimension);
            nbt.putBoolean("tormentor_long_range_anim", this.tormentor_long_range_anim);
            nbt.putBoolean("player_overlay", this.player_overlay);
            nbt.putDouble("fov_smoothen", this.fov_smoothen);
            nbt.putDouble("overlay_white", this.overlay_white);
            nbt.putDouble("wrath_charge_time", this.wrath_charge_time);
            nbt.putDouble("overlay_black", this.overlay_black);
            nbt.putDouble("sphere_near", this.sphere_near);
            nbt.putDouble("laser_emitter_near", this.laser_emitter_near);
            nbt.putDouble("overlay_red", this.overlay_red);
            nbt.putDouble("tormentor_render", this.tormentor_render);
            nbt.putDouble("shader2", this.shader2);
            nbt.putDouble("tormentor_overlay_anim", this.tormentor_overlay_anim);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.ShowOverlay = nbt.getString("ShowOverlay");
            this.mothsurvivals = nbt.getDouble("mothsurvivals");
            this.mothtamer = nbt.getBoolean("mothtamer");
            this.ShowOverlay2 = nbt.getString("ShowOverlay2");
            this.saturationclock = nbt.getDouble("saturationclock");
            this.killedscorpioid = nbt.getBoolean("killedscorpioid");
            this.holdingspace = nbt.getBoolean("holdingspace");
            this.holdleftclick = nbt.getBoolean("holdleftclick");
            this.killedvoidlasher = nbt.getBoolean("killedvoidlasher");
            this.ShowOverlay3 = nbt.getString("ShowOverlay3");
            this.abyssfly = nbt.getBoolean("abyssfly");
            this.doublejumpcool = nbt.getDouble("doublejumpcool");
            this.arphexcompass = nbt.getDouble("arphexcompass");
            this.arphexanglevsyaw = nbt.getDouble("arphexanglevsyaw");
            this.arphextriangx = nbt.getDouble("arphextriangx");
            this.arphextriangz = nbt.getDouble("arphextriangz");
            this.ownedantsnear = nbt.getDouble("ownedantsnear");
            this.tamedants = nbt.getDouble("tamedants");
            this.pocketdimensionx = nbt.getDouble("pocketdimensionx");
            this.shadertime = nbt.getDouble("shadertime");
            this.show_tormentor_overlay = nbt.getBoolean("show_tormentor_overlay");
            this.totemfatigue = nbt.getBoolean("totemfatigue");
            this.time_in_portal = nbt.getDouble("time_in_portal");
            this.tormentor_respite = nbt.getDouble("tormentor_respite");
            this.recently_attacked_tormentor = nbt.getDouble("recently_attacked_tormentor");
            this.torment_cycle = nbt.getDouble("torment_cycle");
            this.torment_mode = nbt.getString("torment_mode");
            this.killedtormentor = nbt.getDouble("killedtormentor");
            this.moth_summon_active = nbt.getDouble("moth_summon_active");
            this.tormentor_summon_active = nbt.getDouble("tormentor_summon_active");
            this.smshealth = nbt.getDouble("smshealth");
            this.tmshealth = nbt.getDouble("tmshealth");
            this.player_dimension = nbt.getString("player_dimension");
            this.tormentor_long_range_anim = nbt.getBoolean("tormentor_long_range_anim");
            this.player_overlay = nbt.getBoolean("player_overlay");
            this.fov_smoothen = nbt.getDouble("fov_smoothen");
            this.overlay_white = nbt.getDouble("overlay_white");
            this.wrath_charge_time = nbt.getDouble("wrath_charge_time");
            this.overlay_black = nbt.getDouble("overlay_black");
            this.sphere_near = nbt.getDouble("sphere_near");
            this.laser_emitter_near = nbt.getDouble("laser_emitter_near");
            this.overlay_red = nbt.getDouble("overlay_red");
            this.tormentor_render = nbt.getDouble("tormentor_render");
            this.shader2 = nbt.getDouble("shader2");
            this.tormentor_overlay_anim = nbt.getDouble("tormentor_overlay_anim");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "arphex_mapvars";
        public String LookScareLock = "\"\"";
        public double attackcycle = 0.0;
        public String slightrandom = "\"\"";
        public double clonesize = 0.0;
        public boolean onetimesplash = false;
        public double pocket_dimension_count = -10.0;
        public String tormentor_target_follow = "empty";
        public double tormentor_target_online = 0.0;
        public String tormentor_target_dimension = "\"\"";
        public double tormentor_target_x = 0.0;
        public double tormentor_target_y = 0.0;
        public double tormentor_target_z = 0.0;
        public double tormentor_health = 0.0;
        public double tormentor_x = 0.0;
        public double tormentor_y = 0.0;
        public double tormentor_z = 0.0;
        public double tormentor_entity_loaded = 0.0;
        public String bosskills = "\"\"";
        public double last_forceload_x = 0.0;
        public double last_forceload_z = 0.0;
        public String closest_tormentor_to_alignment = "\"\"";
        public boolean alternatecheck = false;
        public double tormentor_distance_as_uuid = 9.9999999E7;
        public double tormentor_countdown = 0.0;
        public String messagesequence = "\"\"";
        public double playeronlayer1 = 0.0;
        public double playeronlayer2 = 0.0;
        public double playeronlayer3 = 0.0;
        public double playeronlayer4 = 0.0;
        public boolean chunk_removal_complete = false;
        public double tormentor_rotation = 0.0;
        public boolean reload_render = false;
        public double force_unload_repeats = 0.0;
        public boolean full_tormentor_has_previously_spawned = false;
        public boolean limhit_tormentor = false;
        public boolean thunder_check = false;
        public double torchatcooldown = 0.0;
        public boolean tormentor_last_player_spawned = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            MapVariables data = new MapVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.LookScareLock = nbt.getString("LookScareLock");
            this.attackcycle = nbt.getDouble("attackcycle");
            this.slightrandom = nbt.getString("slightrandom");
            this.clonesize = nbt.getDouble("clonesize");
            this.onetimesplash = nbt.getBoolean("onetimesplash");
            this.pocket_dimension_count = nbt.getDouble("pocket_dimension_count");
            this.tormentor_target_follow = nbt.getString("tormentor_target_follow");
            this.tormentor_target_online = nbt.getDouble("tormentor_target_online");
            this.tormentor_target_dimension = nbt.getString("tormentor_target_dimension");
            this.tormentor_target_x = nbt.getDouble("tormentor_target_x");
            this.tormentor_target_y = nbt.getDouble("tormentor_target_y");
            this.tormentor_target_z = nbt.getDouble("tormentor_target_z");
            this.tormentor_health = nbt.getDouble("tormentor_health");
            this.tormentor_x = nbt.getDouble("tormentor_x");
            this.tormentor_y = nbt.getDouble("tormentor_y");
            this.tormentor_z = nbt.getDouble("tormentor_z");
            this.tormentor_entity_loaded = nbt.getDouble("tormentor_entity_loaded");
            this.bosskills = nbt.getString("bosskills");
            this.last_forceload_x = nbt.getDouble("last_forceload_x");
            this.last_forceload_z = nbt.getDouble("last_forceload_z");
            this.closest_tormentor_to_alignment = nbt.getString("closest_tormentor_to_alignment");
            this.alternatecheck = nbt.getBoolean("alternatecheck");
            this.tormentor_distance_as_uuid = nbt.getDouble("tormentor_distance_as_uuid");
            this.tormentor_countdown = nbt.getDouble("tormentor_countdown");
            this.messagesequence = nbt.getString("messagesequence");
            this.playeronlayer1 = nbt.getDouble("playeronlayer1");
            this.playeronlayer2 = nbt.getDouble("playeronlayer2");
            this.playeronlayer3 = nbt.getDouble("playeronlayer3");
            this.playeronlayer4 = nbt.getDouble("playeronlayer4");
            this.chunk_removal_complete = nbt.getBoolean("chunk_removal_complete");
            this.tormentor_rotation = nbt.getDouble("tormentor_rotation");
            this.reload_render = nbt.getBoolean("reload_render");
            this.force_unload_repeats = nbt.getDouble("force_unload_repeats");
            this.full_tormentor_has_previously_spawned = nbt.getBoolean("full_tormentor_has_previously_spawned");
            this.limhit_tormentor = nbt.getBoolean("limhit_tormentor");
            this.thunder_check = nbt.getBoolean("thunder_check");
            this.torchatcooldown = nbt.getDouble("torchatcooldown");
            this.tormentor_last_player_spawned = nbt.getBoolean("tormentor_last_player_spawned");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putString("LookScareLock", this.LookScareLock);
            nbt.putDouble("attackcycle", this.attackcycle);
            nbt.putString("slightrandom", this.slightrandom);
            nbt.putDouble("clonesize", this.clonesize);
            nbt.putBoolean("onetimesplash", this.onetimesplash);
            nbt.putDouble("pocket_dimension_count", this.pocket_dimension_count);
            nbt.putString("tormentor_target_follow", this.tormentor_target_follow);
            nbt.putDouble("tormentor_target_online", this.tormentor_target_online);
            nbt.putString("tormentor_target_dimension", this.tormentor_target_dimension);
            nbt.putDouble("tormentor_target_x", this.tormentor_target_x);
            nbt.putDouble("tormentor_target_y", this.tormentor_target_y);
            nbt.putDouble("tormentor_target_z", this.tormentor_target_z);
            nbt.putDouble("tormentor_health", this.tormentor_health);
            nbt.putDouble("tormentor_x", this.tormentor_x);
            nbt.putDouble("tormentor_y", this.tormentor_y);
            nbt.putDouble("tormentor_z", this.tormentor_z);
            nbt.putDouble("tormentor_entity_loaded", this.tormentor_entity_loaded);
            nbt.putString("bosskills", this.bosskills);
            nbt.putDouble("last_forceload_x", this.last_forceload_x);
            nbt.putDouble("last_forceload_z", this.last_forceload_z);
            nbt.putString("closest_tormentor_to_alignment", this.closest_tormentor_to_alignment);
            nbt.putBoolean("alternatecheck", this.alternatecheck);
            nbt.putDouble("tormentor_distance_as_uuid", this.tormentor_distance_as_uuid);
            nbt.putDouble("tormentor_countdown", this.tormentor_countdown);
            nbt.putString("messagesequence", this.messagesequence);
            nbt.putDouble("playeronlayer1", this.playeronlayer1);
            nbt.putDouble("playeronlayer2", this.playeronlayer2);
            nbt.putDouble("playeronlayer3", this.playeronlayer3);
            nbt.putDouble("playeronlayer4", this.playeronlayer4);
            nbt.putBoolean("chunk_removal_complete", this.chunk_removal_complete);
            nbt.putDouble("tormentor_rotation", this.tormentor_rotation);
            nbt.putBoolean("reload_render", this.reload_render);
            nbt.putDouble("force_unload_repeats", this.force_unload_repeats);
            nbt.putBoolean("full_tormentor_has_previously_spawned", this.full_tormentor_has_previously_spawned);
            nbt.putBoolean("limhit_tormentor", this.limhit_tormentor);
            nbt.putBoolean("thunder_check", this.thunder_check);
            nbt.putDouble("torchatcooldown", this.torchatcooldown);
            nbt.putBoolean("tormentor_last_player_spawned", this.tormentor_last_player_spawned);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "arphex_worldvars";
        public boolean checkedprojecte = false;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            WorldVariables data = new WorldVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.checkedprojecte = nbt.getBoolean("checkedprojecte");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putBoolean("checkedprojecte", this.checkedprojecte);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SavedDataSyncMessage(1, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.mothsurvivals = original.mothsurvivals;
            clone.mothtamer = original.mothtamer;
            clone.saturationclock = original.saturationclock;
            clone.killedscorpioid = original.killedscorpioid;
            clone.killedvoidlasher = original.killedvoidlasher;
            clone.abyssfly = original.abyssfly;
            clone.ownedantsnear = original.ownedantsnear;
            clone.pocketdimensionx = original.pocketdimensionx;
            clone.shadertime = original.shadertime;
            clone.tormentor_respite = original.tormentor_respite;
            clone.recently_attacked_tormentor = original.recently_attacked_tormentor;
            clone.torment_cycle = original.torment_cycle;
            clone.torment_mode = original.torment_mode;
            clone.killedtormentor = original.killedtormentor;
            clone.moth_summon_active = original.moth_summon_active;
            clone.tormentor_summon_active = original.tormentor_summon_active;
            clone.smshealth = original.smshealth;
            clone.tmshealth = original.tmshealth;
            if (!event.isWasDeath()) {
                clone.ShowOverlay = original.ShowOverlay;
                clone.ShowOverlay2 = original.ShowOverlay2;
                clone.holdingspace = original.holdingspace;
                clone.holdleftclick = original.holdleftclick;
                clone.ShowOverlay3 = original.ShowOverlay3;
                clone.doublejumpcool = original.doublejumpcool;
                clone.arphexcompass = original.arphexcompass;
                clone.arphexanglevsyaw = original.arphexanglevsyaw;
                clone.arphextriangx = original.arphextriangx;
                clone.arphextriangz = original.arphextriangz;
                clone.tamedants = original.tamedants;
                clone.show_tormentor_overlay = original.show_tormentor_overlay;
                clone.totemfatigue = original.totemfatigue;
                clone.time_in_portal = original.time_in_portal;
                clone.player_dimension = original.player_dimension;
                clone.tormentor_long_range_anim = original.tormentor_long_range_anim;
                clone.player_overlay = original.player_overlay;
                clone.fov_smoothen = original.fov_smoothen;
                clone.overlay_white = original.overlay_white;
                clone.wrath_charge_time = original.wrath_charge_time;
                clone.overlay_black = original.overlay_black;
                clone.sphere_near = original.sphere_near;
                clone.laser_emitter_near = original.laser_emitter_near;
                clone.overlay_red = original.overlay_red;
                clone.tormentor_render = original.tormentor_render;
                clone.shader2 = original.shader2;
                clone.tormentor_overlay_anim = original.tormentor_overlay_anim;
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

