/*
 * Decompiled with CFR 0.152.
 */
package net.arphex.item;

import java.util.List;
import net.arphex.procedures.BlockBroken2Procedure;
import net.arphex.procedures.TectonicTunnelerToolInHandTickProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TectonicTunnelerItem
extends PickaxeItem {
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 300;
        }

        public float getSpeed() {
            return 15.0f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_DIAMOND_TOOL;
        }

        public int getEnchantmentValue() {
            return 0;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of();
        }
    };

    public TectonicTunnelerItem() {
        super(TOOL_TIER, new Item.Properties().attributes(DiggerItem.createAttributes((Tier)TOOL_TIER, (float)4.0f, (float)-3.0f)));
    }

    public boolean mineBlock(ItemStack itemstack, Level world, BlockState blockstate, BlockPos pos, LivingEntity entity) {
        boolean retval = super.mineBlock(itemstack, world, blockstate, pos, entity);
        BlockBroken2Procedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), (Entity)entity);
        return retval;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.literal((String)"A powerful pickaxe capable of mining out 2x1 passageways for fast travel underground (Used in crafting the Abyssal Pickaxe) "));
        list.add((Component)Component.literal((String)"- Crouch to mine one block at a time"));
        list.add((Component)Component.literal((String)"\u00a77Drops from Termite Tunneler Queen [DUNGEON MINIBOSS]"));
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (selected) {
            TectonicTunnelerToolInHandTickProcedure.execute(entity);
        }
    }
}

