/*
 * Decompiled with CFR 0.152.
 */
package net.arphex.entity;

import javax.annotation.Nullable;
import net.arphex.procedures.BossDeathProcedure;
import net.arphex.procedures.GoToTormentorProcedure;
import net.arphex.procedures.TormentorScorpioidSummonOnEntityTickUpdateProcedure;
import net.arphex.procedures.TormentorScorpioidSummonOnInitialEntitySpawnProcedure;
import net.arphex.procedures.TormentorVoidlasherSummonEntityDiesProcedure;
import net.arphex.procedures.TormentorVoidlasherSummonEntityIsHurtProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.BreathAirGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class TormentorScorpioidSummonEntity
extends Monster
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.defineId(TormentorScorpioidSummonEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.defineId(TormentorScorpioidSummonEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.defineId(TormentorScorpioidSummonEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Boolean> DATA_flee_mode = SynchedEntityData.defineId(TormentorScorpioidSummonEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    String prevAnim = "empty";

    public TormentorScorpioidSummonEntity(EntityType<TormentorScorpioidSummonEntity> type, Level world) {
        super(type, world);
        this.xpReward = 500;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHOOT, (Object)false);
        builder.define(ANIMATION, (Object)"undefined");
        builder.define(TEXTURE, (Object)"tormentluster");
        builder.define(DATA_flee_mode, (Object)false);
    }

    public void setTexture(String texture) {
        this.entityData.set(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.entityData.get(TEXTURE);
    }

    protected PathNavigation createNavigation(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean canUse() {
                double x = TormentorScorpioidSummonEntity.this.getX();
                double y = TormentorScorpioidSummonEntity.this.getY();
                double z = TormentorScorpioidSummonEntity.this.getZ();
                TormentorScorpioidSummonEntity entity = TormentorScorpioidSummonEntity.this;
                Level world = TormentorScorpioidSummonEntity.this.level();
                return super.canUse() && GoToTormentorProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TormentorScorpioidSummonEntity.this.getX();
                double y = TormentorScorpioidSummonEntity.this.getY();
                double z = TormentorScorpioidSummonEntity.this.getZ();
                TormentorScorpioidSummonEntity entity = TormentorScorpioidSummonEntity.this;
                Level world = TormentorScorpioidSummonEntity.this.level();
                return super.canContinueToUse() && GoToTormentorProcedure.execute((Entity)entity);
            }
        }.setAlertOthers(new Class[0]));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 100.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = TormentorScorpioidSummonEntity.this.getX();
                double y = TormentorScorpioidSummonEntity.this.getY();
                double z = TormentorScorpioidSummonEntity.this.getZ();
                TormentorScorpioidSummonEntity entity = TormentorScorpioidSummonEntity.this;
                Level world = TormentorScorpioidSummonEntity.this.level();
                return super.canUse() && GoToTormentorProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TormentorScorpioidSummonEntity.this.getX();
                double y = TormentorScorpioidSummonEntity.this.getY();
                double z = TormentorScorpioidSummonEntity.this.getZ();
                TormentorScorpioidSummonEntity entity = TormentorScorpioidSummonEntity.this;
                Level world = TormentorScorpioidSummonEntity.this.level();
                return super.canContinueToUse() && GoToTormentorProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new BreathAirGoal((PathfinderMob)this){

            public boolean canUse() {
                double x = TormentorScorpioidSummonEntity.this.getX();
                double y = TormentorScorpioidSummonEntity.this.getY();
                double z = TormentorScorpioidSummonEntity.this.getZ();
                TormentorScorpioidSummonEntity entity = TormentorScorpioidSummonEntity.this;
                Level world = TormentorScorpioidSummonEntity.this.level();
                return super.canUse() && GoToTormentorProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TormentorScorpioidSummonEntity.this.getX();
                double y = TormentorScorpioidSummonEntity.this.getY();
                double z = TormentorScorpioidSummonEntity.this.getZ();
                TormentorScorpioidSummonEntity entity = TormentorScorpioidSummonEntity.this;
                Level world = TormentorScorpioidSummonEntity.this.level();
                return super.canContinueToUse() && GoToTormentorProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new FollowMobGoal((Mob)this, 1.0, 50.0f, 50.0f){

            public boolean canUse() {
                double x = TormentorScorpioidSummonEntity.this.getX();
                double y = TormentorScorpioidSummonEntity.this.getY();
                double z = TormentorScorpioidSummonEntity.this.getZ();
                TormentorScorpioidSummonEntity entity = TormentorScorpioidSummonEntity.this;
                Level world = TormentorScorpioidSummonEntity.this.level();
                return super.canUse() && GoToTormentorProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TormentorScorpioidSummonEntity.this.getX();
                double y = TormentorScorpioidSummonEntity.this.getY();
                double z = TormentorScorpioidSummonEntity.this.getZ();
                TormentorScorpioidSummonEntity entity = TormentorScorpioidSummonEntity.this;
                Level world = TormentorScorpioidSummonEntity.this.level();
                return super.canContinueToUse() && GoToTormentorProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.5, 20){

            protected Vec3 getPosition() {
                RandomSource random = TormentorScorpioidSummonEntity.this.getRandom();
                double dir_x = TormentorScorpioidSummonEntity.this.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_y = TormentorScorpioidSummonEntity.this.getY() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_z = TormentorScorpioidSummonEntity.this.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                return new Vec3(dir_x, dir_y, dir_z);
            }

            public boolean canUse() {
                double x = TormentorScorpioidSummonEntity.this.getX();
                double y = TormentorScorpioidSummonEntity.this.getY();
                double z = TormentorScorpioidSummonEntity.this.getZ();
                TormentorScorpioidSummonEntity entity = TormentorScorpioidSummonEntity.this;
                Level world = TormentorScorpioidSummonEntity.this.level();
                return super.canUse() && GoToTormentorProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TormentorScorpioidSummonEntity.this.getX();
                double y = TormentorScorpioidSummonEntity.this.getY();
                double z = TormentorScorpioidSummonEntity.this.getZ();
                TormentorScorpioidSummonEntity entity = TormentorScorpioidSummonEntity.this;
                Level world = TormentorScorpioidSummonEntity.this.level();
                return super.canContinueToUse() && GoToTormentorProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 100.0f){

            public boolean canUse() {
                double x = TormentorScorpioidSummonEntity.this.getX();
                double y = TormentorScorpioidSummonEntity.this.getY();
                double z = TormentorScorpioidSummonEntity.this.getZ();
                TormentorScorpioidSummonEntity entity = TormentorScorpioidSummonEntity.this;
                Level world = TormentorScorpioidSummonEntity.this.level();
                return super.canUse() && GoToTormentorProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TormentorScorpioidSummonEntity.this.getX();
                double y = TormentorScorpioidSummonEntity.this.getY();
                double z = TormentorScorpioidSummonEntity.this.getZ();
                TormentorScorpioidSummonEntity entity = TormentorScorpioidSummonEntity.this;
                Level world = TormentorScorpioidSummonEntity.this.level();
                return super.canContinueToUse() && GoToTormentorProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = TormentorScorpioidSummonEntity.this.getX();
                double y = TormentorScorpioidSummonEntity.this.getY();
                double z = TormentorScorpioidSummonEntity.this.getZ();
                TormentorScorpioidSummonEntity entity = TormentorScorpioidSummonEntity.this;
                Level world = TormentorScorpioidSummonEntity.this.level();
                return super.canUse() && GoToTormentorProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TormentorScorpioidSummonEntity.this.getX();
                double y = TormentorScorpioidSummonEntity.this.getY();
                double z = TormentorScorpioidSummonEntity.this.getZ();
                TormentorScorpioidSummonEntity entity = TormentorScorpioidSummonEntity.this;
                Level world = TormentorScorpioidSummonEntity.this.level();
                return super.canContinueToUse() && GoToTormentorProcedure.execute((Entity)entity);
            }
        });
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"arphex:creepy_arthropod_large"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"arphex:heartbeats"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.wither.death"));
    }

    public boolean causeFallDamage(float l, float d, DamageSource source) {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        TormentorVoidlasherSummonEntityIsHurtProcedure.execute(source.getEntity());
        Entity immediatesourceentity = source.getDirectEntity();
        if (source.is(DamageTypes.IN_FIRE)) {
            return false;
        }
        if (source.getDirectEntity() instanceof ThrownPotion || source.getDirectEntity() instanceof AreaEffectCloud || source.typeHolder().is(NeoForgeMod.POISON_DAMAGE)) {
            return false;
        }
        if (source.is(DamageTypes.FALL)) {
            return false;
        }
        if (source.is(DamageTypes.CACTUS)) {
            return false;
        }
        if (source.is(DamageTypes.DROWN)) {
            return false;
        }
        if (source.is(DamageTypes.LIGHTNING_BOLT)) {
            return false;
        }
        if (source.is(DamageTypes.EXPLOSION) || source.is(DamageTypes.PLAYER_EXPLOSION)) {
            return false;
        }
        if (source.is(DamageTypes.WITHER) || source.is(DamageTypes.WITHER_SKULL)) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public boolean fireImmune() {
        return true;
    }

    public void die(DamageSource source) {
        super.die(source);
        TormentorVoidlasherSummonEntityDiesProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), source.getEntity());
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        TormentorScorpioidSummonOnInitialEntitySpawnProcedure.execute((LevelAccessor)world, this.getX(), this.getY(), this.getZ(), (Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Texture", this.getTexture());
        compound.putBoolean("Dataflee_mode", ((Boolean)this.entityData.get(DATA_flee_mode)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Texture")) {
            this.setTexture(compound.getString("Texture"));
        }
        if (compound.contains("Dataflee_mode")) {
            this.entityData.set(DATA_flee_mode, (Object)compound.getBoolean("Dataflee_mode"));
        }
    }

    public void baseTick() {
        super.baseTick();
        TormentorScorpioidSummonOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
        this.refreshDimensions();
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(1.0f);
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void setNoGravity(boolean ignored) {
        super.setNoGravity(true);
    }

    public void aiStep() {
        super.aiStep();
        this.setNoGravity(true);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 450.0);
        builder = builder.add(Attributes.ARMOR, 20.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 90.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 200.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 1.1);
        builder = builder.add(Attributes.FLYING_SPEED, 0.3);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            if (this.isDeadOrDying()) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("animation.bloodscorpion.idle"));
            }
            if (this.isShiftKeyDown()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bloodscorpion.ground"));
            }
            if (this.isSprinting()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bloodscorpion.crawl"));
            }
            if (this.isAggressive() && event.isMoving()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bloodscorpion.chase"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bloodscorpion.idle"));
        }
        return PlayState.STOP;
    }

    private PlayState attackingPredicate(AnimationState event) {
        double d1 = this.getX() - this.xOld;
        double d0 = this.getZ() - this.zOld;
        float velocity = (float)Math.sqrt(d1 * d1 + d0 * d0);
        if (this.getAttackAnim(event.getPartialTick()) > 0.0f && !this.swinging) {
            this.swinging = true;
            this.lastSwing = this.level().getGameTime();
        }
        if (this.swinging && this.lastSwing + 7L <= this.level().getGameTime()) {
            this.swinging = false;
        }
        if (this.swinging && event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().forceAnimationReset();
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.bloodscorpion.attack"));
        }
        return PlayState.CONTINUE;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 100) {
            this.remove(Entity.RemovalReason.KILLED);
            this.dropExperience((Entity)this);
            BossDeathProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
        }
    }

    public String getSyncedAnimation() {
        return (String)this.entityData.get(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.entityData.set(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 3, this::movementPredicate));
        data.add(new AnimationController((GeoAnimatable)this, "attacking", 3, this::attackingPredicate));
        data.add(new AnimationController((GeoAnimatable)this, "procedure", 3, this::procedurePredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

