/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.entity.ai.goal;

import com.mojang.datafixers.DataFixUtils;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;

public class FollowTypeSchoolLeaderGoal
extends Goal {
    private final AbstractSchoolingFish taskOwner;
    private int navigateTimer;
    private int cooldown;

    public FollowTypeSchoolLeaderGoal(AbstractSchoolingFish fishEntity) {
        this.taskOwner = fishEntity;
        this.cooldown = this.getNewCooldown(fishEntity);
    }

    private int getNewCooldown(AbstractSchoolingFish fishEntity) {
        return 200 + fishEntity.getRandom().nextInt(200) % 20;
    }

    public boolean canUse() {
        if (this.taskOwner.hasFollowers()) {
            return false;
        }
        if (this.taskOwner.isFollower()) {
            return true;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        this.cooldown = this.getNewCooldown(this.taskOwner);
        Predicate<AbstractSchoolingFish> predicate = fishEntity -> fishEntity.getType() == this.taskOwner.getType() && (fishEntity.canBeFollowed() || !fishEntity.isFollower());
        List schoolList = this.taskOwner.level().getEntitiesOfClass(this.taskOwner.getClass(), this.taskOwner.getBoundingBox().inflate(8.0, 8.0, 8.0), predicate);
        AbstractSchoolingFish fishEntity2 = (AbstractSchoolingFish)DataFixUtils.orElse(schoolList.stream().filter(AbstractSchoolingFish::canBeFollowed).findAny(), (Object)this.taskOwner);
        fishEntity2.addFollowers(schoolList.stream().filter(schoolFish -> !schoolFish.isFollower()));
        return this.taskOwner.isFollower();
    }

    public boolean canContinueToUse() {
        return this.taskOwner.isFollower() && this.taskOwner.inRangeOfLeader();
    }

    public void start() {
        this.navigateTimer = 0;
    }

    public void stop() {
        if (this.taskOwner != null) {
            this.taskOwner.stopFollowing();
        }
    }

    public void tick() {
        if (--this.navigateTimer <= 0) {
            this.navigateTimer = 10;
            this.taskOwner.pathToLeader();
        }
    }
}

