/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.renderer.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.teammetallurgy.aquaculture.block.TackleBoxBlock;
import com.teammetallurgy.aquaculture.block.blockentity.TackleBoxBlockEntity;
import com.teammetallurgy.aquaculture.client.ClientHandler;
import com.teammetallurgy.aquaculture.init.AquaBlocks;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import javax.annotation.Nonnull;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TackleBoxRenderer<T extends TackleBoxBlockEntity>
implements BlockEntityRenderer<T> {
    private static final ResourceLocation TACKLE_BOX_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"textures/entity/tileentity/tackle_box.png");
    private static final RenderType TACKLE_BOX_RENDER = RenderType.entityCutout((ResourceLocation)TACKLE_BOX_TEXTURE);
    private final ModelPart base;
    private final ModelPart lid;

    public TackleBoxRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart part = context.bakeLayer(ClientHandler.TACKLE_BOX);
        this.base = part.getChild("base");
        this.lid = part.getChild("lid");
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition lid = partDefinition.addOrReplaceChild("lid", CubeListBuilder.create().texOffs(0, 0).addBox(-7.0f, -3.0f, -8.0f, 14.0f, 3.0f, 8.0f), PartPose.offset((float)7.0f, (float)12.0f, (float)4.0f));
        partDefinition.addOrReplaceChild("base", CubeListBuilder.create().texOffs(0, 11).addBox(0.0f, -6.0f, -8.0f, 14.0f, 6.0f, 8.0f), PartPose.offset((float)0.0f, (float)18.0f, (float)4.0f));
        lid.addOrReplaceChild("handle", CubeListBuilder.create().texOffs(36, 0).addBox(-2.0f, -4.0f, -5.0f, 4.0f, 1.0f, 2.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public void render(@Nonnull T tackleBox, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Level world = tackleBox.getLevel();
        boolean hasWorld = world != null;
        BlockState state = hasWorld ? tackleBox.getBlockState() : (BlockState)((Block)AquaBlocks.TACKLE_BOX.get()).defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)Direction.SOUTH);
        Block block = state.getBlock();
        if (block instanceof TackleBoxBlock) {
            matrixStack.pushPose();
            matrixStack.translate(0.5, 0.5, 0.5);
            float facing = ((Direction)state.getValue((Property)TackleBoxBlock.FACING)).toYRot();
            matrixStack.mulPose(Axis.YP.rotationDegrees(-facing));
            matrixStack.translate(-0.5, -0.5, -0.5);
            matrixStack.translate(0.0625f, 1.125f, 0.5f);
            matrixStack.mulPose(Axis.XN.rotationDegrees(-180.0f));
            DoubleBlockCombiner.NeighborCombineResult callbackWrapper = DoubleBlockCombiner.Combiner::acceptNone;
            float angle = ((TackleBoxBlockEntity)((Object)tackleBox)).getOpenNess(partialTicks);
            angle = 1.0f - angle;
            angle = 1.0f - angle * angle * angle;
            int brightness = ((Int2IntFunction)callbackWrapper.apply((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(combinedLight);
            VertexConsumer tackleBoxBuilder = buffer.getBuffer(TACKLE_BOX_RENDER);
            this.render(matrixStack, tackleBoxBuilder, this.base, this.lid, angle, brightness, combinedOverlay);
            matrixStack.popPose();
        }
    }

    private void render(PoseStack matrixStack, VertexConsumer builder, ModelPart base, ModelPart lid, float angle, int brightness, int combinedOverlay) {
        lid.xRot = -(angle * 1.5707964f);
        base.render(matrixStack, builder, brightness, combinedOverlay);
        lid.render(matrixStack, builder, brightness, combinedOverlay);
        lid.render(matrixStack, builder, brightness, combinedOverlay);
    }
}

