/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.common.me.key;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import com.glodblock.github.appflux.common.me.key.type.EnergyType;
import com.glodblock.github.appflux.common.me.key.type.FluxKeyType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluxKey
extends AEKey {
    public static final MapCodec<FluxKey> MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)EnergyType.CODEC.fieldOf("type").forGetter(o -> o.type)).apply((Applicative)builder, FluxKey::of));
    public static final Codec<FluxKey> CODEC = MAP_CODEC.codec();
    @NotNull
    private final EnergyType type;

    private FluxKey(@NotNull EnergyType type) {
        this.type = type;
    }

    @Nullable
    public static FluxKey of(EnergyType type) {
        if (type != null) {
            return new FluxKey(type);
        }
        return null;
    }

    public EnergyType getEnergyType() {
        return this.type;
    }

    public AEKeyType getType() {
        return FluxKeyType.TYPE;
    }

    public AEKey dropSecondary() {
        return this;
    }

    public CompoundTag toTag(HolderLookup.Provider registries) {
        RegistryOps ops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        return (CompoundTag)CODEC.encodeStart((DynamicOps)ops, (Object)this).getOrThrow();
    }

    public Object getPrimaryKey() {
        return this.type;
    }

    public ResourceLocation getId() {
        return this.type.id();
    }

    public void writeToPacket(RegistryFriendlyByteBuf data) {
        data.writeEnum((Enum)this.type);
    }

    public String getModId() {
        return this.type.from();
    }

    protected Component computeDisplayName() {
        return this.type.translate();
    }

    public void addDrops(long amount, List<ItemStack> drops, Level level, BlockPos pos) {
    }

    public boolean hasComponents() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FluxKey that = (FluxKey)((Object)o);
        return that.type == this.type;
    }

    public int hashCode() {
        return this.type.ordinal();
    }

    public String toString() {
        return "FluxKey{energy=" + this.type.name() + "}";
    }
}

