/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.mekae2.ae2;

import appeng.api.behaviors.GenericInternalInventory;
import appeng.api.config.Actionable;
import appeng.api.stacks.AEKey;
import me.ramidzkh.mekae2.ae2.MekanismKey;
import me.ramidzkh.mekae2.ae2.MekanismKeyType;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class GenericStackChemicalStorage
implements IChemicalHandler {
    private final GenericInternalInventory inv;

    public GenericStackChemicalStorage(GenericInternalInventory inv) {
        this.inv = inv;
    }

    public int getChemicalTanks() {
        return this.inv.size();
    }

    public ChemicalStack getChemicalInTank(int tank) {
        AEKey aEKey = this.inv.getKey(tank);
        if (aEKey instanceof MekanismKey) {
            MekanismKey what = (MekanismKey)aEKey;
            return what.withAmount(this.inv.getAmount(tank));
        }
        return ChemicalStack.EMPTY;
    }

    public void setChemicalInTank(int tank, ChemicalStack stack) {
        throw new UnsupportedOperationException();
    }

    public long getChemicalTankCapacity(int tank) {
        return this.inv.getCapacity(MekanismKeyType.TYPE);
    }

    public boolean isValid(int tank, ChemicalStack stack) {
        MekanismKey what = MekanismKey.of(stack);
        return what == null || this.inv.isAllowedIn(tank, (AEKey)what);
    }

    public ChemicalStack insertChemical(int tank, ChemicalStack stack, Action action) {
        MekanismKey what = MekanismKey.of(stack);
        if (what == null) {
            return stack;
        }
        long remainder = stack.getAmount() - this.inv.insert(tank, (AEKey)what, stack.getAmount(), Actionable.of((IFluidHandler.FluidAction)action.toFluidAction()));
        if (remainder == 0L) {
            return ChemicalStack.EMPTY;
        }
        return stack.copyWithAmount(remainder);
    }

    public ChemicalStack extractChemical(int tank, long amount, Action action) {
        AEKey aEKey = this.inv.getKey(tank);
        if (!(aEKey instanceof MekanismKey)) {
            return ChemicalStack.EMPTY;
        }
        MekanismKey what = (MekanismKey)aEKey;
        long extracted = this.inv.extract(tank, (AEKey)what, amount, Actionable.of((IFluidHandler.FluidAction)action.toFluidAction()));
        if (extracted == 0L) {
            return ChemicalStack.EMPTY;
        }
        return what.withAmount(extracted);
    }
}

