/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.mekae2.ae2;

import appeng.api.config.PowerUnit;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.parts.p2p.CapabilityP2PTunnelPart;
import appeng.parts.p2p.P2PModels;
import java.util.List;
import me.ramidzkh.mekae2.AppliedMekanistics;
import me.ramidzkh.mekae2.MekCapabilities;
import me.ramidzkh.mekae2.ae2.MekanismKeyType;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;

public class ChemicalP2PTunnelPart
extends CapabilityP2PTunnelPart<ChemicalP2PTunnelPart, IChemicalHandler> {
    private static final P2PModels MODELS = new P2PModels(AppliedMekanistics.id("part/chemical_p2p_tunnel"));
    private static final IChemicalHandler NULL_CHEMICAL_HANDLER = new NullChemicalHandler();

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public ChemicalP2PTunnelPart(IPartItem<?> partItem) {
        super(partItem, MekCapabilities.CHEMICAL.block());
        this.inputHandler = new InputChemicalHandler();
        this.outputHandler = new OutputChemicalHandler();
        this.emptyHandler = NULL_CHEMICAL_HANDLER;
    }

    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    private class InputChemicalHandler
    implements IChemicalHandler {
        private InputChemicalHandler() {
        }

        public int getChemicalTanks() {
            return 1;
        }

        public ChemicalStack getChemicalInTank(int tank) {
            return ChemicalStack.EMPTY;
        }

        public void setChemicalInTank(int tank, ChemicalStack stack) {
            throw new UnsupportedOperationException();
        }

        public long getChemicalTankCapacity(int tank) {
            return Integer.MAX_VALUE;
        }

        public boolean isValid(int tank, ChemicalStack stack) {
            return true;
        }

        public ChemicalStack insertChemical(int tank, ChemicalStack stack, Action action) {
            int outputTunnels = ChemicalP2PTunnelPart.this.getOutputs().size();
            long amount = stack.getAmount();
            if (outputTunnels == 0 || stack.isEmpty()) {
                return stack;
            }
            long amountPerOutput = amount / (long)outputTunnels;
            long overflow = amountPerOutput == 0L ? amount : amount % amountPerOutput;
            long total = 0L;
            for (ChemicalP2PTunnelPart target : ChemicalP2PTunnelPart.this.getOutputs()) {
                CapabilityP2PTunnelPart.CapabilityGuard capabilityGuard = target.getAdjacentCapability();
                try {
                    IChemicalHandler output = (IChemicalHandler)capabilityGuard.get();
                    long toSend = amountPerOutput + overflow;
                    overflow = output.insertChemical(stack.copyWithAmount(toSend), action).getAmount();
                    total += toSend - overflow;
                }
                finally {
                    if (capabilityGuard == null) continue;
                    capabilityGuard.close();
                }
            }
            if (action.execute()) {
                ChemicalP2PTunnelPart.this.queueTunnelDrain(PowerUnit.FE, (double)total / (double)MekanismKeyType.TYPE.getAmountPerOperation());
            }
            return stack.copyWithAmount(amount - total);
        }

        public ChemicalStack extractChemical(int tank, long amount, Action action) {
            return ChemicalStack.EMPTY;
        }
    }

    private class OutputChemicalHandler
    implements IChemicalHandler {
        private OutputChemicalHandler() {
        }

        public int getChemicalTanks() {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = ChemicalP2PTunnelPart.this.getInputCapability();){
                int n = ((IChemicalHandler)input.get()).getChemicalTanks();
                return n;
            }
        }

        public ChemicalStack getChemicalInTank(int tank) {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = ChemicalP2PTunnelPart.this.getInputCapability();){
                ChemicalStack chemicalStack = ((IChemicalHandler)input.get()).getChemicalInTank(tank);
                return chemicalStack;
            }
        }

        public void setChemicalInTank(int tank, ChemicalStack stack) {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = ChemicalP2PTunnelPart.this.getInputCapability();){
                ((IChemicalHandler)input.get()).setChemicalInTank(tank, stack);
            }
        }

        public long getChemicalTankCapacity(int tank) {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = ChemicalP2PTunnelPart.this.getInputCapability();){
                long l = ((IChemicalHandler)input.get()).getChemicalTankCapacity(tank);
                return l;
            }
        }

        public boolean isValid(int tank, ChemicalStack stack) {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = ChemicalP2PTunnelPart.this.getInputCapability();){
                boolean bl = ((IChemicalHandler)input.get()).isValid(tank, stack);
                return bl;
            }
        }

        public ChemicalStack insertChemical(int tank, ChemicalStack stack, Action action) {
            return stack;
        }

        public ChemicalStack extractChemical(int tank, long amount, Action action) {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = ChemicalP2PTunnelPart.this.getInputCapability();){
                ChemicalStack result = ((IChemicalHandler)input.get()).extractChemical(tank, amount, action);
                if (action.execute()) {
                    ChemicalP2PTunnelPart.this.queueTunnelDrain(PowerUnit.FE, (double)result.getAmount() / (double)MekanismKeyType.TYPE.getAmountPerOperation());
                }
                ChemicalStack chemicalStack = result;
                return chemicalStack;
            }
        }
    }

    private static class NullChemicalHandler
    implements IChemicalHandler {
        private NullChemicalHandler() {
        }

        public int getChemicalTanks() {
            return 0;
        }

        public ChemicalStack getChemicalInTank(int tank) {
            return ChemicalStack.EMPTY;
        }

        public void setChemicalInTank(int tank, ChemicalStack stack) {
            throw new UnsupportedOperationException();
        }

        public long getChemicalTankCapacity(int tank) {
            return 0L;
        }

        public boolean isValid(int tank, ChemicalStack stack) {
            return false;
        }

        public ChemicalStack insertChemical(int tank, ChemicalStack stack, Action action) {
            return stack;
        }

        public ChemicalStack extractChemical(int tank, long amount, Action action) {
            return ChemicalStack.EMPTY;
        }
    }
}

