/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_spawners.compat;

import dev.shadowsoffire.apothic_spawners.ApothicSpawners;
import dev.shadowsoffire.apothic_spawners.modifiers.SpawnerModifier;
import dev.shadowsoffire.apothic_spawners.modifiers.StatModifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class SpawnerCategory
implements IRecipeCategory<SpawnerModifier> {
    public static final ResourceLocation TEXTURES = ApothicSpawners.loc("textures/gui/spawner_jei.png");
    public static final ResourceLocation UID = ApothicSpawners.loc("spawner_modifiers");
    public static final RecipeType<SpawnerModifier> TYPE = RecipeType.create((String)"apothic_spawners", (String)"spawner_modifiers", SpawnerModifier.class);
    private IDrawable bg;
    private IDrawable icon;
    private Component title;

    public SpawnerCategory(IGuiHelper helper) {
        this.bg = helper.drawableBuilder(TEXTURES, 0, 0, 169, 75).build();
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Items.SPAWNER));
        this.title = ApothicSpawners.lang("title", "spawner", new Object[0]);
    }

    public RecipeType<SpawnerModifier> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.bg;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SpawnerModifier recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 11, 11).addIngredients(recipe.getMainhandInput());
        if (recipe.getOffhandInput() != Ingredient.EMPTY) {
            builder.addSlot(RecipeIngredientRole.INPUT, 11, 48).addIngredients(recipe.getOffhandInput());
        }
        builder.addInvisibleIngredients(RecipeIngredientRole.CATALYST).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Blocks.SPAWNER));
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Blocks.SPAWNER));
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    /*
     * Unable to fully structure code
     */
    public void draw(SpawnerModifier recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics gfx, double mouseX, double mouseY) {
        if (recipe.getOffhandInput() == Ingredient.EMPTY) {
            gfx.blit(SpawnerCategory.TEXTURES, 1, 31, 0, 0.0f, 88.0f, 28, 34, 256, 256);
        }
        scn = Minecraft.getInstance().screen;
        font = Minecraft.getInstance().font;
        if (scn == null) {
            return;
        }
        if (mouseX >= -1.0 && mouseX < 9.0 && mouseY >= 13.0 && mouseY < 25.0) {
            gfx.blit(SpawnerCategory.TEXTURES, -1, 13, 0, 0.0f, 75.0f, 10, 12, 256, 256);
            gfx.renderComponentTooltip(font, Arrays.asList(new Component[]{ApothicSpawners.lang("misc", "mainhand", new Object[0])}), (int)mouseX, (int)mouseY);
        } else if (mouseX >= -1.0 && mouseX < 9.0 && mouseY >= 50.0 && mouseY < 62.0 && recipe.getOffhandInput() != Ingredient.EMPTY) {
            gfx.blit(SpawnerCategory.TEXTURES, -1, 50, 0, 0.0f, 75.0f, 10, 12, 256, 256);
            text = new ArrayList<MutableComponent>();
            text.add(ApothicSpawners.lang("misc", "offhand", new Object[0]));
            if (!recipe.consumesOffhand()) {
                text.add(ApothicSpawners.lang("misc", "not_consumed", new Object[0]).withStyle(ChatFormatting.GRAY));
            }
            gfx.renderComponentTooltip(font, text, (int)mouseX, (int)mouseY);
        } else if (mouseX >= 33.0 && mouseX < 49.0 && mouseY >= 30.0 && mouseY < 46.0) {
            gfx.renderComponentTooltip(font, Arrays.asList(new Component[]{ApothicSpawners.lang("misc", "rclick_spawner", new Object[0])}), (int)mouseX, (int)mouseY);
        }
        mvStack = gfx.pose();
        mvStack.pushPose();
        mvStack.translate(0.0, 0.5, 0.0);
        gfx.renderFakeItem(new ItemStack((ItemLike)Items.SPAWNER), 31, 29);
        mvStack.popPose();
        v0 = recipe.getStatModifiers().size();
        Objects.requireNonNull(font);
        top = 37 - v0 * (9 + 2) / 2 + 2;
        left = 168;
        for (StatModifier<?> s : recipe.getStatModifiers()) {
            value = s.getFormattedValue();
            switch (1.$SwitchMap$dev$shadowsoffire$apothic_spawners$modifiers$StatModifier$Mode[s.mode().ordinal()]) {
                default: {
                    throw new MatchException(null, null);
                }
                case 1: {
                    if ("true".equals(value)) {
                        value = "+";
                    } else if ("false".equals(value)) {
                        value = "-";
                    } else {
                        var18_18 = s.value();
                        if (var18_18 instanceof Number && (num = (Number)var18_18).intValue() > 0) {
                            value = "+" + (String)value;
                        }
                    }
                    v1 = ApothicSpawners.lang("misc", "concat", new Object[]{value, s.stat().name()});
                    break;
                }
                case 2: {
                    v1 = s.value() instanceof Number != false ? ApothicSpawners.lang("misc", "value_concat", new Object[]{s.stat().name(), value}) : ("true".equals(value) != false ? ApothicSpawners.lang("misc", "on", new Object[]{s.stat().name()}) : ApothicSpawners.lang("misc", "off", new Object[]{s.stat().name()}));
                }
            }
            msg = v1;
            width = font.width((FormattedText)msg);
            if (!(mouseX >= (double)(left - width)) || !(mouseX < (double)left) || !(mouseY >= (double)top)) ** GOTO lbl-1000
            Objects.requireNonNull(font);
            if (mouseY < (double)(top + 9 + 1)) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            hover = v2;
            gfx.drawString(font, (Component)msg, left - font.width((FormattedText)msg), top, hover != false ? 0x8080FF : 0x333333, false);
            maxWidth = Minecraft.getInstance().getWindow().getGuiScaledWidth();
            maxWidth = maxWidth - (maxWidth - 210) / 2 - 210;
            if (hover) {
                list = new ArrayList<Component>();
                list.add((Component)s.stat().name().withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.UNDERLINE}));
                list.add((Component)s.stat().desc().withStyle(ChatFormatting.GRAY));
                if (s.value() instanceof Number && s.mode() == StatModifier.Mode.ADD) {
                    n = s;
                    if (s.min().isPresent() || s.max().isPresent()) {
                        list.add((Component)Component.literal((String)" "));
                    }
                    if (s.min().isPresent()) {
                        list.add((Component)ApothicSpawners.lang("misc", "min_value", new Object[]{n.stat().formatValue((Number)n.min().get())}).withStyle(ChatFormatting.GRAY));
                    }
                    if (s.max().isPresent()) {
                        list.add((Component)ApothicSpawners.lang("misc", "max_value", new Object[]{n.stat().formatValue((Number)n.max().get())}).withStyle(ChatFormatting.GRAY));
                    }
                }
                SpawnerCategory.renderComponentTooltip(scn, gfx, list, left + 6, (int)mouseY, maxWidth, font);
            }
            Objects.requireNonNull(font);
            top += 9 + 2;
        }
    }

    private static void renderComponentTooltip(Screen scn, GuiGraphics gfx, List<Component> list, int x, int y, int maxWidth, Font font) {
        List text = list.stream().map(c -> font.getSplitter().splitLines((FormattedText)c, maxWidth, c.getStyle())).flatMap(Collection::stream).toList();
        gfx.renderComponentTooltip(font, text, x, y, ItemStack.EMPTY);
    }
}

