/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting;

import dev.shadowsoffire.apothic_attributes.repack.evalex.Expression;
import io.netty.buffer.ByteBuf;
import java.math.BigDecimal;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.enchantment.Enchantment;

public sealed interface PowerFunction {
    public static final StreamCodec<RegistryFriendlyByteBuf, PowerFunction> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, PowerFunction>(){

        public PowerFunction decode(RegistryFriendlyByteBuf buf) {
            Type type = Type.values()[buf.readByte()];
            return switch (type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> (DefaultMinPowerFunction)DefaultMinPowerFunction.STREAM_CODEC.decode((Object)buf);
                case 1 -> DefaultMaxPowerFunction.INSTANCE;
                case 2 -> (ExpressionPowerFunction)ExpressionPowerFunction.STREAM_CODEC.decode((Object)buf);
            };
        }

        public void encode(RegistryFriendlyByteBuf buf, PowerFunction value) {
            Type type = value.getType();
            buf.writeByte(type.ordinal());
            switch (type.ordinal()) {
                case 0: {
                    DefaultMinPowerFunction.STREAM_CODEC.encode((Object)buf, (Object)((DefaultMinPowerFunction)value));
                    break;
                }
                case 2: {
                    ExpressionPowerFunction.STREAM_CODEC.encode((Object)buf, (Object)((ExpressionPowerFunction)value));
                    break;
                }
            }
        }
    };

    public int getPower(int var1);

    public Type getType();

    public static final class ExpressionPowerFunction
    implements PowerFunction {
        public static final StreamCodec<ByteBuf, ExpressionPowerFunction> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(ExpressionPowerFunction::new, ExpressionPowerFunction::exprString);
        private final String exprString;
        private final transient Expression ex;

        public ExpressionPowerFunction(String func) {
            this.exprString = func;
            this.ex = new Expression(func);
        }

        @Override
        public int getPower(int level) {
            return this.ex.setVariable("x", new BigDecimal(level)).eval().intValue();
        }

        @Override
        public Type getType() {
            return Type.EXPRESSION;
        }

        public String exprString() {
            return this.exprString;
        }
    }

    public static final class DefaultMaxPowerFunction
    implements PowerFunction {
        public static final DefaultMaxPowerFunction INSTANCE = new DefaultMaxPowerFunction();

        @Override
        public int getPower(int level) {
            return 200;
        }

        @Override
        public Type getType() {
            return Type.DEFAULT_MAX;
        }
    }

    public record DefaultMinPowerFunction(Holder<Enchantment> enchHolder) implements PowerFunction
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, DefaultMinPowerFunction> STREAM_CODEC = Enchantment.STREAM_CODEC.map(DefaultMinPowerFunction::new, DefaultMinPowerFunction::enchHolder);

        @Override
        public int getPower(int level) {
            Enchantment ench = (Enchantment)this.enchHolder.value();
            if (level > ench.definition().maxLevel() && level > 1) {
                int diff = ench.getMinCost(ench.getMaxLevel()) - ench.getMinCost(ench.getMaxLevel() - 1);
                if (diff == 0) {
                    diff = 15;
                }
                return ench.getMinCost(level) + diff * (int)Math.pow(level - ench.getMaxLevel(), 1.6);
            }
            return ench.getMinCost(level);
        }

        @Override
        public Type getType() {
            return Type.DEFAULT_MIN;
        }
    }

    public static enum Type {
        DEFAULT_MIN,
        DEFAULT_MAX,
        EXPRESSION;

    }
}

