/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import dev.shadowsoffire.apothic_enchanting.ApothicEnchanting;
import dev.shadowsoffire.apothic_enchanting.advancements.EnchantedTrigger;
import dev.shadowsoffire.apothic_enchanting.enchantments.components.BerserkingComponent;
import dev.shadowsoffire.apothic_enchanting.enchantments.components.BoonComponent;
import dev.shadowsoffire.apothic_enchanting.enchantments.components.ReflectiveComponent;
import dev.shadowsoffire.apothic_enchanting.enchantments.entity_effects.ReboundingEffect;
import dev.shadowsoffire.apothic_enchanting.enchantments.values.ExponentialLevelBasedValue;
import dev.shadowsoffire.apothic_enchanting.library.EnchLibraryBlock;
import dev.shadowsoffire.apothic_enchanting.library.EnchLibraryContainer;
import dev.shadowsoffire.apothic_enchanting.library.EnchLibraryTile;
import dev.shadowsoffire.apothic_enchanting.objects.EnderLeadItem;
import dev.shadowsoffire.apothic_enchanting.objects.ExtractionTomeItem;
import dev.shadowsoffire.apothic_enchanting.objects.FilteringShelfBlock;
import dev.shadowsoffire.apothic_enchanting.objects.GeodeShelfBlock;
import dev.shadowsoffire.apothic_enchanting.objects.GlowyBlockItem;
import dev.shadowsoffire.apothic_enchanting.objects.ImprovedScrappingTomeItem;
import dev.shadowsoffire.apothic_enchanting.objects.ScrappingTomeItem;
import dev.shadowsoffire.apothic_enchanting.objects.TomeItem;
import dev.shadowsoffire.apothic_enchanting.objects.TreasureShelfBlock;
import dev.shadowsoffire.apothic_enchanting.objects.TypedShelfBlock;
import dev.shadowsoffire.apothic_enchanting.objects.WardenLootModifier;
import dev.shadowsoffire.apothic_enchanting.table.ApothEnchantmentMenu;
import dev.shadowsoffire.apothic_enchanting.table.EnchantmentTableItemHandler;
import dev.shadowsoffire.apothic_enchanting.table.infusion.InfusionRecipe;
import dev.shadowsoffire.apothic_enchanting.table.infusion.KeepNBTInfusionRecipe;
import dev.shadowsoffire.apothic_enchanting.util.MiscUtil;
import dev.shadowsoffire.apothic_enchanting.util.TooltipUtil;
import dev.shadowsoffire.placebo.color.GradientColor;
import dev.shadowsoffire.placebo.registry.DeferredHelper;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class Ench {
    private static final DeferredHelper R = DeferredHelper.create((String)"apothic_enchanting");

    public static void bootstrap(IEventBus bus) {
        Blocks.bootstrap();
        Items.bootstrap();
        EnchantEffects.bootstrap();
        Tabs.bootstrap();
        Tiles.bootstrap();
        Particles.bootstrap();
        Menus.bootstrap();
        RecipeTypes.bootstrap();
        Components.bootstrap();
        Triggers.bootstrap();
        bus.register((Object)R);
    }

    static {
        R.recipeSerializer("infusion", () -> InfusionRecipe.SERIALIZER);
        R.recipeSerializer("keep_nbt_infusion", () -> KeepNBTInfusionRecipe.SERIALIZER);
        R.custom("warden_tendril", NeoForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, WardenLootModifier.CODEC);
        R.custom("enchantment_table_item_handler", NeoForgeRegistries.Keys.ATTACHMENT_TYPES, EnchantmentTableItemHandler.TYPE);
        R.custom("rebounding", Registries.ENCHANTMENT_ENTITY_EFFECT_TYPE, ReboundingEffect.CODEC);
        R.custom("exponential", Registries.ENCHANTMENT_LEVEL_BASED_VALUE_TYPE, ExponentialLevelBasedValue.CODEC);
    }

    public static final class Blocks {
        public static final Holder<Block> BEESHELF = Blocks.woodShelf("beeshelf", MapColor.COLOR_YELLOW, 0.75f, (ParticleOptions)ParticleTypes.ENCHANT);
        public static final Holder<Block> BLAZING_HELLSHELF = Blocks.stoneShelf("blazing_hellshelf", MapColor.COLOR_BLACK, 1.5f, (ParticleOptions)Particles.ENCHANT_FIRE);
        public static final Holder<Block> CRYSTAL_SEASHELF = Blocks.stoneShelf("crystal_seashelf", MapColor.COLOR_CYAN, 1.5f, (ParticleOptions)Particles.ENCHANT_WATER);
        public static final Holder<Block> DEEPSHELF = Blocks.stoneShelf("deepshelf", MapColor.COLOR_BLACK, 2.5f, (ParticleOptions)Particles.ENCHANT_SCULK);
        public static final Holder<Block> DORMANT_DEEPSHELF = Blocks.stoneShelf("dormant_deepshelf", MapColor.COLOR_BLACK, 2.5f, (ParticleOptions)Particles.ENCHANT_SCULK);
        public static final Holder<Block> DRACONIC_ENDSHELF = Blocks.stoneShelf("draconic_endshelf", MapColor.SAND, 5.0f, (ParticleOptions)Particles.ENCHANT_END);
        public static final Holder<Block> ECHOING_DEEPSHELF = Blocks.stoneShelf("echoing_deepshelf", MapColor.COLOR_BLACK, 2.5f, (ParticleOptions)Particles.ENCHANT_SCULK);
        public static final Holder<Block> ECHOING_SCULKSHELF = Blocks.sculkShelf("echoing_sculkshelf");
        public static final Holder<Block> ENDER_LIBRARY = R.block("ender_library", () -> new EnchLibraryBlock((BlockEntityType.BlockEntitySupplier<? extends EnchLibraryTile>)((BlockEntityType.BlockEntitySupplier)EnchLibraryTile.EnderLibraryTile::new), 31));
        public static final Holder<Block> ENDSHELF = Blocks.stoneShelf("endshelf", MapColor.SAND, 4.5f, (ParticleOptions)Particles.ENCHANT_END);
        public static final Holder<Block> FILTERING_SHELF = R.block("filtering_shelf", FilteringShelfBlock::new, p -> p.mapColor(MapColor.COLOR_CYAN).sound(SoundType.STONE).strength(1.75f).requiresCorrectToolForDrops());
        public static final Holder<Block> GEODE_SHELF = R.block("geode_shelf", GeodeShelfBlock::new, p -> p.mapColor(MapColor.TERRACOTTA_WHITE).sound(SoundType.STONE).strength(1.75f).requiresCorrectToolForDrops());
        public static final Holder<Block> GLOWING_HELLSHELF = Blocks.stoneShelf("glowing_hellshelf", MapColor.COLOR_BLACK, 1.5f, (ParticleOptions)Particles.ENCHANT_FIRE);
        public static final Holder<Block> HEART_SEASHELF = Blocks.stoneShelf("heart_seashelf", MapColor.COLOR_CYAN, 1.5f, (ParticleOptions)Particles.ENCHANT_WATER);
        public static final Holder<Block> HELLSHELF = Blocks.stoneShelf("hellshelf", MapColor.COLOR_BLACK, 1.5f, (ParticleOptions)Particles.ENCHANT_FIRE);
        public static final Holder<Block> INFUSED_HELLSHELF = Blocks.stoneShelf("infused_hellshelf", MapColor.COLOR_BLACK, 1.5f, (ParticleOptions)Particles.ENCHANT_FIRE);
        public static final Holder<Block> INFUSED_SEASHELF = Blocks.stoneShelf("infused_seashelf", MapColor.COLOR_CYAN, 1.5f, (ParticleOptions)Particles.ENCHANT_WATER);
        public static final Holder<Block> LIBRARY = R.block("library", () -> new EnchLibraryBlock((BlockEntityType.BlockEntitySupplier<? extends EnchLibraryTile>)((BlockEntityType.BlockEntitySupplier)EnchLibraryTile.BasicLibraryTile::new), 16));
        public static final Holder<Block> MELONSHELF = Blocks.woodShelf("melonshelf", MapColor.COLOR_GREEN, 0.75f, (ParticleOptions)ParticleTypes.ENCHANT);
        public static final Holder<Block> PEARL_ENDSHELF = Blocks.stoneShelf("pearl_endshelf", MapColor.SAND, 4.5f, (ParticleOptions)Particles.ENCHANT_END);
        public static final Holder<Block> SEASHELF = Blocks.stoneShelf("seashelf", MapColor.COLOR_CYAN, 1.5f, (ParticleOptions)Particles.ENCHANT_WATER);
        public static final Holder<Block> SIGHTSHELF = Blocks.stoneShelf("sightshelf", MapColor.COLOR_BLACK, 1.5f, (ParticleOptions)Particles.ENCHANT_FIRE);
        public static final Holder<Block> SIGHTSHELF_T2 = Blocks.stoneShelf("sightshelf_t2", MapColor.COLOR_BLACK, 1.5f, (ParticleOptions)Particles.ENCHANT_FIRE);
        public static final Holder<Block> SOUL_TOUCHED_DEEPSHELF = Blocks.stoneShelf("soul_touched_deepshelf", MapColor.COLOR_BLACK, 2.5f, (ParticleOptions)Particles.ENCHANT_SCULK);
        public static final Holder<Block> SOUL_TOUCHED_SCULKSHELF = Blocks.sculkShelf("soul_touched_sculkshelf");
        public static final Holder<Block> STONESHELF = Blocks.stoneShelf("stoneshelf", MapColor.STONE, 1.75f, (ParticleOptions)ParticleTypes.ENCHANT);
        public static final Holder<Block> TREASURE_SHELF = R.block("treasure_shelf", TreasureShelfBlock::new, p -> p.mapColor(MapColor.COLOR_BLACK).sound(SoundType.STONE).strength(1.75f).requiresCorrectToolForDrops());

        private static void bootstrap() {
        }

        private static Holder<Block> sculkShelf(String id) {
            return R.block(id, () -> new TypedShelfBlock.SculkShelfBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).sound(SoundType.STONE).randomTicks().requiresCorrectToolForDrops().strength(3.5f), (ParticleOptions)Particles.ENCHANT_SCULK));
        }

        private static Holder<Block> stoneShelf(String id, MapColor color, float strength, ParticleOptions particle) {
            return R.block(id, () -> new TypedShelfBlock(BlockBehaviour.Properties.of().requiresCorrectToolForDrops().sound(SoundType.STONE).mapColor(color).strength(strength), particle));
        }

        private static Holder<Block> woodShelf(String id, MapColor color, float strength, ParticleOptions particle) {
            return R.block(id, () -> new TypedShelfBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).mapColor(color).strength(strength), particle));
        }
    }

    public static class Items
    extends net.minecraft.world.item.Items {
        public static final Holder<Item> BEESHELF = R.item("beeshelf", () -> new BlockItem((Block)Blocks.BEESHELF.value(), new Item.Properties()));
        public static final Holder<Item> BLAZING_HELLSHELF = R.item("blazing_hellshelf", () -> new BlockItem((Block)Blocks.BLAZING_HELLSHELF.value(), new Item.Properties()));
        public static final Holder<Item> BOOTS_TOME = R.item("boots_tome", () -> new TomeItem(DIAMOND_BOOTS));
        public static final Holder<Item> BOW_TOME = R.item("bow_tome", () -> new TomeItem(BOW));
        public static final Holder<Item> CHESTPLATE_TOME = R.item("chestplate_tome", () -> new TomeItem(DIAMOND_CHESTPLATE));
        public static final Holder<Item> CRYSTAL_SEASHELF = R.blockItem("crystal_seashelf", Blocks.CRYSTAL_SEASHELF);
        public static final Holder<Item> DEEPSHELF = R.blockItem("deepshelf", Blocks.DEEPSHELF, GlowyBlockItem::new, UnaryOperator.identity());
        public static final Holder<Item> DORMANT_DEEPSHELF = R.blockItem("dormant_deepshelf", Blocks.DORMANT_DEEPSHELF);
        public static final Holder<Item> DRACONIC_ENDSHELF = R.blockItem("draconic_endshelf", Blocks.DRACONIC_ENDSHELF);
        public static final Holder<Item> ECHOING_DEEPSHELF = R.blockItem("echoing_deepshelf", Blocks.ECHOING_DEEPSHELF);
        public static final Holder<Item> ECHOING_SCULKSHELF = R.blockItem("echoing_sculkshelf", Blocks.ECHOING_SCULKSHELF);
        public static final Holder<Item> ENDER_LIBRARY = R.blockItem("ender_library", Blocks.ENDER_LIBRARY);
        public static final Holder<Item> ENDSHELF = R.blockItem("endshelf", Blocks.ENDSHELF);
        public static final Holder<Item> EXTRACTION_TOME = R.item("extraction_tome", ExtractionTomeItem::new, p -> p.rarity(Rarity.EPIC));
        public static final Holder<Item> FILTERING_SHELF = R.blockItem("filtering_shelf", Blocks.FILTERING_SHELF, p -> p.rarity(Rarity.UNCOMMON));
        public static final Holder<Item> FISHING_TOME = R.item("fishing_tome", () -> new TomeItem(FISHING_ROD));
        public static final Holder<Item> GEODE_SHELF = R.blockItem("geode_shelf", Blocks.GEODE_SHELF, p -> p.rarity(Rarity.UNCOMMON));
        public static final Holder<Item> GLOWING_HELLSHELF = R.blockItem("glowing_hellshelf", Blocks.GLOWING_HELLSHELF);
        public static final Holder<Item> HEART_SEASHELF = R.blockItem("heart_seashelf", Blocks.HEART_SEASHELF);
        public static final Holder<Item> HELLSHELF = R.blockItem("hellshelf", Blocks.HELLSHELF);
        public static final Holder<Item> HELMET_TOME = R.item("helmet_tome", () -> new TomeItem(DIAMOND_HELMET));
        public static final Holder<Item> IMPROVED_SCRAP_TOME = R.item("improved_scrap_tome", ImprovedScrappingTomeItem::new, p -> p.rarity(Rarity.RARE));
        public static final Holder<Item> INERT_TRIDENT = R.item("inert_trident", () -> new Item(new Item.Properties().stacksTo(1)));
        public static final Holder<Item> INFUSED_BREATH = R.item("infused_breath", () -> new Item(new Item.Properties().rarity(Rarity.EPIC)));
        public static final Holder<Item> INFUSED_HELLSHELF = R.blockItem("infused_hellshelf", Blocks.INFUSED_HELLSHELF, GlowyBlockItem::new, UnaryOperator.identity());
        public static final Holder<Item> INFUSED_SEASHELF = R.blockItem("infused_seashelf", Blocks.INFUSED_SEASHELF, GlowyBlockItem::new, UnaryOperator.identity());
        public static final Holder<Item> LEGGINGS_TOME = R.item("leggings_tome", () -> new TomeItem(net.minecraft.world.item.Items.DIAMOND_LEGGINGS));
        public static final Holder<Item> LIBRARY = R.blockItem("library", Blocks.LIBRARY);
        public static final Holder<Item> MELONSHELF = R.blockItem("melonshelf", Blocks.MELONSHELF);
        public static final Holder<Item> OTHER_TOME = R.item("other_tome", () -> new TomeItem(net.minecraft.world.item.Items.AIR));
        public static final Holder<Item> PEARL_ENDSHELF = R.blockItem("pearl_endshelf", Blocks.PEARL_ENDSHELF);
        public static final Holder<Item> PICKAXE_TOME = R.item("pickaxe_tome", () -> new TomeItem(net.minecraft.world.item.Items.DIAMOND_PICKAXE));
        public static final Holder<Item> PRISMATIC_WEB = R.item("prismatic_web", () -> new Item(new Item.Properties()));
        public static final Holder<Item> SCRAP_TOME = R.item("scrap_tome", () -> new ScrappingTomeItem(new Item.Properties().rarity(Rarity.UNCOMMON)));
        public static final Holder<Item> SEASHELF = R.blockItem("seashelf", Blocks.SEASHELF);
        public static final Holder<Item> SIGHTSHELF = R.blockItem("sightshelf", Blocks.SIGHTSHELF, p -> p.rarity(Rarity.UNCOMMON));
        public static final Holder<Item> SIGHTSHELF_T2 = R.blockItem("sightshelf_t2", Blocks.SIGHTSHELF_T2, p -> p.rarity(Rarity.UNCOMMON));
        public static final Holder<Item> SOUL_TOUCHED_DEEPSHELF = R.blockItem("soul_touched_deepshelf", Blocks.SOUL_TOUCHED_DEEPSHELF);
        public static final Holder<Item> SOUL_TOUCHED_SCULKSHELF = R.blockItem("soul_touched_sculkshelf", Blocks.SOUL_TOUCHED_SCULKSHELF);
        public static final Holder<Item> STONESHELF = R.blockItem("stoneshelf", Blocks.STONESHELF);
        public static final Holder<Item> TREASURE_SHELF = R.blockItem("treasure_shelf", Blocks.TREASURE_SHELF, p -> p.rarity(Rarity.UNCOMMON));
        public static final Holder<Item> WARDEN_TENDRIL = R.item("warden_tendril", () -> new Item(new Item.Properties()));
        public static final Holder<Item> WEAPON_TOME = R.item("weapon_tome", () -> new TomeItem(net.minecraft.world.item.Items.DIAMOND_SWORD));
        public static final Holder<Item> FLIMSY_ENDER_LEAD = R.item("flimsy_ender_lead", p -> new EnderLeadItem((Item.Properties)p, EnderLeadItem.Type.FLIMSY), p -> p.stacksTo(1).durability(8));
        public static final Holder<Item> ENDER_LEAD = R.item("ender_lead", p -> new EnderLeadItem((Item.Properties)p, EnderLeadItem.Type.NORMAL), p -> p.stacksTo(1).durability(64));
        public static final Holder<Item> OCCULT_ENDER_LEAD = R.item("occult_ender_lead", p -> new EnderLeadItem((Item.Properties)p, EnderLeadItem.Type.REINFORCED), p -> p.stacksTo(1).durability(1024).component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)));

        private static void bootstrap() {
        }
    }

    public static class EnchantEffects {
        public static final DataComponentType<BerserkingComponent> BERSERKING = R.enchantmentEffect("berserking", b -> b.persistent(BerserkingComponent.CODEC));
        public static final DataComponentType<LevelBasedValue> BONEMEAL_CROPS = R.enchantmentEffect("bonemeal_crops", b -> b.persistent(LevelBasedValue.CODEC));
        public static final DataComponentType<Unit> CHAINSAW = R.enchantmentEffect("chainsaw", b -> b.persistent(Unit.CODEC));
        public static final DataComponentType<Unit> CHROMATIC = R.enchantmentEffect("chromatic", b -> b.persistent(Unit.CODEC));
        public static final DataComponentType<List<ConditionalEffect<EnchantmentValueEffect>>> CRESCENDO = R.enchantmentEffect("crescendo", b -> b.persistent(ConditionalEffect.codec((Codec)EnchantmentValueEffect.CODEC, (LootContextParamSet)LootContextParamSets.ENCHANTED_ITEM).listOf()));
        public static final DataComponentType<List<ConditionalEffect<EnchantmentValueEffect>>> DROPS_TO_XP = R.enchantmentEffect("drops_to_xp", b -> b.persistent(ConditionalEffect.codec((Codec)EnchantmentValueEffect.CODEC, (LootContextParamSet)LootContextParamSets.ENCHANTED_ITEM).listOf()));
        public static final DataComponentType<BoonComponent> EARTHS_BOON = R.enchantmentEffect("earths_boon", b -> b.persistent(BoonComponent.CODEC));
        public static final DataComponentType<Unit> EXPLOITATION = R.enchantmentEffect("exploitation", b -> b.persistent(Unit.CODEC));
        public static final DataComponentType<List<ConditionalEffect<EnchantmentValueEffect>>> EXTRA_LOOT_ROLL = R.enchantmentEffect("extra_loot_roll", b -> b.persistent(ConditionalEffect.codec((Codec)EnchantmentValueEffect.CODEC, (LootContextParamSet)LootContextParamSets.ENCHANTED_DAMAGE).listOf()));
        public static final DataComponentType<Float> GROWTH_SERUM = R.enchantmentEffect("growth_serum", b -> b.persistent(Codec.floatRange((float)0.001f, (float)1.0f)));
        public static final DataComponentType<LevelBasedValue> MINERS_FERVOR = R.enchantmentEffect("miners_fervor", b -> b.persistent(LevelBasedValue.CODEC));
        public static final DataComponentType<ReflectiveComponent> REFLECTIVE = R.enchantmentEffect("reflective", b -> b.persistent(ReflectiveComponent.CODEC));
        public static final DataComponentType<List<ConditionalEffect<EnchantmentValueEffect>>> REPAIR_WITH_HP = R.enchantmentEffect("repair_with_hp", b -> b.persistent(ConditionalEffect.codec((Codec)EnchantmentValueEffect.CODEC, (LootContextParamSet)LootContextParamSets.ENCHANTED_ITEM).listOf()));
        public static final DataComponentType<Unit> STABLE_FOOTING = R.enchantmentEffect("stable_footing", b -> b.persistent(Unit.CODEC));
        public static final DataComponentType<Unit> TEMPTING = R.enchantmentEffect("tempting", b -> b.persistent(Unit.CODEC));

        private static void bootstrap() {
        }
    }

    public static class Tabs {
        public static final Holder<CreativeModeTab> ENCH = R.creativeTab("ench", b -> b.title((Component)TooltipUtil.lang("creative_tab", "all", new Object[0])).icon(() -> ((Item)Items.HELLSHELF.value()).getDefaultInstance()));

        private static void bootstrap() {
        }
    }

    public static class Tiles {
        public static final Supplier<BlockEntityType<EnchLibraryTile.EnderLibraryTile>> ENDER_LIBRARY = R.blockEntity("ender_library", EnchLibraryTile.EnderLibraryTile::new, () -> ImmutableSet.of((Object)((Block)Blocks.ENDER_LIBRARY.value())));
        public static final Supplier<BlockEntityType<FilteringShelfBlock.FilteringShelfTile>> FILTERING_SHELF = R.blockEntity("filtering_shelf", FilteringShelfBlock.FilteringShelfTile::new, () -> ImmutableSet.of((Object)((Block)Blocks.FILTERING_SHELF.value())));
        public static final Supplier<BlockEntityType<EnchLibraryTile.BasicLibraryTile>> LIBRARY = R.blockEntity("library", EnchLibraryTile.BasicLibraryTile::new, () -> ImmutableSet.of((Object)((Block)Blocks.LIBRARY.value())));

        private static void bootstrap() {
        }
    }

    public static class Particles {
        public static final SimpleParticleType ENCHANT_END = R.simpleParticle("enchant_end", false);
        public static final SimpleParticleType ENCHANT_FIRE = R.simpleParticle("enchant_fire", false);
        public static final SimpleParticleType ENCHANT_SCULK = R.simpleParticle("enchant_sculk", false);
        public static final SimpleParticleType ENCHANT_WATER = R.simpleParticle("enchant_water", false);

        private static void bootstrap() {
        }
    }

    public static class Menus {
        public static final MenuType<ApothEnchantmentMenu> ENCHANTING_TABLE = R.menu("enchanting_table", ApothEnchantmentMenu::new);
        public static final MenuType<EnchLibraryContainer> LIBRARY = R.menuWithPos("library", EnchLibraryContainer::new);

        private static void bootstrap() {
        }
    }

    public static class RecipeTypes {
        public static final RecipeType<InfusionRecipe> INFUSION = R.recipe("infusion");

        private static void bootstrap() {
        }
    }

    public static class Components {
        public static final DataComponentType<ChargedProjectiles> CRESCENDO_PROJECTILES = R.component("crescendo_projectiles", b -> b.persistent(ChargedProjectiles.CODEC).networkSynchronized(ChargedProjectiles.STREAM_CODEC).cacheEncoding());
        public static final DataComponentType<Integer> CRESCENDO_SHOTS = R.component("crescendo_shots", b -> b.persistent(Codec.intRange((int)1, (int)1024)).networkSynchronized(ByteBufCodecs.VAR_INT));
        public static final DataComponentType<EntityType<?>> LEASHED_ENTITY_TYPE = R.component("leashed_entity_type", b -> b.persistent(BuiltInRegistries.ENTITY_TYPE.byNameCodec()).networkSynchronized(ByteBufCodecs.registry((ResourceKey)Registries.ENTITY_TYPE)));
        public static final DataComponentType<Component> LEASHED_ENTITY_NAME = R.component("leashed_entity_name", b -> b.persistent(ComponentSerialization.FLAT_CODEC).networkSynchronized(ComponentSerialization.STREAM_CODEC).cacheEncoding());

        private static void bootstrap() {
        }
    }

    public static class Triggers {
        public static final EnchantedTrigger ENCHANTED = (EnchantedTrigger)R.criteriaTrigger("enchanted", (CriterionTrigger)new EnchantedTrigger());

        private static void bootstrap() {
        }
    }

    public static class LootTables {
        public static final ResourceKey<LootTable> BOON_STONE_DROPS = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ApothicEnchanting.loc("boon_stone_drops"));
        public static final ResourceKey<LootTable> BOON_DEEPSLATE_DROPS = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ApothicEnchanting.loc("boon_deepslate_drops"));
        public static final ResourceKey<LootTable> BOON_NETHER_DROPS = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ApothicEnchanting.loc("boon_netherrack_drops"));
    }

    public static final class Tags {
        public static final TagKey<Item> SPEARFISHING_DROPS = ItemTags.create((ResourceLocation)ApothicEnchanting.loc("spearfishing_drops"));
        public static final TagKey<Item> CANNOT_BE_CONVERTED_TO_XP = ItemTags.create((ResourceLocation)ApothicEnchanting.loc("cannot_be_converted_to_xp"));
        public static final TagKey<EntityType<?>> BLACKLISTED_FROM_SPAWNERS = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"apothic_spawners", (String)"blacklisted_from_spawners"));
    }

    public static final class Enchantments {
        public static final ResourceKey<Enchantment> BERSERKERS_FURY = Enchantments.key("berserkers_fury");
        public static final ResourceKey<Enchantment> BOON_OF_THE_EARTH = Enchantments.key("boon_of_the_earth");
        public static final ResourceKey<Enchantment> CHAINSAW = Enchantments.key("chainsaw");
        public static final ResourceKey<Enchantment> CHROMATIC = Enchantments.key("chromatic");
        public static final ResourceKey<Enchantment> CRESCENDO_OF_BOLTS = Enchantments.key("crescendo_of_bolts");
        public static final ResourceKey<Enchantment> ENDLESS_QUIVER = Enchantments.key("endless_quiver");
        public static final ResourceKey<Enchantment> GROWTH_SERUM = Enchantments.key("growth_serum");
        public static final ResourceKey<Enchantment> ICY_THORNS = Enchantments.key("icy_thorns");
        public static final ResourceKey<Enchantment> INFUSION = Enchantments.key("infusion");
        public static final ResourceKey<Enchantment> KNOWLEDGE_OF_THE_AGES = Enchantments.key("knowledge_of_the_ages");
        public static final ResourceKey<Enchantment> LIFE_MENDING = Enchantments.key("life_mending");
        public static final ResourceKey<Enchantment> MINERS_FERVOR = Enchantments.key("miners_fervor");
        public static final ResourceKey<Enchantment> NATURES_BLESSING = Enchantments.key("natures_blessing");
        public static final ResourceKey<Enchantment> REBOUNDING = Enchantments.key("rebounding");
        public static final ResourceKey<Enchantment> REFLECTIVE_DEFENSES = Enchantments.key("reflective_defenses");
        public static final ResourceKey<Enchantment> SCAVENGER = Enchantments.key("scavenger");
        public static final ResourceKey<Enchantment> SHIELD_BASH = Enchantments.key("shield_bash");
        public static final ResourceKey<Enchantment> STABLE_FOOTING = Enchantments.key("stable_footing");
        public static final ResourceKey<Enchantment> TEMPTING = Enchantments.key("tempting");
        public static final ResourceKey<Enchantment> WORKER_EXPLOITATION = Enchantments.key("worker_exploitation");

        private static ResourceKey<Enchantment> key(String name) {
            return ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ApothicEnchanting.loc(name));
        }
    }

    public static final class DamageTypes {
        public static final ResourceKey<DamageType> CORRUPTED = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ApothicEnchanting.loc("corrupted"));
    }

    public static class Colors {
        private static int[] _LIGHT_BLUE_FLASH = new int[]{46079, 46079, 46079, 46079, 46079, 46079, 46079, 46079, 46079, 46079, 46079, 46079, 46079, 46079, 46079, 46079, 46079, 46079, 46079, 46079, 46079, 46079, 46079, 46079, 46079, 46079, 46079, 46079, 46079, 46079, 46079, 46079, 46079, 46079, 46079, 767487, 1554687, 0x22BBFF, 2997759, 3784959, 4506623, 5228287, 6015487, 0x66CCFF};
        public static GradientColor LIGHT_BLUE_FLASH = new GradientColor(MiscUtil.doubleUpGradient(_LIGHT_BLUE_FLASH), "light_blue_flash");
    }
}

