/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.tiers.augments;

import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.apotheosis.tiers.augments.AttributeAugment;
import dev.shadowsoffire.apotheosis.tiers.augments.TierAugment;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TierAugmentRegistry
extends DynamicRegistry<TierAugment> {
    public static TierAugmentRegistry INSTANCE = new TierAugmentRegistry();
    protected Map<Key, List<TierAugment>> augmentsPerTier = new HashMap<Key, List<TierAugment>>();

    private TierAugmentRegistry() {
        super(Apotheosis.LOGGER, "tier_augments", true, true);
    }

    protected void registerBuiltinCodecs() {
        this.registerCodec(Apotheosis.loc("attribute"), AttributeAugment.CODEC);
    }

    protected void beginReload() {
        super.beginReload();
        this.augmentsPerTier.clear();
    }

    protected void onReload() {
        super.onReload();
        for (TierAugment tierAugment : this.registry.values()) {
            this.augmentsPerTier.computeIfAbsent(new Key(tierAugment.tier(), tierAugment.target()), t -> new ArrayList()).add(tierAugment);
        }
        for (List list : this.augmentsPerTier.values()) {
            list.sort(Comparator.comparing(TierAugment::sortIndex));
        }
    }

    public static List<TierAugment> getAugments(WorldTier tier, TierAugment.Target target) {
        Key key = new Key(tier, target);
        return Collections.unmodifiableList(TierAugmentRegistry.INSTANCE.augmentsPerTier.getOrDefault(key, List.of()));
    }

    private record Key(WorldTier tier, TierAugment.Target target) {
    }
}

