/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.socket.gem.cutting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.socket.gem.cutting.GemCuttingRecipe;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public record BasicGemCuttingRecipe(Ingredient base, List<SizedIngredient> top, List<SizedIngredient> left, List<SizedIngredient> right, ItemStack output) implements GemCuttingRecipe
{
    public static MapCodec<BasicGemCuttingRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC.fieldOf("base").forGetter(BasicGemCuttingRecipe::base), (App)SizedIngredient.FLAT_CODEC.listOf().fieldOf("top").forGetter(BasicGemCuttingRecipe::top), (App)SizedIngredient.FLAT_CODEC.listOf().fieldOf("left").forGetter(BasicGemCuttingRecipe::left), (App)SizedIngredient.FLAT_CODEC.listOf().fieldOf("right").forGetter(BasicGemCuttingRecipe::right), (App)ItemStack.CODEC.fieldOf("output").forGetter(BasicGemCuttingRecipe::output)).apply((Applicative)inst, BasicGemCuttingRecipe::new));
    public static StreamCodec<RegistryFriendlyByteBuf, BasicGemCuttingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, BasicGemCuttingRecipe::base, (StreamCodec)SizedIngredient.STREAM_CODEC.apply(ByteBufCodecs.list()), BasicGemCuttingRecipe::top, (StreamCodec)SizedIngredient.STREAM_CODEC.apply(ByteBufCodecs.list()), BasicGemCuttingRecipe::left, (StreamCodec)SizedIngredient.STREAM_CODEC.apply(ByteBufCodecs.list()), BasicGemCuttingRecipe::right, (StreamCodec)ItemStack.STREAM_CODEC, BasicGemCuttingRecipe::output, BasicGemCuttingRecipe::new);

    public boolean matches(GemCuttingRecipe.CuttingRecipeInput input, Level level) {
        if (!this.base.test(input.getBase())) {
            return false;
        }
        return GemCuttingRecipe.anyMatch(input.getTop(), this.top) && GemCuttingRecipe.anyMatch(input.getLeft(), this.left) && GemCuttingRecipe.anyMatch(input.getRight(), this.right);
    }

    public ItemStack assemble(GemCuttingRecipe.CuttingRecipeInput input, HolderLookup.Provider registries) {
        return this.output.copy();
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.output.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @Override
    public void decrementInputs(GemCuttingRecipe.CuttingRecipeInput input, Level level) {
        SizedIngredient top = GemCuttingRecipe.getMatchOrThrow(input.getTop(), this.top);
        SizedIngredient left = GemCuttingRecipe.getMatchOrThrow(input.getLeft(), this.left);
        SizedIngredient right = GemCuttingRecipe.getMatchOrThrow(input.getRight(), this.right);
        input.getTop().shrink(top.count());
        input.getLeft().shrink(left.count());
        input.getRight().shrink(right.count());
    }

    @Override
    public boolean isValidBaseItem(GemCuttingRecipe.CuttingRecipeInput input, ItemStack stack) {
        return this.base.test(stack);
    }

    @Override
    public boolean isValidTopItem(GemCuttingRecipe.CuttingRecipeInput input, ItemStack stack) {
        return GemCuttingRecipe.anyMatch(stack, this.top);
    }

    @Override
    public boolean isValidLeftItem(GemCuttingRecipe.CuttingRecipeInput input, ItemStack stack) {
        return GemCuttingRecipe.anyMatch(stack, this.left);
    }

    @Override
    public boolean isValidRightItem(GemCuttingRecipe.CuttingRecipeInput input, ItemStack stack) {
        return GemCuttingRecipe.anyMatch(stack, this.right);
    }

    public static class Serializer
    implements RecipeSerializer<BasicGemCuttingRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public MapCodec<BasicGemCuttingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BasicGemCuttingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

