/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.item.PotionCharmItem;
import dev.shadowsoffire.apothic_enchanting.table.EnchantingStatRegistry;
import dev.shadowsoffire.apothic_enchanting.table.infusion.InfusionRecipe;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class CharmInfusionRecipe
extends InfusionRecipe {
    public CharmInfusionRecipe(EnchantingStatRegistry.Stats requirements, EnchantingStatRegistry.Stats maxRequirements) {
        super(CharmInfusionRecipe.charm(), CharmInfusionRecipe.potion(), requirements, maxRequirements);
    }

    private static ItemStack charm() {
        ItemStack out = new ItemStack(Apoth.Items.POTION_CHARM);
        out.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
        return out;
    }

    private static Ingredient potion() {
        ArrayList potionStacks = new ArrayList();
        BuiltInRegistries.POTION.holders().filter(PotionCharmItem::isValidPotion).forEach(p -> potionStacks.add(PotionContents.createItemStack((Item)((Item)Apoth.Items.POTION_CHARM.value()), (Holder)p)));
        return Ingredient.of((ItemStack[])potionStacks.toArray(new ItemStack[0]));
    }

    public boolean matches(ItemStack input, float eterna, float quanta, float arcana) {
        return !input.has(DataComponents.UNBREAKABLE) && super.matches(input, eterna, quanta, arcana);
    }

    public ItemStack assemble(ItemStack input, float eterna, float quanta, float arcana) {
        ItemStack out = input.copy();
        out.setDamageValue(0);
        out.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
        return out;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<CharmInfusionRecipe> {
        public static final MapCodec<CharmInfusionRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)EnchantingStatRegistry.Stats.CODEC.fieldOf("requirements").forGetter(InfusionRecipe::getRequirements), (App)EnchantingStatRegistry.Stats.CODEC.optionalFieldOf("max_requirements", (Object)InfusionRecipe.NO_MAX).forGetter(InfusionRecipe::getMaxRequirements)).apply((Applicative)inst, CharmInfusionRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CharmInfusionRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)EnchantingStatRegistry.Stats.STREAM_CODEC, InfusionRecipe::getRequirements, (StreamCodec)EnchantingStatRegistry.Stats.STREAM_CODEC, InfusionRecipe::getMaxRequirements, CharmInfusionRecipe::new);
        public static final Serializer INSTANCE = new Serializer();

        public MapCodec<CharmInfusionRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CharmInfusionRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

