/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.mobs.types;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.mobs.registries.EliteRegistry;
import dev.shadowsoffire.apotheosis.mobs.types.Invader;
import dev.shadowsoffire.apotheosis.mobs.util.AffixData;
import dev.shadowsoffire.apotheosis.mobs.util.BasicBossData;
import dev.shadowsoffire.apotheosis.mobs.util.BossStats;
import dev.shadowsoffire.apotheosis.mobs.util.SupportingEntity;
import dev.shadowsoffire.apotheosis.tiers.Constraints;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import dev.shadowsoffire.apotheosis.tiers.TieredWeights;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.json.ChancedEffectInstance;
import dev.shadowsoffire.placebo.json.RandomAttributeModifier;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.registries.holdersets.OrHolderSet;

public record Elite(BasicBossData basicData, float chance, HolderSet<EntityType<?>> entities, BossStats stats, AffixData afxData) implements CodecProvider<Elite>,
Constraints.Constrained,
TieredWeights.Weighted,
EliteRegistry.IEntityMatch
{
    public static final String MINIBOSS_KEY = "apoth.miniboss";
    public static final String PLAYER_KEY = "apoth.miniboss.player";
    public static final Codec<Elite> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)BasicBossData.CODEC.fieldOf("basic_data").forGetter(Elite::basicData), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("success_chance").forGetter(Elite::chance), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.ENTITY_TYPE).fieldOf("entities").forGetter(Elite::entities), (App)BossStats.CODEC.fieldOf("stats").forGetter(Elite::stats), (App)AffixData.CODEC.optionalFieldOf("affix_data", (Object)AffixData.DEFAULT).forGetter(Elite::afxData)).apply((Applicative)inst, Elite::new));

    @Override
    public TieredWeights weights() {
        return this.basicData.weights();
    }

    @Override
    public Constraints constraints() {
        return this.basicData.constraints();
    }

    public float getChance() {
        return this.chance;
    }

    @Override
    public HolderSet<EntityType<?>> getEntities() {
        return this.entities;
    }

    public void transformMiniboss(ServerLevelAccessor level, Mob mob, GenContext ctx) {
        CompoundTag nbt;
        Vec3 pos = mob.getPosition(0.0f);
        Optional<CompoundTag> optNbt = this.basicData.nbt();
        if (optNbt.isPresent() && (nbt = optNbt.get()).contains("Passengers")) {
            ListTag passengers = nbt.getList("Passengers", 10);
            for (int i = 0; i < passengers.size(); ++i) {
                Entity entity = EntityType.loadEntityRecursive((CompoundTag)passengers.getCompound(i), (Level)level.getLevel(), Function.identity());
                if (entity == null) continue;
                entity.setPos(pos);
                level.addFreshEntityWithPassengers(entity);
                entity.startRiding((Entity)mob, true);
            }
        }
        mob.setPos(pos);
        this.initElite(mob, ctx);
        if (optNbt.isPresent()) {
            mob.readAdditionalSaveData(optNbt.get());
        }
        if (this.basicData.hasMount()) {
            Mob mount = this.basicData().createMount(level, BlockPos.containing((Position)pos), mob);
            level.addFreshEntity((Entity)mount);
        }
        for (SupportingEntity support : this.basicData.support()) {
            Mob supportingMob = support.create(mob.level(), mob.getX() + 0.5, mob.getY(), mob.getZ() + 0.5);
            level.addFreshEntity((Entity)supportingMob);
        }
    }

    public void initElite(Mob mob, GenContext ctx) {
        int n;
        RandomSource rand = ctx.rand();
        mob.getPersistentData().putBoolean(MINIBOSS_KEY, true);
        int duration = mob instanceof Creeper ? 6000 : Integer.MAX_VALUE;
        for (ChancedEffectInstance chancedEffectInstance : this.stats.effects()) {
            if (!(rand.nextFloat() <= chancedEffectInstance.chance())) continue;
            mob.addEffect(chancedEffectInstance.create(rand, duration));
        }
        int i = 0;
        for (RandomAttributeModifier modif : this.stats.modifiers()) {
            modif.apply(this.createAttributeModifierId(i++), rand, (LivingEntity)mob);
        }
        this.basicData.applyEntityName(rand, mob);
        this.basicData.applyGearSet(mob, ctx);
        int n2 = -1;
        if (rand.nextFloat() <= this.afxData.chance()) {
            boolean anyValid = false;
            EquipmentSlot[] equipmentSlotArray = EquipmentSlot.values();
            int n3 = equipmentSlotArray.length;
            for (int j = 0; j < n3; ++j) {
                EquipmentSlot t = equipmentSlotArray[j];
                ItemStack s = mob.getItemBySlot(t);
                if (s.isEmpty() || LootCategory.forItem(s).isNone()) continue;
                anyValid = true;
                break;
            }
            if (!anyValid) {
                Apotheosis.LOGGER.error("Attempted to affix a miniboss with ID " + String.valueOf(EliteRegistry.INSTANCE.getKey(this)) + " but it is not wearing any affixable items!");
            } else {
                int n4 = rand.nextInt(6);
                ItemStack temp = mob.getItemBySlot(EquipmentSlot.values()[n4]);
                while (temp.isEmpty() || LootCategory.forItem(temp) == Apoth.LootCategories.NONE) {
                    n = rand.nextInt(6);
                    temp = mob.getItemBySlot(EquipmentSlot.values()[n]);
                }
                LootRarity rarity = LootRarity.random(ctx, this.afxData.rarities());
                mob.setCustomName((Component)mob.getCustomName().plainCopy().withStyle(Style.EMPTY.withColor(rarity.color())));
                Invader.modifyBossItem(temp, mob.getName(), ctx, rarity, this.stats, mob.level().registryAccess());
                mob.setDropChance(EquipmentSlot.values()[n], 2.0f);
            }
        }
        for (EquipmentSlot s : EquipmentSlot.values()) {
            ItemStack stack = mob.getItemBySlot(s);
            if (stack.isEmpty() || s.ordinal() == n || !(rand.nextFloat() < this.stats.enchantChance())) continue;
            Invader.enchantBossItem(rand, stack, this.stats.enchLevels().secondary(), true, mob.level().registryAccess());
            mob.setItemSlot(s, stack);
        }
        mob.setHealth(mob.getMaxHealth());
        this.basicData.appendBonusLoot(mob);
    }

    public Codec<? extends Elite> getCodec() {
        return CODEC;
    }

    protected ResourceLocation createAttributeModifierId(int index) {
        ResourceLocation key = EliteRegistry.INSTANCE.getKey(this);
        return ResourceLocation.fromNamespaceAndPath((String)key.getNamespace(), (String)("apothic_invader_" + key.getPath() + "_modif_" + index));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private BasicBossData basicData;
        private float chance = -1.0f;
        private HolderSet<EntityType<?>> entities = null;
        private BossStats stats;
        private AffixData afxData = AffixData.DEFAULT;

        public Builder basicData(UnaryOperator<BasicBossData.Builder> config) {
            this.basicData = ((BasicBossData.Builder)config.apply(BasicBossData.builder())).build();
            return this;
        }

        public Builder chance(float chance) {
            this.chance = chance;
            return this;
        }

        public Builder entities(HolderSet<EntityType<?>> entities) {
            this.entities = this.entities == null ? entities : new OrHolderSet(new HolderSet[]{this.entities, entities});
            return this;
        }

        public Builder entities(TagKey<EntityType<?>> entities) {
            return this.entities((HolderSet<EntityType<?>>)BuiltInRegistries.ENTITY_TYPE.getOrCreateTag(entities));
        }

        @SafeVarargs
        public final Builder entities(EntityType<? extends Mob> ... entities) {
            return this.entities((HolderSet<EntityType<?>>)HolderSet.direct(EntityType::builtInRegistryHolder, (Object[])entities));
        }

        public Builder stats(UnaryOperator<BossStats.Builder> config) {
            this.stats = ((BossStats.Builder)config.apply(BossStats.builder())).build();
            return this;
        }

        public Builder affixes(float chance, Set<LootRarity> rarities) {
            this.afxData = new AffixData(chance, rarities);
            return this;
        }

        public Elite build() {
            if (this.basicData == null) {
                throw new IllegalStateException("BasicBossData must be set");
            }
            if (this.chance <= 0.0f) {
                throw new IllegalStateException("Chance value must be positive");
            }
            if (this.entities == null) {
                throw new IllegalStateException("Entities must be set");
            }
            if (this.stats == null) {
                throw new IllegalStateException("Stats must be set");
            }
            return new Elite(this.basicData, this.chance, this.entities, this.stats, this.afxData);
        }
    }
}

