/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.loot.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.loot.AffixLootEntry;
import dev.shadowsoffire.apotheosis.loot.AffixLootRegistry;
import dev.shadowsoffire.apotheosis.loot.LootController;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.loot.modifiers.ContextualLootModifier;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import dev.shadowsoffire.apotheosis.util.LootPatternMatcher;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import org.jetbrains.annotations.Nullable;

public class AffixLootModifier
extends ContextualLootModifier {
    public static final MapCodec<AffixLootModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> AffixLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)AffixTableEntry.CODEC.listOf().fieldOf("entries").forGetter(g -> g.entries)).apply((Applicative)inst, AffixLootModifier::new));
    protected final List<AffixTableEntry> entries;

    public AffixLootModifier(LootItemCondition[] conditions, List<AffixTableEntry> entries) {
        super(conditions);
        this.entries = entries;
    }

    @Override
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext ctx, GenContext gCtx) {
        for (AffixTableEntry entry : this.entries) {
            AffixLootEntry lootEntry;
            if (!entry.pattern.matches(ctx.getQueriedLootTableId())) continue;
            if (!(ctx.getRandom().nextFloat() <= entry.chance())) break;
            LootRarity rarity = LootRarity.randomFromHolders(gCtx, entry.rarities);
            if (!entry.entries.isEmpty()) {
                List<WeightedEntry.Wrapper> resolved = entry.entries.stream().map(this::unwrap).filter(Objects::nonNull).map(e -> e.wrap(gCtx.tier(), gCtx.luck())).toList();
                lootEntry = (AffixLootEntry)((WeightedEntry.Wrapper)WeightedRandom.getRandomItem((RandomSource)ctx.getRandom(), resolved).get()).data();
            } else {
                lootEntry = AffixLootRegistry.INSTANCE.getRandomItem(gCtx);
            }
            ItemStack affixItem = LootController.createLootItem(lootEntry.stack(), rarity, gCtx);
            if (affixItem.isEmpty()) break;
            affixItem.set(Apoth.Components.FROM_CHEST, (Object)true);
            generatedLoot.add((Object)affixItem);
            break;
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    @Nullable
    private AffixLootEntry unwrap(DynamicHolder<AffixLootEntry> holder) {
        if (!holder.isBound()) {
            Apotheosis.LOGGER.error("An AffixLootModifier failed to resolve the AffixLootEntry {}!", (Object)holder.getId());
            return null;
        }
        return (AffixLootEntry)holder.get();
    }

    public record AffixTableEntry(LootPatternMatcher pattern, float chance, Set<DynamicHolder<AffixLootEntry>> entries, Set<DynamicHolder<LootRarity>> rarities) {
        public static final Codec<AffixTableEntry> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)LootPatternMatcher.CODEC.fieldOf("pattern").forGetter(AffixTableEntry::pattern), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance").forGetter(AffixTableEntry::chance), (App)PlaceboCodecs.setOf((Codec)AffixLootRegistry.INSTANCE.holderCodec()).optionalFieldOf("entries", Set.of()).forGetter(AffixTableEntry::entries), (App)PlaceboCodecs.setOf((Codec)RarityRegistry.INSTANCE.holderCodec()).optionalFieldOf("rarities", Set.of()).forGetter(AffixTableEntry::rarities)).apply((Applicative)inst, AffixTableEntry::new));
    }
}

