/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.loot;

import com.google.common.base.Preconditions;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.RarityOverride;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class RarityOverrideRegistry
extends DynamicRegistry<RarityOverride> {
    public static final RarityOverrideRegistry INSTANCE = new RarityOverrideRegistry();
    protected Map<LootCategory, RarityOverride> byCategory = new HashMap<LootCategory, RarityOverride>();

    public RarityOverrideRegistry() {
        super(Apotheosis.LOGGER, "rarity_override", true, false);
    }

    @Nullable
    public RarityOverride getOverride(LootCategory category) {
        return this.byCategory.get(category);
    }

    protected void registerBuiltinCodecs() {
        this.registerDefaultCodec(Apotheosis.loc("rarity_override"), RarityOverride.CODEC);
    }

    protected void validateItem(ResourceLocation key, RarityOverride value) {
        String path = key.getPath().replace('/', ':');
        ResourceLocation cat = ResourceLocation.tryParse((String)path);
        Preconditions.checkNotNull((Object)cat, (Object)("Invalid category path: " + path));
        LootCategory category = (LootCategory)Apoth.BuiltInRegs.LOOT_CATEGORY.get(cat);
        Preconditions.checkArgument((!category.isNone() ? 1 : 0) != 0, (Object)("Category not found: " + String.valueOf(cat)));
        Preconditions.checkArgument((value.category() == category ? 1 : 0) != 0, (Object)("Category mismatch: " + String.valueOf(value.category()) + " != " + String.valueOf(category)));
    }

    protected void beginReload() {
        super.beginReload();
        this.byCategory = new HashMap<LootCategory, RarityOverride>();
    }

    protected void onReload() {
        this.registry.forEach((key, value) -> {
            String path = key.getPath().replace('/', ':');
            ResourceLocation cat = ResourceLocation.tryParse((String)path);
            LootCategory category = (LootCategory)Apoth.BuiltInRegs.LOOT_CATEGORY.get(cat);
            RarityOverride old = this.byCategory.put(category, (RarityOverride)value);
            if (old != null) {
                this.logger.warn("Duplicate rarity override for category {}: Old: {}, New: {}", (Object)path, (Object)this.getKey(old), key);
            }
        });
    }
}

