/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.item;

import dev.shadowsoffire.apotheosis.AdventureConfig;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.placebo.tabs.ITabFiller;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.extensions.IHolderExtension;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;

public class PotionCharmItem
extends Item
implements ITabFiller {
    public PotionCharmItem() {
        super(new Item.Properties().stacksTo(1).durability(192).setNoRepair().component(Apoth.Components.CHARM_ENABLED, (Object)false));
    }

    public ItemStack getDefaultInstance() {
        return PotionContents.createItemStack((Item)this, (Holder)Potions.LONG_INVISIBILITY);
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean isSelected) {
        MobEffectInstance contained;
        ServerPlayer player;
        MobEffectInstance active;
        if (!PotionCharmItem.hasEffect(stack) || AdventureConfig.charmsInCuriosOnly && slot != -1) {
            return;
        }
        if (((Boolean)stack.get(Apoth.Components.CHARM_ENABLED)).booleanValue() && entity instanceof ServerPlayer && ((active = (player = (ServerPlayer)entity).getEffect((contained = PotionCharmItem.getEffect(stack)).getEffect())) == null || active.getDuration() < PotionCharmItem.getCriticalDuration((Holder<MobEffect>)active.getEffect()))) {
            int damage;
            int durationOffset = PotionCharmItem.getCriticalDuration((Holder<MobEffect>)contained.getEffect());
            if (contained.getEffect() == MobEffects.REGENERATION) {
                durationOffset += 50 >> contained.getAmplifier();
            }
            MobEffectInstance newEffect = new MobEffectInstance(contained.getEffect(), (int)Math.ceil((double)contained.getDuration() / 24.0) + durationOffset, contained.getAmplifier(), false, false);
            player.addEffect(newEffect);
            int n = damage = contained.getEffect() == MobEffects.REGENERATION ? 2 : 1;
            if (isSelected) {
                stack.hurtAndBreak(damage, (LivingEntity)player, EquipmentSlot.MAINHAND);
            } else {
                stack.hurtAndBreak(damage, (ServerLevel)player.level(), player, item -> {});
            }
        }
    }

    private static int getCriticalDuration(Holder<MobEffect> effect) {
        return effect.is(Apoth.Tags.EXTENDED_CHARM_DURATION) ? 210 : 5;
    }

    public boolean isFoil(ItemStack stack) {
        return (Boolean)stack.get(Apoth.Components.CHARM_ENABLED);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide) {
            stack.set(Apoth.Components.CHARM_ENABLED, (Object)((Boolean)stack.get(Apoth.Components.CHARM_ENABLED) == false ? 1 : 0));
        } else if (!((Boolean)stack.get(Apoth.Components.CHARM_ENABLED)).booleanValue()) {
            world.playSound(player, player.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 1.0f, 0.3f);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public boolean isPrimaryItemFor(ItemStack stack, Holder<Enchantment> enchantment) {
        return false;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag flag) {
        if (AdventureConfig.charmsInCuriosOnly) {
            tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".curios_only")).withStyle(ChatFormatting.RED));
        }
        if (PotionCharmItem.hasEffect(stack)) {
            MobEffectInstance inst = PotionCharmItem.getEffect(stack);
            MutableComponent potionCmp = Component.translatable((String)inst.getDescriptionId());
            if (inst.getAmplifier() > 0) {
                potionCmp = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{potionCmp, Component.translatable((String)("potion.potency." + inst.getAmplifier()))});
            }
            MobEffect effect = (MobEffect)inst.getEffect().value();
            potionCmp.withStyle(effect.getCategory().getTooltipFormatting());
            tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".desc"), (Object[])new Object[]{potionCmp}).withStyle(ChatFormatting.GRAY));
            boolean enabled = (Boolean)stack.get(Apoth.Components.CHARM_ENABLED);
            MutableComponent enabledCmp = Component.translatable((String)(this.getDescriptionId() + (enabled ? ".enabled" : ".disabled")));
            enabledCmp.withStyle(enabled ? ChatFormatting.BLUE : ChatFormatting.RED);
            if (inst.getDuration() > 20) {
                potionCmp = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{potionCmp, MobEffectUtil.formatDuration((MobEffectInstance)inst, (float)1.0f, (float)ctx.tickRate())});
            }
            potionCmp.withStyle(effect.getCategory().getTooltipFormatting());
            tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".desc3"), (Object[])new Object[]{potionCmp}).withStyle(ChatFormatting.GRAY));
        }
    }

    public int getMaxDamage(ItemStack stack) {
        if (!PotionCharmItem.hasEffect(stack)) {
            return 1;
        }
        return 192;
    }

    public Component getName(ItemStack stack) {
        if (!PotionCharmItem.hasEffect(stack)) {
            return Component.translatable((String)"item.apotheosis.potion_charm_broke");
        }
        MobEffectInstance effect = PotionCharmItem.getEffect(stack);
        MutableComponent potionCmp = Component.translatable((String)effect.getDescriptionId());
        if (effect.getAmplifier() > 0) {
            potionCmp = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{potionCmp, Component.translatable((String)("potion.potency." + effect.getAmplifier()))});
        }
        return Component.translatable((String)"item.apotheosis.potion_charm", (Object[])new Object[]{potionCmp});
    }

    public static boolean hasEffect(ItemStack stack) {
        PotionContents contents = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        return contents.getAllEffects().iterator().hasNext();
    }

    public static MobEffectInstance getEffect(ItemStack stack) {
        PotionContents contents = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        return (MobEffectInstance)contents.getAllEffects().iterator().next();
    }

    public void fillItemCategory(CreativeModeTab group, BuildCreativeModeTabContentsEvent out) {
        BuiltInRegistries.POTION.holders().filter(PotionCharmItem::isValidPotion).forEach(potion -> out.accept(PotionContents.createItemStack((Item)this, (Holder)potion)));
    }

    public String getCreatorModId(ItemStack itemStack) {
        ResourceLocation potionKey = ((PotionContents)itemStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).potion().map(IHolderExtension::getKey).map(ResourceKey::location).orElse(null);
        if (potionKey != null) {
            return potionKey.getNamespace();
        }
        return BuiltInRegistries.ITEM.getKey((Object)this).getNamespace();
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public static boolean isValidPotion(Holder<Potion> holder) {
        Potion potion = (Potion)holder.value();
        if (potion.getEffects().size() != 1) {
            return false;
        }
        MobEffect effect = (MobEffect)((MobEffectInstance)potion.getEffects().get(0)).getEffect().value();
        if (effect.isInstantenous()) {
            return false;
        }
        return !holder.is(Apoth.Tags.POTION_CHARM_BLACKLIST);
    }
}

