/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.gen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.AdventureConfig;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.spawner.RogueSpawner;
import dev.shadowsoffire.apotheosis.spawner.RogueSpawnerRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class RogueSpawnerFeature
extends Feature<Config> {
    public static final RuleTest STONE_TEST = new TagMatchTest(BlockTags.BASE_STONE_OVERWORLD);

    public RogueSpawnerFeature() {
        super(Config.CODEC);
    }

    public boolean place(FeaturePlaceContext<Config> ctx) {
        WorldGenLevel world = ctx.level();
        if (!AdventureConfig.canGenerateIn(world)) {
            return false;
        }
        BlockPos pos = ctx.origin();
        RandomSource rand = ctx.random();
        if (rand.nextFloat() <= ((Config)ctx.config()).successChance()) {
            BlockState state = world.getBlockState(pos);
            BlockState downState = world.getBlockState(pos.below());
            BlockState upState = world.getBlockState(pos.above());
            if (STONE_TEST.test(downState, rand) && upState.isAir() && (state.isAir() || STONE_TEST.test(state, rand))) {
                RogueSpawner item = (RogueSpawner)RogueSpawnerRegistry.INSTANCE.getRandomItem(rand);
                if (item == null) {
                    return false;
                }
                item.place(world, pos, rand);
                Apotheosis.debugLog(pos, "Rogue Spawner - " + String.valueOf(RogueSpawnerRegistry.INSTANCE.getKey(item)));
                return true;
            }
        }
        return false;
    }

    public record Config(float successChance) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("success_chance").forGetter(Config::successChance)).apply((Applicative)inst, Config::new));
    }
}

