/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.data;

import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.apotheosis.tiers.augments.AttributeAugment;
import dev.shadowsoffire.apotheosis.tiers.augments.TierAugment;
import dev.shadowsoffire.apotheosis.tiers.augments.TierAugmentRegistry;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import dev.shadowsoffire.placebo.json.RandomAttributeModifier;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import dev.shadowsoffire.placebo.util.StepFunction;
import dev.shadowsoffire.placebo.util.data.DynamicRegistryProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class TierAugmentProvider
extends DynamicRegistryProvider<TierAugment> {
    public TierAugmentProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, (DynamicRegistry)TierAugmentRegistry.INSTANCE);
    }

    public String getName() {
        return "Tier Augments";
    }

    public void generate() {
        this.addAttribute("frontier/armor", WorldTier.FRONTIER, TierAugment.Target.MONSTERS, 100, (Holder<Attribute>)Attributes.ARMOR, AttributeModifier.Operation.ADD_VALUE, 4.0f);
        this.addAttribute("frontier/experience", WorldTier.FRONTIER, TierAugment.Target.PLAYERS, 100, (Holder<Attribute>)ALObjects.Attributes.EXPERIENCE_GAINED, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 0.35f);
        this.addAttribute("frontier/luck", WorldTier.FRONTIER, TierAugment.Target.PLAYERS, 200, (Holder<Attribute>)Attributes.LUCK, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 0.2f);
        this.addAttribute("ascent/armor", WorldTier.ASCENT, TierAugment.Target.MONSTERS, 100, (Holder<Attribute>)Attributes.ARMOR, AttributeModifier.Operation.ADD_VALUE, 8.0f);
        this.addAttribute("ascent/armor_pierce", WorldTier.ASCENT, TierAugment.Target.MONSTERS, 200, (Holder<Attribute>)ALObjects.Attributes.ARMOR_PIERCE, AttributeModifier.Operation.ADD_VALUE, 5.0f);
        this.addAttribute("ascent/experience", WorldTier.ASCENT, TierAugment.Target.PLAYERS, 100, (Holder<Attribute>)ALObjects.Attributes.EXPERIENCE_GAINED, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 0.55f);
        this.addAttribute("ascent/luck", WorldTier.ASCENT, TierAugment.Target.PLAYERS, 200, (Holder<Attribute>)Attributes.LUCK, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 0.3f);
        this.addAttribute("summit/armor", WorldTier.SUMMIT, TierAugment.Target.MONSTERS, 100, (Holder<Attribute>)Attributes.ARMOR, AttributeModifier.Operation.ADD_VALUE, 12.0f);
        this.addAttribute("summit/armor_toughness", WorldTier.SUMMIT, TierAugment.Target.MONSTERS, 150, (Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, AttributeModifier.Operation.ADD_VALUE, 10.0f);
        this.addAttribute("summit/armor_pierce", WorldTier.SUMMIT, TierAugment.Target.MONSTERS, 200, (Holder<Attribute>)ALObjects.Attributes.ARMOR_PIERCE, AttributeModifier.Operation.ADD_VALUE, 15.0f);
        this.addAttribute("summit/prot_pierce", WorldTier.SUMMIT, TierAugment.Target.MONSTERS, 300, (Holder<Attribute>)ALObjects.Attributes.PROT_PIERCE, AttributeModifier.Operation.ADD_VALUE, 10.0f);
        this.addAttribute("summit/experience", WorldTier.SUMMIT, TierAugment.Target.PLAYERS, 100, (Holder<Attribute>)ALObjects.Attributes.EXPERIENCE_GAINED, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 0.75f);
        this.addAttribute("summit/luck", WorldTier.SUMMIT, TierAugment.Target.PLAYERS, 200, (Holder<Attribute>)Attributes.LUCK, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 0.5f);
        this.addAttribute("pinnacle/armor", WorldTier.PINNACLE, TierAugment.Target.MONSTERS, 100, (Holder<Attribute>)Attributes.ARMOR, AttributeModifier.Operation.ADD_VALUE, 16.0f);
        this.addAttribute("pinnacle/armor_toughness", WorldTier.PINNACLE, TierAugment.Target.MONSTERS, 150, (Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, AttributeModifier.Operation.ADD_VALUE, 20.0f);
        this.addAttribute("pinnacle/armor_pierce", WorldTier.PINNACLE, TierAugment.Target.MONSTERS, 200, (Holder<Attribute>)ALObjects.Attributes.ARMOR_PIERCE, AttributeModifier.Operation.ADD_VALUE, 25.0f);
        this.addAttribute("pinnacle/prot_pierce", WorldTier.PINNACLE, TierAugment.Target.MONSTERS, 300, (Holder<Attribute>)ALObjects.Attributes.PROT_PIERCE, AttributeModifier.Operation.ADD_VALUE, 20.0f);
        this.addAttribute("pinnacle/experience", WorldTier.PINNACLE, TierAugment.Target.PLAYERS, 100, (Holder<Attribute>)ALObjects.Attributes.EXPERIENCE_GAINED, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 1.25f);
        this.addAttribute("pinnacle/luck", WorldTier.PINNACLE, TierAugment.Target.PLAYERS, 200, (Holder<Attribute>)Attributes.LUCK, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 1.0f);
    }

    private void addAttribute(String path, WorldTier tier, TierAugment.Target target, int sortIdx, Holder<Attribute> attr, AttributeModifier.Operation op, float value) {
        ResourceLocation id = Apotheosis.loc(path);
        RandomAttributeModifier modif = new RandomAttributeModifier(attr, op, StepFunction.constant((float)value));
        this.add(id, new AttributeAugment(tier, target, sortIdx, modif, id));
    }
}

