/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.commands;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixRegistry;
import dev.shadowsoffire.apotheosis.affix.AffixType;
import dev.shadowsoffire.apotheosis.commands.RarityCommand;
import dev.shadowsoffire.apotheosis.loot.AffixLootRegistry;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.mobs.registries.EliteRegistry;
import dev.shadowsoffire.apotheosis.mobs.registries.InvaderRegistry;
import dev.shadowsoffire.apotheosis.socket.gem.GemRegistry;
import dev.shadowsoffire.apotheosis.tiers.Constraints;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import dev.shadowsoffire.apotheosis.tiers.TieredWeights;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class DebugWeightCommand {
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_AFFIX_TYPE = (ctx, builder) -> SharedSuggestionProvider.suggest(Arrays.stream(AffixType.values()).map(StringRepresentable::getSerializedName), (SuggestionsBuilder)builder);
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_LOOT_CATEGORY = (ctx, builder) -> SharedSuggestionProvider.suggest(Apoth.BuiltInRegs.LOOT_CATEGORY.keySet().stream().map(ResourceLocation::toString), (SuggestionsBuilder)builder);
    private static final DynamicCommandExceptionType UNKNOWN_RARITY = new DynamicCommandExceptionType(str -> () -> "Unknown Rarity: " + String.valueOf(str));
    private static final DynamicCommandExceptionType UNKNOWN_AFFIX_TYPE = new DynamicCommandExceptionType(str -> () -> "Unknown Affix Type: " + String.valueOf(str));

    public static void register(LiteralArgumentBuilder<CommandSourceStack> root, CommandBuildContext ctx) {
        LiteralArgumentBuilder weights = Commands.literal((String)"weights");
        weights.then(Commands.literal((String)"affix_loot_entries").executes(c -> DebugWeightCommand.dumpWeights((CommandContext<CommandSourceStack>)c, AffixLootRegistry.INSTANCE)));
        weights.then(Commands.literal((String)"affixes").then(Commands.argument((String)"item", (ArgumentType)ItemArgument.item((CommandBuildContext)ctx)).then(Commands.argument((String)"type", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_AFFIX_TYPE).then(Commands.argument((String)"rarity", (ArgumentType)ResourceLocationArgument.id()).suggests(RarityCommand.SUGGEST_RARITY).executes(c -> DebugWeightCommand.dumpAffixWeights((CommandContext<CommandSourceStack>)c, ItemArgument.getItem((CommandContext)c, (String)"item"), StringArgumentType.getString((CommandContext)c, (String)"type"), ResourceLocationArgument.getId((CommandContext)c, (String)"rarity")))))));
        weights.then(Commands.literal((String)"elites").executes(c -> DebugWeightCommand.dumpWeights((CommandContext<CommandSourceStack>)c, EliteRegistry.INSTANCE)));
        weights.then(Commands.literal((String)"gems").executes(c -> DebugWeightCommand.dumpWeights((CommandContext<CommandSourceStack>)c, GemRegistry.INSTANCE)));
        weights.then(Commands.literal((String)"invaders").executes(c -> DebugWeightCommand.dumpWeights((CommandContext<CommandSourceStack>)c, InvaderRegistry.INSTANCE)));
        weights.then(Commands.literal((String)"rarities").executes(c -> DebugWeightCommand.dumpWeights((CommandContext<CommandSourceStack>)c, RarityRegistry.INSTANCE)));
        root.then((ArgumentBuilder)weights);
    }

    public static <T extends CodecProvider<? super T> & TieredWeights.Weighted> void dumpWeightsFor(GenContext ctx, DynamicRegistry<T> registry) {
        DebugWeightCommand.dumpWeightsFor(ctx, registry, Predicates.alwaysTrue());
    }

    public static <T extends CodecProvider<? super T> & TieredWeights.Weighted> void dumpWeightsFor(GenContext ctx, DynamicRegistry<T> registry, Predicate<T> filter) {
        Collection values = registry.getValues();
        ArrayList<WeightedEntry.Wrapper> list = new ArrayList<WeightedEntry.Wrapper>(values.size());
        values.stream().filter(filter).map(t -> DebugWeightCommand.wrapWithConstraints(ctx, t)).forEach(list::add);
        float total = WeightedRandom.getTotalWeight(list);
        Apotheosis.LOGGER.info("Starting dump of all {} weights...", (Object)registry.getPath());
        Apotheosis.LOGGER.info("Current GenContext: {}", (Object)ctx);
        Comparator<WeightedEntry.Wrapper> comparator = Comparator.comparing(w -> -w.weight().asInt());
        comparator = comparator.thenComparing(Comparator.comparing(w -> registry.getKey((CodecProvider)w.data()).toString()));
        list.sort(comparator);
        for (WeightedEntry.Wrapper entry : list) {
            ResourceLocation key = registry.getKey((CodecProvider)entry.data());
            float chance = (float)entry.weight().asInt() / total;
            Apotheosis.LOGGER.info("{} : {}% ({} / {}}", (Object)key, (Object)Affix.fmt(chance * 100.0f), (Object)entry.weight().asInt(), (Object)((int)total));
        }
    }

    public static <T extends CodecProvider<? super T> & TieredWeights.Weighted> int dumpWeights(CommandContext<CommandSourceStack> c, DynamicRegistry<T> registry) throws CommandSyntaxException {
        GenContext ctx = GenContext.forPlayer((Player)((CommandSourceStack)c.getSource()).getPlayerOrException());
        DebugWeightCommand.dumpWeightsFor(ctx, registry);
        ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Weight values have been dumped to the log file."), true);
        return 0;
    }

    private static <T extends TieredWeights.Weighted> WeightedEntry.Wrapper<T> wrapWithConstraints(GenContext ctx, T t) {
        Constraints.Constrained c;
        if (t instanceof Constraints.Constrained && !(c = (Constraints.Constrained)((Object)t)).constraints().test(ctx)) {
            return new WeightedEntry.Wrapper(t, TieredWeights.Weighted.SAFE_ZERO);
        }
        return t.wrap(ctx.tier(), ctx.luck());
    }

    private static int dumpAffixWeights(CommandContext<CommandSourceStack> c, ItemInput item, String typeStr, ResourceLocation rarityId) throws CommandSyntaxException {
        LootRarity rarity = (LootRarity)RarityRegistry.INSTANCE.getValue(rarityId);
        if (rarity == null) {
            throw UNKNOWN_RARITY.create((Object)rarityId);
        }
        AffixType type = (AffixType)((Object)((Pair)AffixType.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)new JsonPrimitive(typeStr)).getOrThrow(s -> UNKNOWN_AFFIX_TYPE.create((Object)typeStr))).getFirst());
        ItemStack stack = item.createItemStack(1, false);
        LootCategory cat = LootCategory.forItem(stack);
        Apotheosis.LOGGER.info("Affix weight dump target item: " + stack.toString());
        GenContext ctx = GenContext.forPlayer((Player)((CommandSourceStack)c.getSource()).getPlayerOrException());
        DebugWeightCommand.dumpWeightsFor(ctx, AffixRegistry.INSTANCE, afx -> afx.canApplyTo(stack, cat, rarity) && afx.definition().type() == type);
        ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Weight values have been dumped to the log file."), true);
        return 0;
    }
}

